/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.block_entity;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.internal.ManaNetwork;
import vazkii.botania.api.mana.ManaPool;

public abstract class FunctionalFlowerBlockEntity
extends BindableSpecialFlowerBlockEntity<ManaPool> {
    private static final class_2960 POOL_ID = new class_2960("botania", "mana_pool");
    public static final int LINK_RANGE = 10;
    private static final String TAG_MANA = "mana";
    private int mana;
    public int redstoneSignal = 0;

    public FunctionalFlowerBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state, ManaPool.class);
    }

    public boolean acceptsRedstone() {
        return false;
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        this.drawManaFromPool();
        this.redstoneSignal = 0;
        if (this.acceptsRedstone()) {
            for (class_2350 dir : class_2350.values()) {
                int redstoneSide = this.method_10997().method_49808(this.method_11016().method_10093(dir), dir);
                this.redstoneSignal = Math.max(this.redstoneSignal, redstoneSide);
            }
        }
        if (this.method_10997().field_9236) {
            double particleChance = 1.0 - (double)this.mana / (double)this.getMaxMana() / 3.5;
            int color = this.getColor();
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            if (Math.random() > particleChance) {
                BotaniaAPI.instance().sparkleFX(this.method_10997(), (double)this.method_11016().method_10263() + 0.3 + Math.random() * 0.5, (double)this.method_11016().method_10264() + 0.5 + Math.random() * 0.5, (double)this.method_11016().method_10260() + 0.3 + Math.random() * 0.5, red, green, blue, (float)Math.random(), 5);
            }
        }
    }

    @Override
    public int getBindingRadius() {
        return 10;
    }

    @Override
    @Nullable
    public class_2338 findClosestTarget() {
        ManaNetwork network = BotaniaAPI.instance().getManaNetworkInstance();
        ManaPool closestPool = network.getClosestPool(this.method_11016(), this.method_10997(), this.getBindingRadius());
        return closestPool == null ? null : closestPool.getManaReceiverPos();
    }

    public void drawManaFromPool() {
        ManaPool pool = (ManaPool)this.findBoundTile();
        if (pool != null) {
            int manaInPool = pool.getCurrentMana();
            int manaMissing = this.getMaxMana() - this.mana;
            int manaToRemove = Math.min(manaMissing, manaInPool);
            pool.receiveMana(-manaToRemove);
            this.addMana(manaToRemove);
        }
    }

    @Override
    public int getMana() {
        return this.mana;
    }

    @Override
    public void addMana(int mana) {
        this.mana = class_3532.method_15340((int)(this.mana + mana), (int)0, (int)this.getMaxMana());
        this.method_5431();
    }

    @Override
    public class_1799 getDefaultHudIcon() {
        return class_7923.field_41178.method_17966(POOL_ID).map(class_1799::new).orElse(class_1799.field_8037);
    }

    @Override
    public void readFromPacketNBT(class_2487 cmp) {
        super.readFromPacketNBT(cmp);
        this.mana = cmp.method_10550(TAG_MANA);
    }

    @Override
    public void writeToPacketNBT(class_2487 cmp) {
        super.writeToPacketNBT(cmp);
        cmp.method_10569(TAG_MANA, this.mana);
    }
}

