/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.lib;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

import net.minecraft.class_1299;
import net.minecraft.class_1767;
import net.minecraft.class_1792;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2582;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8110;

public class BotaniaTags {
	public static class Items {
		public static final class_6862<class_1792> DUSTS_MANA = tag("mana_dusts");

		public static final class_6862<class_1792> GEMS_DRAGONSTONE = tag("dragonstone_gems");
		public static final class_6862<class_1792> GEMS_MANA_DIAMOND = tag("mana_diamond_gems");

		public static final class_6862<class_1792> INGOTS_ELEMENTIUM = tag("elementium_ingots");
		public static final class_6862<class_1792> INGOTS_MANASTEEL = tag("manasteel_ingots");
		public static final class_6862<class_1792> INGOTS_TERRASTEEL = tag("terrasteel_ingots");

		public static final class_6862<class_1792> NUGGETS_ELEMENTIUM = tag("elementium_nuggets");
		public static final class_6862<class_1792> NUGGETS_MANASTEEL = tag("manasteel_nuggets");
		public static final class_6862<class_1792> NUGGETS_TERRASTEEL = tag("terrasteel_nuggets");

		public static final class_6862<class_1792> BLOCKS_ELEMENTIUM = tag("elementium_blocks");
		public static final class_6862<class_1792> BLOCKS_MANASTEEL = tag("manasteel_blocks");
		public static final class_6862<class_1792> BLOCKS_TERRASTEEL = tag("terrasteel_blocks");

		public static final class_6862<class_1792> MYSTICAL_FLOWERS = tag("mystical_flowers");
		public static final class_6862<class_1792> DOUBLE_MYSTICAL_FLOWERS = tag("double_mystical_flowers");
		public static final class_6862<class_1792> SHIMMERING_MUSHROOMS = tag("shimmering_mushrooms");

		/**
		 * Items in this tag can be specified as contributor headflowers
		 */
		public static final class_6862<class_1792> CONTRIBUTOR_HEADFLOWERS = tag("contributor_headflowers");
		public static final class_6862<class_1792> SPECIAL_FLOWERS = tag("special_flowers");
		public static final class_6862<class_1792> MINI_FLOWERS = tag("mini_flowers");
		public static final class_6862<class_1792> MISC_SPECIAL_FLOWERS = tag("misc_special_flowers");
		public static final class_6862<class_1792> FUNCTIONAL_SPECIAL_FLOWERS = tag("functional_special_flowers");
		public static final class_6862<class_1792> GENERATING_SPECIAL_FLOWERS = tag("generating_special_flowers");

		public static final class_6862<class_1792> FLOATING_FLOWERS = tag("floating_flowers");
		public static final class_6862<class_1792> MUNDANE_FLOATING_FLOWERS = tag("mundane_floating_flowers");
		public static final class_6862<class_1792> SPECIAL_FLOATING_FLOWERS = tag("special_floating_flowers");

		public static final class_6862<class_1792> LENS = tag("lens");

		public static final class_6862<class_1792> LENS_GLUE = tag("lens_glue");

		/**
		 * Items in this tag cannot be pulled by the magnet rings
		 */
		public static final class_6862<class_1792> MAGNET_RING_BLACKLIST = tag("magnet_ring_blacklist");
		/**
		 * Items in this tag cannot be rolled by Looniums
		 */
		public static final class_6862<class_1792> LOONIUM_BLACKLIST = tag("loonium_blacklist");
		/**
		 * Items that should be equipped in the offhand slot if rolled as Loonium mob equipment,
		 * instead of the default slot for the item.
		 */
		public static final class_6862<class_1792> LOONIUM_OFFHAND_EQUIPMENT = tag("loonium_offhand_equipment");

		/**
		 * Items in this tag are voided by the Elementium Pick
		 */
		public static final class_6862<class_1792> DISPOSABLE = tag("disposable");
		/**
		 * Items in this tag are voided by the Elementium Pick when not shifting
		 */
		public static final class_6862<class_1792> SEMI_DISPOSABLE = tag("semi_disposable");

		public static final class_6862<class_1792> PETALS = tag("petals");
		public static final class_6862<class_1792> PETALS_BLACK = tag("petals/black");
		public static final class_6862<class_1792> PETALS_BLUE = tag("petals/blue");
		public static final class_6862<class_1792> PETALS_BROWN = tag("petals/brown");
		public static final class_6862<class_1792> PETALS_CYAN = tag("petals/cyan");
		public static final class_6862<class_1792> PETALS_GRAY = tag("petals/gray");
		public static final class_6862<class_1792> PETALS_GREEN = tag("petals/green");
		public static final class_6862<class_1792> PETALS_LIGHT_BLUE = tag("petals/light_blue");
		public static final class_6862<class_1792> PETALS_LIGHT_GRAY = tag("petals/light_gray");
		public static final class_6862<class_1792> PETALS_LIME = tag("petals/lime");
		public static final class_6862<class_1792> PETALS_MAGENTA = tag("petals/magenta");
		public static final class_6862<class_1792> PETALS_ORANGE = tag("petals/orange");
		public static final class_6862<class_1792> PETALS_PINK = tag("petals/pink");
		public static final class_6862<class_1792> PETALS_PURPLE = tag("petals/purple");
		public static final class_6862<class_1792> PETALS_RED = tag("petals/red");
		public static final class_6862<class_1792> PETALS_WHITE = tag("petals/white");
		public static final class_6862<class_1792> PETALS_YELLOW = tag("petals/yellow");

		public static final class_6862<class_1792> RUNES = tag("runes");

		public static final class_6862<class_1792> LIVINGWOOD_LOGS = tag("livingwood_logs");
		public static final class_6862<class_1792> DREAMWOOD_LOGS = tag("dreamwood_logs");
		public static final class_6862<class_1792> LIVINGWOOD_LOGS_GLIMMERING = tag("glimmering_livingwood_logs");
		public static final class_6862<class_1792> DREAMWOOD_LOGS_GLIMMERING = tag("glimmering_dreamwood_logs");

		/**
		 * Items in this tag allow wearing players to see bursts through walls and flower radii
		 */
		public static final class_6862<class_1792> BURST_VIEWERS = tag("burst_viewers");
		/**
		 * Items in this tag cannot give mana to the terra pick
		 */
		public static final class_6862<class_1792> TERRA_PICK_BLACKLIST = tag("terra_pick_blacklist");
		public static final class_6862<class_1792> RODS = tag("rods");
		/**
		 * Items in this tag may consume mana
		 */
		public static final class_6862<class_1792> MANA_USING_ITEMS = tag("mana_using_items");
		public static final class_6862<class_1792> SEED_APOTHECARY_REAGENT = tag("seed_apothecary_reagent");

		public static class_6862<class_1792> getPetalTag(class_1767 color) {
			return switch (color) {
				case field_7952 -> PETALS_WHITE;
				case field_7946 -> PETALS_ORANGE;
				case field_7958 -> PETALS_MAGENTA;
				case field_7951 -> PETALS_LIGHT_BLUE;
				case field_7947 -> PETALS_YELLOW;
				case field_7961 -> PETALS_LIME;
				case field_7954 -> PETALS_PINK;
				case field_7944 -> PETALS_GRAY;
				case field_7967 -> PETALS_LIGHT_GRAY;
				case field_7955 -> PETALS_CYAN;
				case field_7945 -> PETALS_PURPLE;
				case field_7966 -> PETALS_BLUE;
				case field_7957 -> PETALS_BROWN;
				case field_7942 -> PETALS_GREEN;
				case field_7964 -> PETALS_RED;
				case field_7963 -> PETALS_BLACK;
			};
		}

		private static class_6862<class_1792> tag(String name) {
			return class_6862.method_40092(class_7924.field_41197, prefix(name));
		}
	}

	public static class Blocks {
		public static final class_6862<class_2248> MYSTICAL_FLOWERS = tag("mystical_flowers");
		public static final class_6862<class_2248> SHINY_FLOWERS = tag("shiny_flowers");
		public static final class_6862<class_2248> DOUBLE_MYSTICAL_FLOWERS = tag("double_mystical_flowers");
		public static final class_6862<class_2248> SHIMMERING_MUSHROOMS = tag("shimmering_mushrooms");

		public static final class_6862<class_2248> SPECIAL_FLOWERS = tag("special_flowers");
		public static final class_6862<class_2248> MINI_FLOWERS = tag("mini_flowers");
		public static final class_6862<class_2248> MISC_SPECIAL_FLOWERS = tag("misc_special_flowers");
		public static final class_6862<class_2248> FUNCTIONAL_SPECIAL_FLOWERS = tag("functional_special_flowers");
		public static final class_6862<class_2248> GENERATING_SPECIAL_FLOWERS = tag("generating_special_flowers");

		public static final class_6862<class_2248> FLOATING_FLOWERS = tag("floating_flowers");
		public static final class_6862<class_2248> MUNDANE_FLOATING_FLOWERS = tag("mundane_floating_flowers");
		public static final class_6862<class_2248> SPECIAL_FLOATING_FLOWERS = tag("special_floating_flowers");

		/**
		 * Blocks in this tag can be used in the Enchanter multiblock
		 */
		public static final class_6862<class_2248> ENCHANTER_FLOWERS = tag("enchanter_flowers");

		public static final class_6862<class_2248> LIVINGWOOD_LOGS = tag("livingwood_logs");
		public static final class_6862<class_2248> DREAMWOOD_LOGS = tag("dreamwood_logs");
		public static final class_6862<class_2248> LIVINGWOOD_LOGS_GLIMMERING = tag("glimmering_livingwood_logs");
		public static final class_6862<class_2248> DREAMWOOD_LOGS_GLIMMERING = tag("glimmering_dreamwood_logs");

		public static final class_6862<class_2248> BLOCKS_ELEMENTIUM = tag("elementium_blocks");
		public static final class_6862<class_2248> BLOCKS_MANASTEEL = tag("manasteel_blocks");
		public static final class_6862<class_2248> BLOCKS_TERRASTEEL = tag("terrasteel_blocks");

		/**
		 * Blocks in this tag are exempt from the Gaia Guardian's block smash attack
		 */
		public static final class_6862<class_2248> GAIA_BREAK_BLACKLIST = tag("gaia_break_blacklist");
		/**
		 * Items resting on blocks in this tag cannot be pulled by magnet rings
		 */
		public static final class_6862<class_2248> MAGNET_RING_BLACKLIST = tag("magnet_ring_blacklist");
		/**
		 * Blocks in this tag cannot be moved by the Laputa Shard
		 */
		public static final class_6862<class_2248> LAPUTA_IMMOBILE = tag("laputa_immobile");
		/**
		 * Blocks in this tag should not be treated like a 2-high double block by the Laputa Shard, even though they
		 * have the {@link net.minecraft.class_2741#field_12533}
		 * property.
		 */
		public static final class_6862<class_2248> LAPUTA_NO_DOUBLE_BLOCK = tag("laputa_no_double_block");

		/**
		 * Blocks in this tag can be removed by the Rod of Terra Firma
		 */
		public static final class_6862<class_2248> TERRAFORMABLE = tag("terraformable");

		/**
		 * Blocks in this tag can have corporea sparks placed on them even though they have no inventory
		 */
		public static final class_6862<class_2248> CORPOREA_SPARK_OVERRIDE = tag("corporea_spark_override");
		/**
		 * Blocks in this tag can sub for livingrock in the terra plate multiblock
		 */
		public static final class_6862<class_2248> TERRA_PLATE_BASE = tag("terra_plate_base");
		public static final class_6862<class_2248> GHOST_RAIL_BARRIER = tag("ghost_rail_barrier");

		/**
		 * Blocks in this tag can be turned into end stone by ender air
		 */
		public static final class_6862<class_2248> ENDER_AIR_CONVERTABLE = tag("ender_air_convertable");

		/**
		 * Blocks in this tag can be turned into metamorphic stones by the marimorphosis
		 */
		public static final class_6862<class_2248> MARIMORPHOSIS_CONVERTABLE = tag("marimorphosis_convertable");

		/**
		 * Blocks in this tag are affected by the weight lens even if they don't drop themselves with silk touch.
		 */
		public static final class_6862<class_2248> WEIGHT_LENS_WHITELIST = tag("weight_lens_whitelist");

		/**
		 * Blocks in this tag can be broken by the Horn of the Wild,
		 * in addition to any {@code BushBlock}s that are not part of the {@link #SPECIAL_FLOWERS} tag.
		 */
		public static final class_6862<class_2248> HORN_OF_THE_WILD_BREAKABLE = tag("horn_of_the_wild_breakable");

		/**
		 * Blocks in this tag can be broken by the Horn of the Canopy
		 */
		public static final class_6862<class_2248> HORN_OF_THE_CANOPY_BREAKABLE = tag("horn_of_the_canopy_breakable");

		/**
		 * Blocks in this tag can be broken by the Horn of the Canopy
		 */
		public static final class_6862<class_2248> HORN_OF_THE_COVERING_BREAKABLE = tag("horn_of_the_covering_breakable");

		/**
		 * Blocks in this tag are candidates for the Agricarnation's growth boost, assuming they accept random ticks.
		 */
		public static final class_6862<class_2248> AGRICARNATION_GROWTH_CANDIDATE = tag("agricarnation/growth_candidate");
		/**
		 * Blocks in this tag are ignored by the Agricarnation, even if they look like they are growable plants.
		 */
		public static final class_6862<class_2248> AGRICARNATION_GROWTH_EXCLUDED = tag("agricarnation/growth_excluded");
		/**
		 * Blocks in this tag will have their growth boosted as if bonemeal was applied, instead of via random ticks.
		 * These plants need to pass the bonemeal success check twice to get a boost, but mana will be consumed even if
		 * that fails.
		 */
		public static final class_6862<class_2248> AGRICARNATION_APPLY_BONEMEAL = tag("agricarnation/apply_bonemeal");

		/**
		 * Blocks in this tag can not have their state manipulated by a wand of the forest
		 */
		public static final class_6862<class_2248> UNWANDABLE = tag("unwandable");

		/**
		 * Blocks in this tag can be replaced by the spreading effect of Pasture Seeds and related items.
		 */
		public static final class_6862<class_2248> PASTURE_SEED_REPLACEABLE = tag("pasture_seed_replaceable");

		/**
		 * Blocks in this tag are considered when checking for unethical TNT sources. Blocks only need to be added
		 * to this tag if their implementation does not extend {@link net.minecraft.class_2530}.
		 */
		public static final class_6862<class_2248> UNETHICAL_TNT_CHECK = tag("unethical_tnt_check");

		/**
		 * Blocks in this tag work better for inserting items if they don't receive more than one item at a time.
		 * Example: The vanilla crafter block, which selectively opens inventory slots to distribute matching items.
		 */
		public static final class_6862<class_2248> SINGLE_ITEM_INSERT = tag("single_item_insert");

		private static class_6862<class_2248> tag(String name) {
			return class_6862.method_40092(class_7924.field_41254, prefix(name));
		}
	}

	public static class Entities {
		/**
		 * Entities in this tag cannot be picked up by the Rod of the Shaded Mesa
		 */
		public static final class_6862<class_1299<?>> SHADED_MESA_BLACKLIST = tag("shaded_mesa_blacklist");

		public static final class_6862<class_1299<?>> COCOON_COMMON = tag("cocoon/common");
		public static final class_6862<class_1299<?>> COCOON_RARE = tag("cocoon/rare");
		public static final class_6862<class_1299<?>> COCOON_COMMON_AQUATIC = tag("cocoon/common_aquatic");
		public static final class_6862<class_1299<?>> COCOON_RARE_AQUATIC = tag("cocoon/rare_aquatic");

		/**
		 * The Drum of the Gathering fills milk buckets for mobs in this tag.
		 */
		public static final class_6862<class_1299<?>> DRUM_MILKABLE = tag("drum/milkable");

		/**
		 * The Drum of the Gathering will not shear mobs in this tag, even if they could be sheared.
		 */
		public static final class_6862<class_1299<?>> DRUM_NO_SHEARING = tag("drum/no_shearing");

		/**
		 * Entities in this tag are immune to damage from the Key of the King's Law
		 */
		public static final class_6862<class_1299<?>> KEY_IMMUNE = tag("key_immune");

		private static class_6862<class_1299<?>> tag(String name) {
			return class_6862.method_40092(class_7924.field_41266, prefix(name));
		}
	}

	public static class Biomes {
		public static final class_6862<class_1959> MARIMORPHOSIS_DESERT_BONUS = tag("marimorphosis_desert_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_FOREST_BONUS = tag("marimorphosis_forest_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_FUNGAL_BONUS = tag("marimorphosis_fungal_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_MESA_BONUS = tag("marimorphosis_mesa_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_MOUNTAIN_BONUS = tag("marimorphosis_mountain_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_PLAINS_BONUS = tag("marimorphosis_plains_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_SWAMP_BONUS = tag("marimorphosis_swamp_bonus");
		public static final class_6862<class_1959> MARIMORPHOSIS_TAIGA_BONUS = tag("marimorphosis_taiga_bonus");

		/**
		 * Biomes in this tag are eligible for the mystical_flower placed_feature.
		 */
		public static final class_6862<class_1959> MYSTICAL_FLOWER_SPAWNLIST = tag("mystical_flower_spawnlist");

		/**
		 * Biomes in this tag are blocked from having the mystical_flower placed_feature.
		 * Overrides mystical_flowers_spawnlist tag.
		 */
		public static final class_6862<class_1959> MYSTICAL_FLOWER_BLOCKLIST = tag("mystical_flower_blocklist");

		/**
		 * Biomes in this tag are eligible for the mystical_mushroom placed_feature.
		 */
		public static final class_6862<class_1959> MYSTICAL_MUSHROOM_SPAWNLIST = tag("mystical_mushroom_spawnlist");

		/**
		 * Biomes in this tag are blocked from having the mystical_mushroom placed_feature.
		 * Overrides mystical_mushroom_spawnlist tag.
		 */
		public static final class_6862<class_1959> MYSTICAL_MUSHROOM_BLOCKLIST = tag("mystical_mushroom_blocklist");

		private static class_6862<class_1959> tag(String name) {
			return class_6862.method_40092(class_7924.field_41236, prefix(name));
		}
	}

	public static class BannerPatterns {
		public static final class_6862<class_2582> PATTERN_ITEM_LIVINGWOOD_TWIG = tag("pattern_item/livingwood_twig");
		public static final class_6862<class_2582> PATTERN_ITEM_LEXICON = tag("pattern_item/lexicon");
		public static final class_6862<class_2582> PATTERN_ITEM_TERRASTEEL = tag("pattern_item/terrasteel");
		public static final class_6862<class_2582> PATTERN_ITEM_DREAMWOOD_TWIG = tag("pattern_item/dreamwood_twig");
		public static final class_6862<class_2582> PATTERN_ITEM_TINY_POTATO = tag("pattern_item/tiny_potato");
		public static final class_6862<class_2582> PATTERN_ITEM_SPARK_DISPERSIVE = tag("pattern_item/spark_dispersive");
		public static final class_6862<class_2582> PATTERN_ITEM_SPARK_DOMINANT = tag("pattern_item/spark_dominant");
		public static final class_6862<class_2582> PATTERN_ITEM_SPARK_RECESSIVE = tag("pattern_item/spark_recessive");
		public static final class_6862<class_2582> PATTERN_ITEM_SPARK_ISOLATED = tag("pattern_item/spark_isolated");

		private static class_6862<class_2582> tag(String name) {
			return class_6862.method_40092(class_7924.field_41252, prefix(name));
		}
	}

	public static class DamageTypes {
		public static final class_6862<class_8110> RING_OF_ODIN_IMMUNE = tag("ring_of_odin_immune");

		private static class_6862<class_8110> tag(String name) {
			return class_6862.method_40092(class_7924.field_42534, prefix(name));
		}
	}
}
