/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.*;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2392;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_332;

public class CorporeaSparkEntity extends SparkBaseEntity implements CorporeaSpark {
	private static final int SCAN_RANGE = 8;

	private static final String TAG_MASTER = "master";
	private static final String TAG_CREATIVE = "creative";

	private static final class_2940<Boolean> MASTER = class_2945.method_12791(CorporeaSparkEntity.class, class_2943.field_13323);
	private static final class_2940<Boolean> CREATIVE = class_2945.method_12791(CorporeaSparkEntity.class, class_2943.field_13323);

	private CorporeaSpark master;
	private Set<CorporeaSpark> connections = new LinkedHashSet<>();
	private List<CorporeaSpark> relatives = new ArrayList<>();
	private boolean field_5953 = true;

	public CorporeaSparkEntity(class_1299<CorporeaSparkEntity> type, class_1937 world) {
		super(type, world);
	}

	@Override
	protected void method_5693() {
		super.method_5693();
		field_6011.method_12784(MASTER, false);
		field_6011.method_12784(CREATIVE, false);
	}

	@NotNull
	@Override
	public class_1799 method_31480() {
		return new class_1799(getSparkItem());
	}

	@Override
	public void method_5773() {
		if (method_37908().field_9236) {
			return;
		}

		CorporeaNode node = getSparkNode();
		if (node instanceof DummyCorporeaNode && !method_37908().method_8320(getAttachPos()).method_26164(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
			dropAndKill();
			return;
		}

		if (isMaster()) {
			master = this;
		}

		if (field_5953) {
			if (isMaster()) {
				restartNetwork();
			} else {
				findNetwork();
			}

			field_5953 = false;
		}

		if (master != null && (!master.entity().method_5805() || master.getNetwork() != getNetwork())) {
			master = null;
		}
	}

	private void dropAndKill() {
		method_5699(new class_1799(getSparkItem()), 0F);
		method_31472();
	}

	protected class_1792 getSparkItem() {
		return isCreative() ? BotaniaItems.corporeaSparkCreative : isMaster() ? BotaniaItems.corporeaSparkMaster : BotaniaItems.corporeaSpark;
	}

	@Override
	public void method_5650(class_5529 reason) {
		super.method_5650(reason);
		connections.remove(this);
		restartNetwork();
	}

	@Override
	public void introduceNearbyTo(Set<CorporeaSpark> network, CorporeaSpark master) {
		relatives.clear();
		for (CorporeaSpark spark : getNearbySparks()) {
			if (spark == null || network.contains(spark)
					|| spark.getNetwork() != getNetwork()
					|| spark.isMaster() || !spark.entity().method_5805()) {
				continue;
			}

			network.add(spark);
			relatives.add(spark);
			spark.introduceNearbyTo(network, master);
		}

		this.master = master;
		this.connections = network;
	}

	@SuppressWarnings("unchecked")
	private List<CorporeaSpark> getNearbySparks() {
		return (List) method_37908().method_8390(class_1297.class, new class_238(method_23317() - SCAN_RANGE, method_23318() - SCAN_RANGE, method_23321() - SCAN_RANGE, method_23317() + SCAN_RANGE, method_23318() + SCAN_RANGE, method_23321() + SCAN_RANGE), Predicates.instanceOf(CorporeaSpark.class));
	}

	private void restartNetwork() {
		connections = new LinkedHashSet<>();
		relatives = new ArrayList<>();

		if (master != null) {
			CorporeaSpark oldMaster = master;
			master = null;

			oldMaster.introduceNearbyTo(new LinkedHashSet<>(), oldMaster);
		}
	}

	private void findNetwork() {
		for (CorporeaSpark spark : getNearbySparks()) {
			if (spark.getNetwork() == getNetwork() && spark.entity().method_5805()) {
				CorporeaSpark master = spark.getMaster();
				if (master != null) {
					this.master = master;
					restartNetwork();

					break;
				}
			}
		}
	}

	private static void displayRelatives(class_1657 player, List<CorporeaSpark> checked, CorporeaSpark spark) {
		if (spark == null) {
			return;
		}

		List<CorporeaSpark> sparks = spark.getRelatives();
		if (sparks.isEmpty()) {
			ManaSparkEntity.particleBeam(player, spark.entity(), spark.getMaster().entity());
		} else {
			for (CorporeaSpark endSpark : sparks) {
				if (!checked.contains(endSpark)) {
					ManaSparkEntity.particleBeam(player, spark.entity(), endSpark.entity());
					checked.add(endSpark);
					displayRelatives(player, checked, endSpark);
				}
			}
		}
	}

	@Override
	public CorporeaNode getSparkNode() {
		return CorporeaNodeDetectors.findNode(method_37908(), this);
	}

	@Override
	public Set<CorporeaSpark> getConnections() {
		return connections;
	}

	@Override
	public List<CorporeaSpark> getRelatives() {
		return relatives;
	}

	@Override
	public void onItemExtracted(class_1799 stack) {
		((class_3218) method_37908()).method_14199(new class_2392(class_2398.field_11218, stack), method_23317(), method_23318(), method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
	}

	@Override
	public void onItemsRequested(List<class_1799> stacks) {
		List<class_1792> shownItems = new ArrayList<>();
		for (class_1799 stack : stacks) {
			if (!shownItems.contains(stack.method_7909())) {
				shownItems.add(stack.method_7909());
				((class_3218) method_37908()).method_14199(new class_2392(class_2398.field_11218, stack), method_23317(), method_23318(), method_23321(), 10, 0.125, 0.125, 0.125, 0.05);
			}
		}
	}

	@Override
	public CorporeaSpark getMaster() {
		return master;
	}

	public void setMaster(boolean master) {
		field_6011.method_12778(MASTER, master);
	}

	@Override
	public boolean isMaster() {
		return field_6011.method_12789(MASTER);
	}

	public void setCreative(boolean creative) {
		field_6011.method_12778(CREATIVE, creative);
	}

	@Override
	public boolean isCreative() {
		return field_6011.method_12789(CREATIVE);
	}

	@Override
	public class_1269 method_5688(class_1657 player, class_1268 hand) {
		class_1799 stack = player.method_5998(hand);
		if (method_5805() && !stack.method_7960()) {
			if (stack.method_7909() instanceof WandOfTheForestItem) {
				if (!method_37908().field_9236) {
					if (player.method_5715()) {
						dropAndKill();
						if (isMaster()) {
							restartNetwork();
						}
					} else {
						displayRelatives(player, new ArrayList<>(), master);
					}
				}
				return class_1269.method_29236(method_37908().field_9236);
			} else if (stack.method_7909() instanceof class_1769 dye) {
				class_1767 color = dye.method_7802();
				if (color != getNetwork()) {
					if (!method_37908().field_9236) {
						setNetwork(color);

						stack.method_7934(1);
					}

					return class_1269.method_29236(method_37908().field_9236);
				}
			} else if (stack.method_31574(BotaniaItems.phantomInk)) {
				if (!method_37908().field_9236) {
					method_5648(true);
				}
				return class_1269.method_29236(method_37908().field_9236);
			}
		}

		return class_1269.field_5811;
	}

	@Override
	public void setNetwork(class_1767 color) {
		if (color == getNetwork()) {
			return;
		}

		super.setNetwork(color);

		// Do not access world during deserialization
		if (!field_5953) {
			if (isMaster()) {
				restartNetwork();
			} else {
				findNetwork();
			}
		}
	}

	@Override
	protected void method_5749(@NotNull class_2487 cmp) {
		super.method_5749(cmp);
		setMaster(cmp.method_10577(TAG_MASTER));
		setCreative(cmp.method_10577(TAG_CREATIVE));
	}

	@Override
	protected void method_5652(@NotNull class_2487 cmp) {
		super.method_5652(cmp);
		cmp.method_10556(TAG_MASTER, isMaster());
		cmp.method_10556(TAG_CREATIVE, isCreative());
	}

	public record WandHud(CorporeaSparkEntity entity) implements WandHUD {
		@Override
		public void renderHUD(class_332 gui, class_310 mc) {
			class_1799 sparkStack = new class_1799(entity.getSparkItem());
			class_1767 networkColor = entity.getNetwork();
			class_2561 networkColorName = class_2561.method_43471("color.minecraft." + networkColor.method_7792())
					.method_27692(class_124.field_1056);
			int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);

			int width = 4 + Math.max(
					mc.field_1772.method_27525(networkColorName),
					RenderHelper.itemWithNameWidth(mc, sparkStack)
			);
			int networkColorTextStart = mc.field_1772.method_27525(networkColorName) / 2;

			int centerX = mc.method_22683().method_4486() / 2;
			int centerY = mc.method_22683().method_4502() / 2;

			RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 38);

			RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
			gui.method_27535(mc.field_1772, networkColorName, centerX - networkColorTextStart, centerY + 28, textColor);
		}
	}

}
