/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.api.corporea;

import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;

/**
 * This interface is responsible for taking a location and exposing it, if possible, to the corporea network.
 * Mods with custom storage solutions can implement this and register it using the API so that corporea supports
 * their storaage.
 * Implementations are already provided in Botania for Vanilla's interfaces.
 */
public interface CorporeaNodeDetector {
	/**
	 * @return A corporea node that this detector found at the given location, else null
	 */
	@Nullable
	CorporeaNode getNode(class_1937 world, CorporeaSpark spark);
}
