/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.fabric;

import com.mojang.brigadier.CommandDispatcher;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.event.registry.FabricRegistryBuilder;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.loot.v2.LootTableEvents;
import net.fabricmc.fabric.api.networking.v1.EntityTrackingEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.fabric.api.object.builder.v1.entity.MinecartComparatorLogicRegistry;
import net.fabricmc.fabric.api.registry.CompostingChanceRegistry;
import net.fabricmc.fabric.api.registry.FlattenableBlockRegistry;
import net.fabricmc.fabric.api.registry.FuelRegistry;
import net.fabricmc.fabric.api.registry.TillableBlockRegistry;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.base.FullItemFluidStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2609;
import net.minecraft.class_2680;
import net.minecraft.class_2893;
import net.minecraft.class_2960;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_52;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.BotaniaFabricCapabilities;
import vazkii.botania.api.BotaniaRegistries;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaNetworkCallback;
import vazkii.botania.client.fx.BotaniaParticles;
import vazkii.botania.common.BotaniaStats;
import vazkii.botania.common.advancements.BotaniaCriteriaTriggers;
import vazkii.botania.common.block.BotaniaBannerPatterns;
import vazkii.botania.common.block.BotaniaBlockFlammability;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.ForceRelayBlock;
import vazkii.botania.common.block.ManastormChargeBlock;
import vazkii.botania.common.block.block_entity.AlfheimPortalBlockEntity;
import vazkii.botania.common.block.block_entity.AnimatedTorchBlockEntity;
import vazkii.botania.common.block.block_entity.BlockEntityConstants;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.CraftyCrateBlockEntity;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.block.block_entity.TerrestrialAgglomerationPlateBlockEntity;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.flower.functional.DaffomillBlockEntity;
import vazkii.botania.common.block.flower.functional.TigerseyeBlockEntity;
import vazkii.botania.common.block.mana.DrumBlock;
import vazkii.botania.common.block.mana.ManaDetectorBlock;
import vazkii.botania.common.block.mana.ManaVoidBlock;
import vazkii.botania.common.block.red_string.RedStringInterceptorBlock;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.brew.BotaniaMobEffects;
import vazkii.botania.common.command.SkyblockCommand;
import vazkii.botania.common.config.ConfigDataManagerImpl;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.entity.GaiaGuardianEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.handler.CommonTickHandler;
import vazkii.botania.common.handler.CompostingData;
import vazkii.botania.common.handler.ContributorList;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.handler.ExoflameFurnaceHandler;
import vazkii.botania.common.handler.ManaNetworkHandler;
import vazkii.botania.common.handler.OrechidManager;
import vazkii.botania.common.handler.PaintableData;
import vazkii.botania.common.handler.PixieHandler;
import vazkii.botania.common.handler.SleepingHandler;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.impl.BotaniaAPIImpl;
import vazkii.botania.common.impl.DefaultHornHarvestable;
import vazkii.botania.common.impl.corporea.DefaultCorporeaMatchers;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BlackHoleTalismanItem;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.CustomCreativeTabContents;
import vazkii.botania.common.item.EnderHandItem;
import vazkii.botania.common.item.GrassSeedsItem;
import vazkii.botania.common.item.ManaMirrorItem;
import vazkii.botania.common.item.ManaTabletItem;
import vazkii.botania.common.item.ResoluteIvyItem;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.equipment.bauble.BandOfManaItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.item.equipment.bauble.GreaterBandOfManaItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraBladeItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraTruncatorItem;
import vazkii.botania.common.item.material.EnderAirItem;
import vazkii.botania.common.item.relic.DiceOfFateItem;
import vazkii.botania.common.item.relic.EyeOfTheFlugelItem;
import vazkii.botania.common.item.relic.FruitOfGrisaiaItem;
import vazkii.botania.common.item.relic.KeyOfTheKingsLawItem;
import vazkii.botania.common.item.relic.RingOfLokiItem;
import vazkii.botania.common.item.relic.RingOfOdinItem;
import vazkii.botania.common.item.relic.RingOfThorItem;
import vazkii.botania.common.item.rod.BifrostRodItem;
import vazkii.botania.common.item.rod.DepthsRodItem;
import vazkii.botania.common.item.rod.HellsRodItem;
import vazkii.botania.common.item.rod.LandsRodItem;
import vazkii.botania.common.item.rod.PlentifulMantleRodItem;
import vazkii.botania.common.item.rod.ShadedMesaRodItem;
import vazkii.botania.common.item.rod.ShiftingCrustRodItem;
import vazkii.botania.common.item.rod.SkiesRodItem;
import vazkii.botania.common.item.rod.TerraFirmaRodItem;
import vazkii.botania.common.item.rod.UnstableReservoirRodItem;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.loot.BotaniaLootModifiers;
import vazkii.botania.common.loot.LootHandler;
import vazkii.botania.common.world.BotaniaFeatures;
import vazkii.botania.common.world.SkyblockChunkGenerator;
import vazkii.botania.common.world.SkyblockWorldEvents;
import vazkii.botania.fabric.FiberBotaniaConfig;
import vazkii.botania.fabric.block_entity.FabricRedStringContainerBlockEntity;
import vazkii.botania.fabric.integration.corporea.FabricTransferCorporeaNodeDetector;
import vazkii.botania.fabric.integration.tr_energy.FluxfieldTRStorage;
import vazkii.botania.fabric.internal_caps.RedStringContainerStorage;
import vazkii.botania.fabric.network.FabricPacketHandler;
import vazkii.botania.xplat.XplatAbstractions;
import vazkii.patchouli.api.PatchouliAPI;

public class FabricCommonInitializer
implements ModInitializer {
    private static final class_2378<Brew> BREW_REGISTRY = FabricRegistryBuilder.createDefaulted(BotaniaRegistries.BREWS, (class_2960)ResourceLocationHelper.prefix("fallback")).buildAndRegister();
    private final Set<class_1792> itemsToAddToCreativeTab = new LinkedHashSet<class_1792>();
    private final BiConsumer<class_1792, class_2960> boundForItem = (t, id) -> {
        this.itemsToAddToCreativeTab.add((class_1792)t);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)id, (Object)t);
    };

    public void onInitialize() {
        this.coreInit();
        this.registryInit();
        PaintableData.init();
        CompostingData.init((arg_0, arg_1) -> ((CompostingChanceRegistry)CompostingChanceRegistry.INSTANCE).add(arg_0, arg_1));
        DefaultCorporeaMatchers.init();
        PlayerHelper.setFakePlayerClass(FakePlayer.class);
        PatchouliAPI.get().registerMultiblock(class_7923.field_41175.method_10221((Object)BotaniaBlocks.alfPortal), AlfheimPortalBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_7923.field_41175.method_10221((Object)BotaniaBlocks.terraPlate), TerrestrialAgglomerationPlateBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(class_7923.field_41175.method_10221((Object)BotaniaBlocks.enchanter), ManaEnchanterBlockEntity.MULTIBLOCK.get());
        PatchouliAPI.get().registerMultiblock(ResourceLocationHelper.prefix("gaia_ritual"), GaiaGuardianEntity.ARENA_MULTIBLOCK.get());
        OrechidManager.registerListener();
        ConfigDataManagerImpl.registerListener();
        CraftyCrateBlockEntity.registerListener();
        CorporeaNodeDetectors.register(new FabricTransferCorporeaNodeDetector());
        this.registerCapabilities();
        this.registerEvents();
    }

    private void coreInit() {
        FiberBotaniaConfig.setup();
        EquipmentHandler.init();
        FabricPacketHandler.init();
    }

    private void registryInit() {
        BotaniaSounds.init(FabricCommonInitializer.bind(class_7923.field_41172));
        BotaniaBlocks.registerBlocks(FabricCommonInitializer.bind(class_7923.field_41175));
        BotaniaBlocks.registerItemBlocks(this.boundForItem);
        BotaniaBlockFlammability.register();
        BotaniaBlockEntities.registerTiles(FabricCommonInitializer.bind(class_7923.field_41181));
        BotaniaItems.registerItems(this.boundForItem);
        BotaniaFlowerBlocks.registerBlocks(FabricCommonInitializer.bind(class_7923.field_41175));
        BotaniaFlowerBlocks.registerItemBlocks(this.boundForItem);
        BotaniaFlowerBlocks.registerTEs(FabricCommonInitializer.bind(class_7923.field_41181));
        BotaniaBlocks.addDispenserBehaviours();
        BotaniaBlocks.addAxeStripping();
        for (class_2248 b : List.of(BotaniaBlocks.dryGrass, BotaniaBlocks.goldenGrass, BotaniaBlocks.vividGrass, BotaniaBlocks.scorchedGrass, BotaniaBlocks.infusedGrass, BotaniaBlocks.mutatedGrass)) {
            TillableBlockRegistry.register((class_2248)b, class_1794::method_36987, (class_2680)class_2246.field_10362.method_9564());
            FlattenableBlockRegistry.register((class_2248)b, (class_2680)class_2246.field_10194.method_9564());
        }
        int blazeTime = 2400;
        FuelRegistry.INSTANCE.add((class_1935)BotaniaBlocks.blazeBlock.method_8389(), (Object)(blazeTime * (XplatAbstractions.INSTANCE.gogLoaded() ? 5 : 10)));
        BotaniaItems.registerMenuTypes(FabricCommonInitializer.bind(class_7923.field_41187));
        BotaniaItems.registerRecipeSerializers(FabricCommonInitializer.bind(class_7923.field_41189));
        BotaniaBannerPatterns.submitRegistrations(FabricCommonInitializer.bind(class_7923.field_41165));
        BotaniaRecipeTypes.submitRecipeTypes(FabricCommonInitializer.bind(class_7923.field_41188));
        BotaniaRecipeTypes.submitRecipeSerializers(FabricCommonInitializer.bind(class_7923.field_41189));
        BotaniaEntities.registerEntities(FabricCommonInitializer.bind(class_7923.field_41177));
        BotaniaEntities.registerAttributes(FabricDefaultAttributeRegistry::register);
        PixieHandler.registerAttribute(FabricCommonInitializer.bind(class_7923.field_41190));
        MinecartComparatorLogicRegistry.register(BotaniaEntities.POOL_MINECART, (minecart, state, pos) -> minecart.getComparatorLevel());
        BotaniaMobEffects.registerPotions(FabricCommonInitializer.bind(class_7923.field_41174));
        BotaniaBrews.submitRegistrations(FabricCommonInitializer.bind(BREW_REGISTRY));
        BotaniaFeatures.registerFeatures(FabricCommonInitializer.bind(class_7923.field_41144));
        SkyblockChunkGenerator.submitRegistration(FabricCommonInitializer.bind(class_7923.field_41157));
        BiomeModifications.addFeature(ctx -> ctx.hasTag(BotaniaTags.Biomes.MYSTICAL_FLOWER_SPAWNLIST) && !ctx.hasTag(BotaniaTags.Biomes.MYSTICAL_FLOWER_BLOCKLIST), (class_2893.class_2895)class_2893.class_2895.field_13178, BotaniaFeatures.MYSTICAL_FLOWERS_PLACED_FEATURE);
        BiomeModifications.addFeature(ctx -> ctx.hasTag(BotaniaTags.Biomes.MYSTICAL_MUSHROOM_SPAWNLIST) && !ctx.hasTag(BotaniaTags.Biomes.MYSTICAL_MUSHROOM_BLOCKLIST), (class_2893.class_2895)class_2893.class_2895.field_13178, BotaniaFeatures.MYSTICAL_MUSHROOMS_PLACED_FEATURE);
        BotaniaCriteriaTriggers.init();
        BotaniaParticles.registerParticles(FabricCommonInitializer.bind(class_7923.field_41180));
        BotaniaLootModifiers.submitLootConditions(FabricCommonInitializer.bind(class_7923.field_41135));
        BotaniaLootModifiers.submitLootFunctions(FabricCommonInitializer.bind(class_7923.field_41134));
        BotaniaStats.init();
        class_2378.method_39197((class_2378)class_7923.field_44687, BotaniaRegistries.BOTANIA_TAB_KEY, (Object)FabricItemGroup.builder().method_47321((class_2561)class_2561.method_43471((String)"itemGroup.botania").method_27694(style -> style.method_10977(class_124.field_1068))).method_47320(() -> new class_1799((class_1935)BotaniaItems.lexicon)).method_47319("botania.png").method_47324());
        ItemGroupEvents.modifyEntriesEvent(BotaniaRegistries.BOTANIA_TAB_KEY).register(entries -> {
            for (class_1792 item : this.itemsToAddToCreativeTab) {
                class_1747 bi;
                class_2248 patt11782$temp;
                if (item instanceof CustomCreativeTabContents) {
                    CustomCreativeTabContents cc = (CustomCreativeTabContents)item;
                    cc.addToCreativeTab(item, (class_1761.class_7704)entries);
                    continue;
                }
                if (item instanceof class_1747 && (patt11782$temp = (bi = (class_1747)item).method_7711()) instanceof CustomCreativeTabContents) {
                    CustomCreativeTabContents cc = (CustomCreativeTabContents)patt11782$temp;
                    cc.addToCreativeTab(item, (class_1761.class_7704)entries);
                    continue;
                }
                entries.method_45421((class_1935)item);
            }
        });
    }

    private void registerEvents() {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            UseBlockCallback.EVENT.register(SkyblockWorldEvents::onPlayerInteract);
        }
        AttackBlockCallback.EVENT.register((player, world, hand, pos, direction) -> ((ShiftingCrustRodItem)BotaniaItems.exchangeRod).onLeftClick(player, world, hand, pos, direction));
        AttackEntityCallback.EVENT.register(ShadedMesaRodItem::onAttack);
        AttackEntityCallback.EVENT.register(TerraBladeItem::attackEntity);
        CommandRegistrationCallback.EVENT.register(this::registerCommands);
        EntitySleepEvents.ALLOW_SLEEPING.register(SleepingHandler::trySleep);
        EntityTrackingEvents.START_TRACKING.register(DaffomillBlockEntity::onItemTrack);
        LootTableEvents.MODIFY.register((resourceManager, manager, id, tableBuilder, lootTableSource) -> LootHandler.lootLoad(id, arg_0 -> ((class_52.class_53)tableBuilder).method_336(arg_0)));
        ManaNetworkCallback.EVENT.register(ManaNetworkHandler.instance::onNetworkEvent);
        ServerEntityEvents.ENTITY_LOAD.register(TigerseyeBlockEntity::pacifyAfterLoad);
        ServerLifecycleEvents.SERVER_STARTED.register(this::serverAboutToStart);
        ServerLifecycleEvents.SERVER_STOPPING.register(this::serverStopping);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> FlugelTiaraItem.playerLoggedOut(handler.field_14140));
        ServerPlayerEvents.AFTER_RESPAWN.register(ResoluteIvyItem::onPlayerRespawn);
        ServerTickEvents.END_WORLD_TICK.register(CommonTickHandler::onTick);
        ServerTickEvents.END_WORLD_TICK.register(GrassSeedsItem::onTickEnd);
        ServerTickEvents.END_WORLD_TICK.register(TerraTruncatorItem::onTickEnd);
        UseBlockCallback.EVENT.register(RedStringInterceptorBlock::onInteract);
        UseBlockCallback.EVENT.register(RingOfLokiItem::onPlayerInteract);
        UseItemCallback.EVENT.register(EnderAirItem::onPlayerInteract);
    }

    private static <T> BiConsumer<T, class_2960> bind(class_2378<? super T> registry) {
        return (t, id) -> class_2378.method_10230((class_2378)registry, (class_2960)id, (Object)t);
    }

    private void registerCapabilities() {
        FluidStorage.ITEM.registerForItems((stack, context) -> new FullItemFluidStorage(context, class_1802.field_8428, FluidVariant.of((class_3611)class_3612.field_15910), 81000L), new class_1935[]{BotaniaItems.waterBowl});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new LandsRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.dirtRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new PlentifulMantleRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.diviningRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new HellsRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.fireRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new UnstableReservoirRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.missileRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new BifrostRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.rainbowRod});
        BotaniaFabricCapabilities.AVATAR_WIELDABLE.registerForItems((stack, c) -> new SkiesRodItem.AvatarBehavior(), new class_1935[]{BotaniaItems.tornadoRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new LandsRodItem.BlockProviderImpl(stack), new class_1935[]{BotaniaItems.dirtRod, BotaniaItems.skyDirtRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new BlackHoleTalismanItem.BlockProviderImpl(stack), new class_1935[]{BotaniaItems.blackHoleTalisman});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new DepthsRodItem.BlockProviderImpl(), new class_1935[]{BotaniaItems.cobbleRod});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new EnderHandItem.BlockProviderImpl(stack), new class_1935[]{BotaniaItems.enderHand});
        BotaniaFabricCapabilities.BLOCK_PROVIDER.registerForItems((stack, c) -> new TerraFirmaRodItem.BlockProviderImpl(), new class_1935[]{BotaniaItems.terraformRod});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new EyeOfTheFlugelItem.CoordBoundItemImpl(st), new class_1935[]{BotaniaItems.flugelEye});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new ManaMirrorItem.CoordBoundItemImpl(st), new class_1935[]{BotaniaItems.manaMirror});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new WandOfTheForestItem.CoordBoundItemImpl(st), new class_1935[]{BotaniaItems.twigWand});
        BotaniaFabricCapabilities.COORD_BOUND_ITEM.registerForItems((st, c) -> new WandOfTheForestItem.CoordBoundItemImpl(st), new class_1935[]{BotaniaItems.dreamwoodWand});
        BotaniaFabricCapabilities.MANA_ITEM.registerForItems((st, c) -> new ManaMirrorItem.ManaItemImpl(st), new class_1935[]{BotaniaItems.manaMirror});
        BotaniaFabricCapabilities.MANA_ITEM.registerForItems((st, c) -> new BandOfManaItem.ManaItemImpl(st), new class_1935[]{BotaniaItems.manaRing});
        BotaniaFabricCapabilities.MANA_ITEM.registerForItems((st, c) -> new GreaterBandOfManaItem.GreaterManaItemImpl(st), new class_1935[]{BotaniaItems.manaRingGreater});
        BotaniaFabricCapabilities.MANA_ITEM.registerForItems((st, c) -> new ManaTabletItem.ManaItemImpl(st), new class_1935[]{BotaniaItems.manaTablet});
        BotaniaFabricCapabilities.MANA_ITEM.registerForItems((st, c) -> new TerraShattererItem.ManaItemImpl(st), new class_1935[]{BotaniaItems.terraPick});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> DiceOfFateItem.makeRelic(st), new class_1935[]{BotaniaItems.dice});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> EyeOfTheFlugelItem.makeRelic(st), new class_1935[]{BotaniaItems.flugelEye});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> FruitOfGrisaiaItem.makeRelic(st), new class_1935[]{BotaniaItems.infiniteFruit});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> KeyOfTheKingsLawItem.makeRelic(st), new class_1935[]{BotaniaItems.kingKey});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> RingOfLokiItem.makeRelic(st), new class_1935[]{BotaniaItems.lokiRing});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> RingOfOdinItem.makeRelic(st), new class_1935[]{BotaniaItems.odinRing});
        BotaniaFabricCapabilities.RELIC.registerForItems((st, c) -> RingOfThorItem.makeRelic(st), new class_1935[]{BotaniaItems.thorRing});
        BotaniaFabricCapabilities.EXOFLAME_HEATABLE.registerFallback((world, pos, state, blockEntity, context) -> {
            if (blockEntity instanceof class_2609) {
                class_2609 furnace = (class_2609)blockEntity;
                return new ExoflameFurnaceHandler.FurnaceExoflameHeatable(furnace);
            }
            return null;
        });
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> (world, pos, stack, hornType, living) -> hornType == HornHarvestable.EnumHornType.CANOPY, new class_2248[]{class_2246.field_10597, class_2246.field_28675, class_2246.field_28676, class_2246.field_23078, class_2246.field_23079, class_2246.field_22123, class_2246.field_22124});
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> DefaultHornHarvestable.INSTANCE, (class_2248[])ColorHelper.supportedColors().map(BotaniaBlocks::getMushroom).toArray(class_2248[]::new));
        BotaniaFabricCapabilities.HORN_HARVEST.registerForBlocks((w, p, s, be, c) -> DefaultHornHarvestable.INSTANCE, (class_2248[])ColorHelper.supportedColors().map(BotaniaBlocks::getShinyFlower).toArray(class_2248[]::new));
        BotaniaFabricCapabilities.HOURGLASS_TRIGGER.registerForBlockEntities((be, c) -> {
            AnimatedTorchBlockEntity torch = (AnimatedTorchBlockEntity)be;
            return hourglass -> torch.toggle();
        }, new class_2591[]{BotaniaBlockEntities.ANIMATED_TORCH});
        BotaniaFabricCapabilities.MANA_GHOST.registerForBlocks((level, pos, state, be, context) -> (ManaCollisionGhost)state.method_26204(), new class_2248[]{BotaniaBlocks.manaDetector, BotaniaBlocks.abstrusePlatform, BotaniaBlocks.infrangiblePlatform, BotaniaBlocks.spectralPlatform, BotaniaBlocks.prism, BotaniaBlocks.tinyPlanet});
        BotaniaFabricCapabilities.MANA_RECEIVER.registerSelf((class_2591[])BlockEntityConstants.SELF_MANA_RECEIVER_BES.toArray(class_2591[]::new));
        BotaniaFabricCapabilities.MANA_RECEIVER.registerForBlocks((level, pos, state, be, side) -> new ManaVoidBlock.ManaReceiverImpl(level, pos, state), new class_2248[]{BotaniaBlocks.manaVoid});
        BotaniaFabricCapabilities.SPARK_ATTACHABLE.registerSelf((class_2591[])BlockEntityConstants.SELF_SPARK_ATTACHABLE_BES.toArray(class_2591[]::new));
        BotaniaFabricCapabilities.MANA_TRIGGER.registerForBlocks((level, pos, state, be, context) -> new DrumBlock.ManaTriggerImpl(level, pos, state), new class_2248[]{BotaniaBlocks.canopyDrum, BotaniaBlocks.gatheringDrum, BotaniaBlocks.wildDrum});
        BotaniaFabricCapabilities.MANA_TRIGGER.registerForBlocks((level, pos, state, be, context) -> new ManastormChargeBlock.ManaTriggerImpl(level, pos, state), new class_2248[]{BotaniaBlocks.manaBomb});
        BotaniaFabricCapabilities.MANA_TRIGGER.registerForBlocks((level, pos, state, be, context) -> new ManaDetectorBlock.ManaTriggerImpl(level, pos, state), new class_2248[]{BotaniaBlocks.manaDetector});
        BotaniaFabricCapabilities.MANA_TRIGGER.registerSelf((class_2591[])BlockEntityConstants.SELF_MANA_TRIGGER_BES.toArray(class_2591[]::new));
        BotaniaFabricCapabilities.WANDABLE.registerForBlocks((world, pos, state, blockEntity, context) -> (player, stack, side) -> ((ForceRelayBlock)state.method_26204()).onUsedByWand(player, stack, world, pos), new class_2248[]{BotaniaBlocks.pistonRelay});
        BotaniaFabricCapabilities.WANDABLE.registerSelf((class_2591[])BlockEntityConstants.SELF_WANDADBLE_BES.toArray(class_2591[]::new));
        BotaniaFabricCapabilities.PHANTOM_INKABLE.registerSelf((class_2591[])BlockEntityConstants.SELF_PHANTOM_INKABLE_BES.toArray(class_2591[]::new));
        ItemStorage.SIDED.registerForBlockEntity(FabricRedStringContainerBlockEntity::getStorage, BotaniaBlockEntities.RED_STRING_CONTAINER);
        ItemStorage.SIDED.registerForBlockEntity(RedStringContainerStorage::new, BotaniaBlockEntities.RED_STRING_DISPENSER);
        if (XplatAbstractions.INSTANCE.isModLoaded("team_reborn_energy")) {
            FluxfieldTRStorage.register();
        }
    }

    private void serverAboutToStart(MinecraftServer server) {
        if (BotaniaAPI.instance().getClass() != BotaniaAPIImpl.class) {
            String clname = BotaniaAPI.instance().getClass().getName();
            throw new IllegalAccessError("The Botania API has been overriden. This will cause crashes and compatibility issues, and that's why it's marked as \"Do not Override\". Whoever had the brilliant idea of overriding it needs to go back to elementary school and learn to read. (Actual classname: " + clname + ")");
        }
        if (server.method_3816()) {
            ContributorList.firstStart();
        }
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 ctx, class_2170.class_5364 environment) {
        if (XplatAbstractions.INSTANCE.gogLoaded()) {
            SkyblockCommand.register(dispatcher);
        }
    }

    private void serverStopping(MinecraftServer server) {
        ManaNetworkHandler.instance.clear();
        CorporeaIndexBlockEntity.clearIndexCache();
    }
}

