package vazkii.botania.fabric.integration.tr_energy;

import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.mana.PowerGeneratorBlockEntity;


import team.reborn.energy.api.EnergyStorage;
import team.reborn.energy.api.base.SimpleEnergyStorage;

public class FluxfieldTRStorage extends SimpleEnergyStorage {
	public static void register() {
		EnergyStorage.SIDED.registerForBlockEntity((be, dir) -> new FluxfieldTRStorage(be), BotaniaBlockEntities.FLUXFIELD);
	}

	public static int transferEnergyToNeighbors(class_1937 level, class_2338 pos, int energy) {
		for (class_2350 e : class_2350.values()) {
			class_2338 neighbor = pos.method_10093(e);
			if (!level.method_22340(neighbor)) {
				continue;
			}

			class_2586 be = level.method_8321(neighbor);

			EnergyStorage storage = EnergyStorage.SIDED.find(level, neighbor, level.method_8320(neighbor), be, e.method_10153());
			if (storage != null && storage.supportsInsertion()) {
				try (Transaction transaction = Transaction.openOuter()) {
					energy -= storage.insert(energy, transaction);
					transaction.commit();
					if (energy <= 0) {
						return 0;
					}
				}
			}
		}
		return energy;
	}

	private final PowerGeneratorBlockEntity generator;

	public FluxfieldTRStorage(PowerGeneratorBlockEntity generator) {
		super(PowerGeneratorBlockEntity.MAX_ENERGY, 0, 0);
		this.generator = generator;
	}

	@Override
	public long getAmount() {
		return generator.getEnergy();
	}
}
