/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item;

import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

public class ExtrapolatedBucketItem extends class_1792 {

	public ExtrapolatedBucketItem(class_1793 props) {
		super(props);
	}

	// [VanillaCopy] BucketItem, only the empty cases
	@NotNull
	@Override
	public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, @NotNull class_1268 interactionHand) {
		class_1799 itemStack = player.method_5998(interactionHand);
		class_3965 blockHitResult = method_7872(level, player, class_3959.class_242.field_1345);
		if (blockHitResult.method_17783() == class_239.class_240.field_1333) {
			return class_1271.method_22430(itemStack);
		} else if (blockHitResult.method_17783() != class_239.class_240.field_1332) {
			return class_1271.method_22430(itemStack);
		} else {
			class_2338 blockPos = blockHitResult.method_17777();
			class_2350 direction = blockHitResult.method_17780();
			class_2338 blockPos2 = blockPos.method_10093(direction);
			if (level.method_8505(player, blockPos) && player.method_7343(blockPos2, direction, itemStack)) {
				class_2680 blockState;
				blockState = level.method_8320(blockPos);
				if (blockState.method_26204() instanceof class_2263 bucketPickup) {
					class_1799 itemStack2 = bucketPickup.method_9700(level, blockPos, blockState);
					if (!itemStack2.method_7960()) {
						player.method_7259(class_3468.field_15372.method_14956(this));
						bucketPickup.method_32351().ifPresent((soundEvent) -> {
							player.method_5783(soundEvent, 1.0F, 1.0F);
						});
						// Botania: some particles
						for (int x = 0; x < 5; x++) {
							level.method_8406(class_2398.field_11203, blockPos.method_10263() + Math.random(), blockPos.method_10264() + Math.random(), blockPos.method_10260() + Math.random(), 0, 0, 0);
						}
						level.method_33596(player, class_5712.field_28167, blockPos);
						class_1799 itemStack3 = itemStack; // Botania: don't overwrite ourselves
						if (!level.field_9236) {
							class_174.field_1208.method_8932((class_3222) player, itemStack2);
						}

						return class_1271.method_29237(itemStack3, level.method_8608());
					}
				}

				return class_1271.method_22431(itemStack);
			} else {
				return class_1271.method_22431(itemStack);
			}
		}
	}

}
