/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.class_1799;
import net.minecraft.class_1852;
import net.minecraft.class_1865;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.api.item.AncientWillContainer;
import vazkii.botania.common.item.AncientWillItem;

public class AncientWillRecipe extends class_1852 {
	public static final NoOpRecipeSerializer<AncientWillRecipe> SERIALIZER = new NoOpRecipeSerializer<>(AncientWillRecipe::new);

	public AncientWillRecipe(class_2960 id) {
		super(id, class_7710.field_40250);
	}

	@Override
	public boolean matches(@NotNull class_8566 inv, @NotNull class_1937 world) {
		boolean foundWill = false;
		boolean foundItem = false;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof AncientWillItem && !foundWill) {
					foundWill = true;
				} else if (!foundItem) {
					if (stack.method_7909() instanceof AncientWillContainer) {
						foundItem = true;
					} else {
						return false;
					}
				}
			}
		}

		return foundWill && foundItem;
	}

	@NotNull
	@Override
	public class_1799 assemble(@NotNull class_8566 inv, @NotNull class_5455 registries) {
		class_1799 item = class_1799.field_8037;
		AncientWillContainer.AncientWillType will = null;

		for (int i = 0; i < inv.method_5439(); i++) {
			class_1799 stack = inv.method_5438(i);
			if (!stack.method_7960()) {
				if (stack.method_7909() instanceof AncientWillContainer && item.method_7960()) {
					item = stack;
				} else {
					will = ((AncientWillItem) stack.method_7909()).type; // we already verified this is a will in matches()
				}
			}
		}

		AncientWillContainer container = (AncientWillContainer) item.method_7909();
		if (container.hasAncientWill(item, will)) {
			return class_1799.field_8037;
		}

		class_1799 copy = item.method_7972();
		container.addAncientWill(copy, will);
		return copy;
	}

	@Override
	public boolean method_8113(int width, int height) {
		return width > 1 || height > 1;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return SERIALIZER;
	}
}
