/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.crafting;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import org.jetbrains.annotations.NotNull;

import vazkii.botania.common.block.BotaniaBlocks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ElvenTradeRecipe implements vazkii.botania.api.recipe.ElvenTradeRecipe {
	private final class_2960 id;
	private final ImmutableList<class_1799> outputs;
	private final class_2371<class_1856> inputs;

	public ElvenTradeRecipe(class_2960 id, class_1799[] outputs, class_1856... inputs) {
		this.id = id;
		this.outputs = ImmutableList.copyOf(outputs);
		this.inputs = class_2371.method_10211();
		this.inputs.addAll(Arrays.asList(inputs));
	}

	@Override
	public Optional<List<class_1799>> match(List<class_1799> stacks) {
		List<class_1856> inputsMissing = new ArrayList<>(inputs);
		List<class_1799> stacksToRemove = new ArrayList<>();

		for (class_1799 stack : stacks) {
			if (stack.method_7960()) {
				continue;
			}
			if (inputsMissing.isEmpty()) {
				break;
			}

			int stackIndex = -1;

			for (int i = 0; i < inputsMissing.size(); i++) {
				class_1856 ingr = inputsMissing.get(i);
				if (ingr.method_8093(stack)) {
					if (!stacksToRemove.contains(stack)) {
						stacksToRemove.add(stack);
					}
					stackIndex = i;
					break;
				}
			}

			if (stackIndex != -1) {
				inputsMissing.remove(stackIndex);
			}
		}

		return inputsMissing.isEmpty() ? Optional.of(stacksToRemove) : Optional.empty();
	}

	@Override
	public boolean containsItem(class_1799 stack) {
		for (class_1856 input : inputs) {
			if (input.method_8093(stack)) {
				return true;
			}
		}
		return false;
	}

	@NotNull
	@Override
	public class_1865<?> method_8119() {
		return BotaniaRecipeTypes.ELVEN_TRADE_SERIALIZER;
	}

	@NotNull
	@Override
	public class_2371<class_1856> method_8117() {
		return inputs;
	}

	@NotNull
	@Override
	public class_1799 method_17447() {
		return new class_1799(BotaniaBlocks.alfPortal);
	}

	@NotNull
	@Override
	public class_2960 method_8114() {
		return id;
	}

	@Override
	public List<class_1799> getOutputs() {
		return outputs;
	}

	@Override
	public List<class_1799> getOutputs(List<class_1799> inputs) {
		return getOutputs();
	}

	public static class Serializer implements class_1865<ElvenTradeRecipe> {

		@NotNull
		@Override
		public ElvenTradeRecipe method_8121(@NotNull class_2960 id, @NotNull JsonObject json) {
			JsonElement output = json.get("output");
			List<class_1799> outputStacks = new ArrayList<>();
			if (output.isJsonArray()) {
				for (JsonElement e : output.getAsJsonArray()) {
					JsonObject o = class_3518.method_15295(e, "output stack");
					outputStacks.add(class_1869.method_35228(o));
				}
			} else {
				JsonObject o = class_3518.method_15295(output, "output stack");
				outputStacks.add(class_1869.method_35228(o));
			}

			List<class_1856> inputs = new ArrayList<>();
			for (JsonElement e : class_3518.method_15261(json, "ingredients")) {
				class_1856 ing = class_1856.method_52177(e);
				if (!ing.method_8103()) {
					inputs.add(ing);
				}
			}

			return new ElvenTradeRecipe(id, outputStacks.toArray(new class_1799[0]), inputs.toArray(new class_1856[0]));
		}

		@Override
		public ElvenTradeRecipe method_8122(@NotNull class_2960 id, class_2540 buf) {
			class_1856[] inputs = new class_1856[buf.method_10816()];
			for (int i = 0; i < inputs.length; i++) {
				inputs[i] = class_1856.method_8086(buf);
			}
			class_1799[] outputs = new class_1799[buf.method_10816()];
			for (int i = 0; i < outputs.length; i++) {
				outputs[i] = buf.method_10819();
			}
			return new ElvenTradeRecipe(id, outputs, inputs);
		}

		@Override
		public void toNetwork(class_2540 buf, ElvenTradeRecipe recipe) {
			buf.method_10804(recipe.method_8117().size());
			for (class_1856 input : recipe.method_8117()) {
				input.method_8088(buf);
			}
			buf.method_10804(recipe.getOutputs().size());
			for (class_1799 output : recipe.getOutputs()) {
				buf.method_10793(output);
			}
		}
	}
}
