package vazkii.botania.fabric.data;

import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.data.BlockTagProvider;
import vazkii.botania.xplat.XplatAbstractions;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7924;

public class FabricBlockTagProvider extends BlockTagProvider {
	public static final class_6862<class_2248> LAPIS_BLOCKS = blockTag(new class_2960("c", "lapis_blocks"));
	public static final class_6862<class_2248> QUARTZ_BLOCKS = blockTag(new class_2960("c", "quartz_blocks"));
	public static final class_6862<class_2248> MUSHROOMS = blockTag(new class_2960("c", "mushrooms"));
	public static final class_6862<class_2248> GLASS = blockTag(new class_2960("c", "glass"));
	public static final class_6862<class_2248> GLASS_ALT = blockTag(new class_2960("c", "glass_blocks"));
	public static final class_6862<class_2248> GLASS_PANE = blockTag(new class_2960("c", "glass_pane"));
	public static final class_6862<class_2248> GLASS_PANE_ALT = blockTag(new class_2960("c", "glass_panes"));

	private static class_6862<class_2248> blockTag(class_2960 location) {
		return class_6862.method_40092(class_7924.field_41254, location);
	}

	public FabricBlockTagProvider(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider) {
		super(packOutput, lookupProvider);
	}

	@Override
	protected void method_10514(class_7225.class_7874 provider) {
		method_46827(LAPIS_BLOCKS).method_46829(class_2246.field_10441);
		method_46827(QUARTZ_BLOCKS).method_46830(
				BotaniaBlocks.darkQuartz, BotaniaBlocks.manaQuartz, BotaniaBlocks.blazeQuartz,
				BotaniaBlocks.lavenderQuartz, BotaniaBlocks.redQuartz, BotaniaBlocks.elfQuartz, BotaniaBlocks.sunnyQuartz
		);
		List.of(GLASS, GLASS_ALT).forEach(t -> method_46827(t).method_46830(BotaniaBlocks.manaGlass, BotaniaBlocks.elfGlass, BotaniaBlocks.bifrostPerm));
		List.of(GLASS_PANE, GLASS_PANE_ALT).forEach(t -> method_46827(t).method_46830(BotaniaBlocks.managlassPane, BotaniaBlocks.alfglassPane, BotaniaBlocks.bifrostPane));

		ColorHelper.supportedColors().forEach(color -> {
			this.method_46827(MUSHROOMS).method_46829(BotaniaBlocks.getMushroom(color));
		});

		var vanillaTags = List.of(
				class_3481.field_29193,
				class_3481.field_28988,
				class_3481.field_23062,
				class_3481.field_28991,
				class_3481.field_28990,
				class_3481.field_28989,
				class_3481.field_29195,
				class_3481.field_29194
		);
		// We aren't calling vanilla's generation, so need to add dummy calls so that using them below doesn't error out.
		vanillaTags.forEach(this::method_46827);

		var oreTag = method_46827(XplatAbstractions.INSTANCE.getOreTag());
		vanillaTags.forEach(oreTag::method_46828);
	}
}
