/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.data;

import net.minecraft.advancements.*;
import net.minecraft.advancements.critereon.*;
import net.minecraft.class_1299;
import net.minecraft.class_161;
import net.minecraft.class_161.class_162;
import net.minecraft.class_170;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_185;
import net.minecraft.class_189;
import net.minecraft.class_193;
import net.minecraft.class_1935;
import net.minecraft.class_2010;
import net.minecraft.class_2022;
import net.minecraft.class_2048;
import net.minecraft.class_2062;
import net.minecraft.class_2066;
import net.minecraft.class_2066.class_2068;
import net.minecraft.class_2073;
import net.minecraft.class_2080;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2105;
import net.minecraft.class_2246;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5258;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7784;
import net.minecraft.class_7785;
import net.minecraft.class_7923;
import vazkii.botania.common.advancements.*;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.block.block_entity.corporea.CorporeaIndexBlockEntity;
import vazkii.botania.common.block.flower.functional.LooniumBlockEntity;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.LexicaBotaniaItem;
import vazkii.botania.common.item.equipment.bauble.FlugelTiaraItem;
import vazkii.botania.common.lib.BotaniaTags;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import java.util.stream.IntStream;

import static vazkii.botania.common.lib.ResourceLocationHelper.prefix;

public class AdvancementProvider {
	public static net.minecraft.class_2409 create(class_7784 packOutput, CompletableFuture<class_7225.class_7874> lookupProvider) {
		return new net.minecraft.class_2409(packOutput, lookupProvider, List.of(new BotaniaStoryAdvancements(), new BotaniaChallengeAdvancements()));
	}

	public static class BotaniaStoryAdvancements implements class_7785 {

		@Override
		public void method_10335(class_7225.class_7874 lookup, Consumer<class_161> consumer) {
			var elvenLexiconUnlock = new class_2487();
			elvenLexiconUnlock.method_10556(LexicaBotaniaItem.TAG_ELVEN_UNLOCK, true);
			class_2066.class_2068 elvenLexicon = class_2066.class_2068.method_8957(
					class_2073.class_2074.method_8973().method_8977(BotaniaItems.lexicon).method_20399(elvenLexiconUnlock).method_8976()
			);

			// Main progression line
			class_161 root = class_161.class_162.method_707()
					.method_693(rootDisplay(BotaniaItems.lexicon, "itemGroup.botania",
							"botania.desc", prefix("textures/block/livingwood_log.png")))
					.method_709("flower", onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS))
					.method_694(consumer, mainId("root"));

			class_161 flowerPickup = class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.pinkFlower, "flowerPickup", class_189.field_1254))
					.method_701(root)
					.method_709("flower", onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS))
					.method_709("double_flower", onPickup(BotaniaTags.Items.DOUBLE_MYSTICAL_FLOWERS))
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("flower_pickup"));

			class_161 manaPoolPickup = class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.manaPool, "manaPoolPickup", class_189.field_1254))
					.method_701(flowerPickup)
					.method_709("pickup", onPickup(BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool))
					.method_694(consumer, mainId("mana_pool_pickup"));

			class_161 runePickup = class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.runeAltar, "runePickup", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("rune", onPickup(BotaniaTags.Items.RUNES))
					.method_694(consumer, mainId("rune_pickup"));

			class_161 terrasteelPickup = class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.terrasteel, "terrasteelPickup", class_189.field_1254))
					.method_701(runePickup)
					.method_709("terrasteel", onPickup(BotaniaItems.terrasteel))
					.method_694(consumer, mainId("terrasteel_pickup"));

			class_161 elfPortalOpen = class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.alfPortal, "elfPortalOpen", class_189.field_1254))
					.method_701(terrasteelPickup)
					.method_709("portal", new AlfheimPortalTrigger.Instance(class_5258.field_24388, class_2073.field_9640, class_2090.field_9685))
					.method_694(consumer, mainId("elf_portal_open"));

			class_161 gaiaGuardianKill = class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.gaiaHead, "gaiaGuardianKill", class_189.field_1254))
					.method_701(elfPortalOpen)
					.method_709("guardian", class_2080.class_2083
							.method_8997(class_2048.class_2049.method_8916().method_8921(BotaniaEntities.DOPPLEGANGER)))
					.method_694(consumer, mainId("gaia_guardian_kill"));

			class_161 enderAirMake = class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.enderAirBottle, "enderAirMake", class_189.field_1254))
					.method_701(elfPortalOpen)
					.method_709("air", onPickup(BotaniaItems.enderAirBottle))
					.method_694(consumer, mainId("ender_air_make"));

			// Parent: root
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.lexicon, "lexiconUse", class_189.field_1254))
					.method_701(root)
					.method_709("use_lexicon", new UseItemSuccessTrigger.Instance(class_5258.field_24388,
							class_2073.class_2074.method_8973().method_8977(BotaniaItems.lexicon).method_8976(), class_2090.field_9685))
					.method_694(consumer, mainId("lexicon_use"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.cacophonium, "cacophoniumCraft", class_189.field_1254))
					.method_701(root)
					.method_709("cacophonium", onPickup(BotaniaItems.cacophonium))
					.method_694(consumer, mainId("cacophonium_craft"));

			// Parent: mystical flowers
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.endoflame, "generatingFlower", class_189.field_1254))
					.method_701(flowerPickup)
					.method_709("flower", onPickup(BotaniaTags.Items.GENERATING_SPECIAL_FLOWERS))
					.method_694(consumer, mainId("generating_flower"));

			// Parent: mana pool
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.enchanter, "enchanterMake", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, mainId("enchanter_make"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.bellethorn, "functionalFlower", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("flower", onPickup(BotaniaTags.Items.FUNCTIONAL_SPECIAL_FLOWERS))
					.method_694(consumer, mainId("functional_flower"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.poolMinecart, "manaCartCraft", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("poolcart", onPickup(BotaniaItems.poolMinecart))
					.method_694(consumer, mainId("mana_cart_craft"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.manaweaveCloth, "manaweaveArmorCraft", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("head", onPickup(BotaniaItems.manaweaveHelm, BotaniaItems.manaweaveChest, BotaniaItems.manaweaveLegs, BotaniaItems.manaweaveBoots))
					.method_694(consumer, mainId("manaweave_armor_craft"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.spark, "sparkCraft", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("spark", onPickup(BotaniaItems.spark))
					.method_694(consumer, mainId("spark_craft"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.manaCookie, "manaCookieEat", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("cookie", class_2010.class_2012.method_8828(BotaniaItems.manaCookie))
					.method_694(consumer, mainId("mana_cookie_eat"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.craftingHalo, "craftingHaloCraft", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("pool", onPickup(BotaniaItems.craftingHalo))
					.method_694(consumer, mainId("crafting_halo_craft"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.manaRing, "baubleWear", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, mainId("bauble_wear"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.tinyPotato, "tinyPotatoPet", class_189.field_1254))
					.method_701(manaPoolPickup)
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, mainId("tiny_potato_pet"));

			// Parent: runes
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.manaGun, "manaBlasterShoot", class_189.field_1254))
					.method_701(runePickup)
					.method_709("shoot", new ManaBlasterTrigger.Instance(class_5258.field_24388, class_2073.field_9640, class_2048.field_9599))
					.method_694(consumer, mainId("mana_blaster_shoot"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.pollidisiac, "pollidisiacPickup", class_189.field_1254))
					.method_701(runePickup)
					.method_709("pollidisiac", onPickup(BotaniaFlowerBlocks.pollidisiac))
					.method_694(consumer, mainId("pollidisiac_pickup"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.dirtRod, "dirtRodCraft", class_189.field_1254))
					.method_701(runePickup)
					.method_709("dirtrod", onPickup(BotaniaItems.dirtRod))
					.method_694(consumer, mainId("dirt_rod_craft"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.brewery, "brewPickup", class_189.field_1254))
					.method_701(runePickup)
					.method_709("pickup", onPickup(BotaniaItems.brewFlask, BotaniaItems.brewVial))
					.method_694(consumer, mainId("brew_pickup"));

			// Parent: terrasteel
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.terraSword, "terrasteelWeaponCraft", class_189.field_1254))
					.method_701(terrasteelPickup)
					.method_709("terrablade", onPickup(BotaniaItems.terraSword, BotaniaItems.thornChakram))
					.method_694(consumer, mainId("terrasteel_weapon_craft"));

			// Parent: elven portal
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.heiseiDream, "heiseiDreamPickup", class_189.field_1254))
					.method_701(elfPortalOpen)
					.method_709("heisei_dream", onPickup(BotaniaFlowerBlocks.heiseiDream))
					.method_694(consumer, mainId("heisei_dream_pickup"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.kekimurus, "kekimurusPickup", class_189.field_1254))
					.method_701(elfPortalOpen)
					.method_709("kekimurus", onPickup(BotaniaFlowerBlocks.kekimurus))
					.method_694(consumer, mainId("kekimurus_pickup"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.bubbell, "bubbellPickup", class_189.field_1254))
					.method_701(elfPortalOpen)
					.method_709("bubbell", onPickup(BotaniaFlowerBlocks.bubbell))
					.method_694(consumer, mainId("bubbell_pickup"));

			// Parent: gaia guardian
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.spawnerMover, "spawnerMoverUse", class_189.field_1254))
					.method_701(gaiaGuardianKill)
					.method_709("use_spawner_mover", new UseItemSuccessTrigger.Instance(class_5258.field_24388,
							class_2073.class_2074.method_8973().method_8977(BotaniaItems.spawnerMover).method_8976(), class_2090.field_9685))
					.method_694(consumer, mainId("spawner_mover_use"));
			class_185 tiaraWings = simple(BotaniaItems.flightTiara, "tiaraWings", class_189.field_1254);
			tiaraWings.method_821().method_7948().method_10569("variant", 1);
			class_2066.class_2068[] variants = IntStream.range(1, FlugelTiaraItem.WING_TYPES)
					.mapToObj(i -> {
						class_2487 tag = new class_2487();
						tag.method_10569("variant", i);
						return tag;
					})
					.map(nbt -> class_2073.class_2074.method_8973().method_8977(BotaniaItems.flightTiara).method_20399(nbt).method_8976())
					.map(class_2066.class_2068::method_8957)
					.toArray(class_2066.class_2068[]::new);
			var builder = class_161.class_162.method_707()
					.method_693(tiaraWings)
					.method_701(gaiaGuardianKill)
					.method_704(class_193.field_1257);
			for (int i = 0; i < variants.length; i++) {
				var variant = variants[i];
				builder.method_709("tiara_" + (i + 1), variant);
			}
			builder.method_694(consumer, mainId("tiara_wings"));

			class_161.class_162.method_707()
					.method_693(simple(BotaniaFlowerBlocks.dandelifeon, "dandelifeonPickup", class_189.field_1254))
					.method_701(gaiaGuardianKill)
					.method_709("dandelifeon", onPickup(BotaniaFlowerBlocks.dandelifeon))
					.method_694(consumer, mainId("dandelifeon_pickup"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.manaBomb, "manaBombIgnite", class_189.field_1254))
					.method_701(gaiaGuardianKill)
					.method_709("bomb", onPickup(BotaniaBlocks.manaBomb))
					.method_694(consumer, mainId("mana_bomb_ignite"));

			// Parent: ender air
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.lightRelayDefault, "luminizerRide", class_189.field_1254))
					.method_701(enderAirMake)
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, mainId("luminizer_ride"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.corporeaCrystalCube, "corporeaCraft", class_189.field_1254))
					.method_701(enderAirMake)
					.method_709("pickup", onPickup(BotaniaBlocks.corporeaCrystalCube, BotaniaBlocks.corporeaFunnel,
							BotaniaBlocks.corporeaIndex, BotaniaBlocks.corporeaInterceptor, BotaniaBlocks.corporeaRetainer))
					.method_694(consumer, mainId("corporea_craft"));

			// Lexicon locks
			class_161.class_162.method_707()
					.method_701(root)
					.method_709("flower", onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("flower_pickup_lexicon"));
			class_161.class_162.method_707()
					.method_701(flowerPickup)
					.method_709("apothecary", onPickup(BotaniaBlocks.defaultAltar))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("apothecary_pickup"));
			class_161.class_162.method_707()
					.method_701(flowerPickup)
					.method_709("daisy", onPickup(BotaniaFlowerBlocks.pureDaisy))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("pure_daisy_pickup"));
			class_161.class_162.method_707()
					.method_701(root)
					.method_709("pickup", onPickup(BotaniaBlocks.manaPool, BotaniaBlocks.creativePool, BotaniaBlocks.dilutedPool, BotaniaBlocks.fabulousPool))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("mana_pool_pickup_lexicon"));
			class_161.class_162.method_707()
					.method_701(flowerPickup)
					.method_709("altar", onPickup(BotaniaBlocks.runeAltar))
					.method_709("rune", onPickup(BotaniaTags.Items.RUNES))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("runic_altar_pickup"));
			class_161.class_162.method_707()
					.method_701(flowerPickup)
					.method_709("terrasteel", onPickup(BotaniaItems.terrasteel))
					.method_709("elven_lexicon", elvenLexicon)
					.method_704(class_193.field_1257)
					.method_694(consumer, mainId("terrasteel_pickup_lexicon"));
			class_161.class_162.method_707()
					.method_701(elfPortalOpen)
					.method_709("lexicon", elvenLexicon)
					.method_694(consumer, mainId("elf_lexicon_pickup"));
		}
	}

	public static class BotaniaChallengeAdvancements implements class_7785 {

		private static final class_1299<?>[] LOONIUM_MOBS_TO_KILL = {
				class_1299.field_6099,
				class_1299.field_6084,
				class_1299.field_6046,
				class_1299.field_6123,
				class_1299.field_6091,
				class_1299.field_6090,
				class_1299.field_6118,
				class_1299.field_21973,
				class_1299.field_6071,
				class_1299.field_22281,
				class_1299.field_25751,
				class_1299.field_6105,
				class_1299.field_6109,
				class_1299.field_6125,
				class_1299.field_6137,
				class_1299.field_6098,
				class_1299.field_6117,
				class_1299.field_6076,
				class_1299.field_23696,
				class_1299.field_6054,
				class_1299.field_6051,
				class_1299.field_6050
		};

		@Override
		public void method_10335(class_7225.class_7874 lookup, Consumer<class_161> consumer) {
			class_161 root = class_161.class_162.method_707()
					.method_693(rootDisplay(BotaniaItems.dice, "advancement.botania_challenge",
							"advancement.botania_challenge.desc", prefix("textures/block/livingrock_bricks.png")))
					.method_709("flower", onPickup(BotaniaTags.Items.MYSTICAL_FLOWERS))
					.method_694(consumer, challengeId("root"));

			// hardmode Gaia Guardian related
			class_2487 hardmodeNbt = new class_2487();
			hardmodeNbt.method_10556("hardMode", true);
			class_161 hardMode = class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.lifeEssence, "gaiaGuardianHardmode", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(100))
					.method_709("guardian", class_2080.class_2083.method_35248(
							class_2048.class_2049.method_8916()
									.method_8921(BotaniaEntities.DOPPLEGANGER)
									.method_8915(new class_2105(hardmodeNbt)).method_8920()))
					.method_694(consumer, challengeId("gaia_guardian_hardmode"));

			relicBindAdvancement(consumer, hardMode, BotaniaItems.infiniteFruit, "infiniteFruit", "fruit");
			relicBindAdvancement(consumer, hardMode, BotaniaItems.kingKey, "kingKey", "key");
			relicBindAdvancement(consumer, hardMode, BotaniaItems.flugelEye, "flugelEye", "eye");
			relicBindAdvancement(consumer, hardMode, BotaniaItems.thorRing, "thorRing", "ring");
			relicBindAdvancement(consumer, hardMode, BotaniaItems.odinRing, "odinRing", "ring");
			class_161 lokiRing = relicBindAdvancement(consumer, hardMode, BotaniaItems.lokiRing, "lokiRing", "ring");

			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.lokiRing, "lokiRingMany", class_189.field_1250))
					.method_701(lokiRing)
					.method_703(class_170.class_171.method_750(85))
					.method_709("place_blocks", new LokiPlaceTrigger.Instance(
							class_5258.field_24388, class_2048.field_9599, class_2073.field_9640, class_2096.class_2100.method_9053(255)
					))
					.method_694(consumer, challengeId("loki_ring_many"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.pinkinator, "pinkinator", class_189.field_1250))
					.method_701(hardMode)
					.method_703(class_170.class_171.method_750(40))
					.method_709("use_pinkinator", new UseItemSuccessTrigger.Instance(
							class_5258.field_24388, matchItems(BotaniaItems.pinkinator), class_2090.field_9685))
					.method_694(consumer, challengeId("pinkinator"));

			// Misc challenges
			class_161.class_162.method_707()
					.method_693(simple(class_2246.field_10432, "gaiaGuardianNoArmor", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(1000))
					.method_709("no_armor", new GaiaGuardianNoArmorTrigger.Instance(
							class_5258.field_24388, class_2048.field_9599, class_2022.field_9533))
					.method_694(consumer, challengeId("gaia_guardian_no_armor"));
			class_161.class_162.method_707()
					.method_693(hidden(BotaniaBlocks.motifDaybloom, "old_flower_pickup", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(40))
					.method_709("flower", onPickup(BotaniaBlocks.motifDaybloom, BotaniaBlocks.motifNightshade))
					.method_704(class_193.field_1257)
					.method_694(consumer, challengeId("old_flower_pickup"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.corporeaIndex, "superCorporeaRequest", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(85))
					.method_709("big_request", new CorporeaRequestTrigger.Instance(
							class_5258.field_24388, class_2096.class_2100.method_9053(CorporeaIndexBlockEntity.MAX_REQUEST), class_2090.field_9685))
					.method_694(consumer, challengeId("super_corporea_request"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.terraPick, "rankSSPick", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(500))
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, challengeId("rank_ss_pick"));
			class_2487 level20Shard = new class_2487();
			level20Shard.method_10569("level", 19);
			class_161.class_162.method_707()
					.method_693(simple(BotaniaItems.laputaShard, "l20ShardUse", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(65))
					.method_709("use_l20_shard", class_2066.class_2068.method_8957(
							class_2073.class_2074.method_8973().method_8977(BotaniaItems.laputaShard).method_20399(level20Shard).method_8976()))
					.method_694(consumer, challengeId("l20_shard_use"));
			class_161.class_162.method_707()
					.method_693(hidden(class_1802.field_8229, "alfPortalBread", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(40))
					.method_709("bread", new AlfheimPortalBreadTrigger.Instance(class_5258.field_24388, class_2090.field_9685))
					.method_694(consumer, challengeId("alf_portal_bread"));
			class_161.class_162.method_707()
					.method_693(simple(BotaniaBlocks.tinyPotato, "tinyPotatoBirthday", class_189.field_1250))
					.method_701(root)
					.method_703(class_170.class_171.method_750(40))
					.method_709("code_triggered", new class_2062.class_2063())
					.method_694(consumer, challengeId("tiny_potato_birthday"));
			addLooniumMobsToKill(class_161.class_162.method_707())
					.method_693(simple(BotaniaFlowerBlocks.loonium, "allLooniumMobs", class_189.field_1250))
					.method_701(root)
					.method_704(class_193.field_16882)
					.method_694(consumer, challengeId("all_loonium_mobs"));
		}

		private static class_161.class_162 addLooniumMobsToKill(class_161.class_162 builder) {
			for (class_1299<?> entityType : LOONIUM_MOBS_TO_KILL) {
				builder.method_709(
						class_7923.field_41177.method_10221(entityType).toString(),
						class_2080.class_2083.method_8997(class_2048.class_2049.method_8916()
								.method_8921(entityType).method_22470(LooniumBlockEntity.LOONIUM_TEAM_NAME))
				);
			}

			return builder;
		}
	}

	private static class_161 relicBindAdvancement(Consumer<class_161> consumer, class_161 parent, class_1792 relicItem,
			String titleKey, String criterionName) {
		String id = challengeId(class_7923.field_41178.method_10221(relicItem).method_12832());
		return class_161.class_162.method_707()
				.method_693(simple(relicItem, titleKey, class_189.field_1250))
				.method_701(parent)
				.method_703(class_170.class_171.method_750(50))
				.method_709(criterionName, new RelicBindTrigger.Instance(class_5258.field_24388,
						class_2073.class_2074.method_8973().method_8977(relicItem).method_8976()))
				.method_694(consumer, id);
	}

	protected static class_2066.class_2068 onPickup(class_6862<class_1792> tag) {
		return class_2066.class_2068.method_8957(
				class_2073.class_2074.method_8973().method_8975(tag).method_8976());
	}

	protected static class_2066.class_2068 onPickup(class_1935... items) {
		return class_2066.class_2068.method_8957(matchItems(items));
	}

	protected static class_2073 matchItems(class_1935... items) {
		return class_2073.class_2074.method_8973().method_8977(items).method_8976();
	}

	protected static class_185 simple(class_1935 icon, String name, class_189 frameType) {
		String expandedName = "advancement.botania:" + name;
		return new class_185(new class_1799(icon.method_8389()),
				class_2561.method_43471(expandedName),
				class_2561.method_43471(expandedName + ".desc"),
				null, frameType, true, true, false);
	}

	protected static class_185 hidden(class_1935 icon, String name, class_189 frameType) {
		String expandedName = "advancement.botania:" + name;
		return new class_185(new class_1799(icon.method_8389()),
				class_2561.method_43471(expandedName),
				class_2561.method_43471(expandedName + ".desc"),
				null, frameType, true, true, true);
	}

	protected static class_185 rootDisplay(class_1935 icon, String titleKey, String descKey, class_2960 background) {
		return new class_185(new class_1799(icon.method_8389()),
				class_2561.method_43471(titleKey),
				class_2561.method_43471(descKey),
				background, class_189.field_1254, false, false, false);
	}

	private static String mainId(String name) {
		return prefix("main/" + name).toString();
	}

	private static String challengeId(String name) {
		return prefix("challenge/" + name).toString();
	}
}
