/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.item.brew;

import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.BrewContainer;
import vazkii.botania.api.brew.BrewItem;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.CustomCreativeTabContents;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class IncenseStickItem extends class_1792 implements BrewItem, BrewContainer, CustomCreativeTabContents {

	private static final String TAG_BREW_KEY = "brewKey";
	public static final int TIME_MULTIPLIER = 60;

	public IncenseStickItem(class_1793 builder) {
		super(builder);
	}

	@Override
	public void addToCreativeTab(class_1792 me, class_1761.class_7704 output) {
		output.method_45421(this);
		for (Brew brew : BotaniaAPI.instance().getBrewRegistry()) {
			class_1799 brewStack = getItemForBrew(brew, new class_1799(this));
			if (!brewStack.method_7960()) {
				output.method_45420(brewStack);
			}
		}
	}

	@Override
	public void method_7851(class_1799 stack, class_1937 world, List<class_2561> list, class_1836 flags) {
		Brew brew = getBrew(stack);
		if (brew == BotaniaBrews.fallbackBrew) {
			list.add(class_2561.method_43471("botaniamisc.notInfused").method_27692(class_124.field_1076));
			return;
		}

		list.add(class_2561.method_43469("botaniamisc.brewOf", class_2561.method_43471(brew.getTranslationKey(stack))).method_27692(class_124.field_1076));
		BaseBrewItem.addPotionTooltip(brew.getPotionEffects(stack), list, TIME_MULTIPLIER);
	}

	@Override
	public Brew getBrew(class_1799 stack) {
		String key = ItemNBTHelper.getString(stack, TAG_BREW_KEY, "");
		return BotaniaAPI.instance().getBrewRegistry().method_10223(class_2960.method_12829(key));
	}

	public static void setBrew(class_1799 stack, Brew brew) {
		setBrew(stack, BotaniaAPI.instance().getBrewRegistry().method_10221(brew));
	}

	public static void setBrew(class_1799 stack, class_2960 brew) {
		ItemNBTHelper.setString(stack, TAG_BREW_KEY, brew.toString());
	}

	@Override
	public class_1799 getItemForBrew(Brew brew, class_1799 stack) {
		if (!brew.canInfuseIncense() || brew.getPotionEffects(stack).size() != 1 || brew.getPotionEffects(stack).get(0).method_5579().method_5561()) {
			return class_1799.field_8037;
		}

		class_1799 brewStack = new class_1799(this);
		setBrew(brewStack, brew);
		return brewStack;
	}

	@Override
	public int getManaCost(Brew brew, class_1799 stack) {
		return brew.getManaCost() * 10;
	}
}
