/*
 * This class is distributed as part of the Botania Mod.
 * Get the Source Code in github:
 * https://github.com/Vazkii/Botania
 *
 * Botania is Open Source and distributed under the
 * Botania License: http://botaniamod.net/license.php
 */
package vazkii.botania.common.block.flower.functional;

import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;

import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;

public class HyacidusBlockEntity extends FunctionalFlowerBlockEntity {
	private static final int RANGE = 6;
	private static final int COST = 20;

	public HyacidusBlockEntity(class_2338 pos, class_2680 state) {
		super(BotaniaFlowerBlocks.HYACIDUS, pos, state);
	}

	@Override
	public void tickFlower() {
		super.tickFlower();

		if (method_10997().field_9236 || redstoneSignal > 0) {
			return;
		}

		List<class_1309> entities = method_10997().method_18467(class_1309.class, new class_238(getEffectivePos().method_10069(-RANGE, -RANGE, -RANGE), getEffectivePos().method_10069(RANGE + 1, RANGE + 1, RANGE + 1)));
		for (class_1309 entity : entities) {
			if (!(entity instanceof class_1657) && entity.method_6112(class_1294.field_5899) == null && getMana() >= COST && !entity.method_37908().field_9236 && entity.method_6046() != class_1310.field_6289) {
				entity.method_6092(new class_1293(class_1294.field_5899, 60, 0));
				addMana(-COST);
			}
		}
	}

	@Override
	public boolean acceptsRedstone() {
		return true;
	}

	@Override
	public int getColor() {
		return 0x8B438F;
	}

	@Override
	public int getMaxMana() {
		return 180;
	}

	@Override
	public RadiusDescriptor getRadius() {
		return RadiusDescriptor.Rectangle.square(getEffectivePos(), RANGE);
	}

}
