/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.SuspiciousEffectHolder;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.block_entity.BindableSpecialFlowerBlockEntity;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.helper.DelayHelper;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.mixin.AnimalAccessor;
import vazkii.botania.mixin.MushroomCowAccessor;

public class PollidisiacBlockEntity
extends FunctionalFlowerBlockEntity
implements Wandable {
    private static final String TAG_FEEDING_MODE = "mode";
    private static final int RANGE = 6;
    private static final int MANA_COST = 12;
    @NotNull
    private Mode mode = Mode.FEED_ADULTS;

    public PollidisiacBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.POLLIDISIAC, pos, state);
    }

    @Override
    public void tickFlower() {
        List<ItemEntity> items;
        super.tickFlower();
        if (!this.m_58904_().f_46443_ && this.getMana() >= 12 && !(items = this.getItems()).isEmpty()) {
            List<Animal> animals = this.getAnimals();
            this.feedAnimal(animals, items);
        }
    }

    @NotNull
    private List<ItemEntity> getItems() {
        AABB pickupBounds = new AABB(this.m_58899_()).m_82400_(6.0);
        return this.m_58904_().m_6443_(ItemEntity.class, pickupBounds, itemEntity -> DelayHelper.canInteractWith(this, itemEntity));
    }

    @NotNull
    private List<Animal> getAnimals() {
        AABB bounds = new AABB(this.getEffectivePos()).m_82400_(6.0);
        return this.m_58904_().m_6443_(Animal.class, bounds, (Predicate)this.mode);
    }

    private void feedAnimal(List<Animal> animals, List<ItemEntity> items) {
        Collections.shuffle(animals);
        animals.sort(Comparator.comparing(AgeableMob::m_6162_).thenComparingInt(animal -> Math.min(animal.m_146764_(), 0)));
        for (Animal animal2 : animals) {
            if (animal2.m_146764_() == 0 && !animal2.m_27593_() || animal2.m_146764_() < -600 && -animal2.m_146764_() % 100 == 0) {
                for (ItemEntity item : items) {
                    if (!animal2.m_6898_(item.m_32055_())) continue;
                    this.consumeFoodItemAndMana(item);
                    if (animal2.m_6162_()) {
                        animal2.m_146740_(AgeableMob.m_216967_((int)(-animal2.m_146764_())), true);
                    } else {
                        animal2.m_27601_(1200);
                        ((AnimalAccessor)animal2).botania_setLoveCause(null);
                    }
                    this.m_58904_().m_7605_((Entity)animal2, (byte)18);
                    break;
                }
                if (this.getMana() < 12) break;
            }
            if (animal2.m_6162_() || !PollidisiacBlockEntity.isBrownMooshroomWithoutEffect(animal2)) continue;
            for (ItemEntity item : items) {
                SuspiciousEffectHolder effect;
                ItemStack stack = item.m_32055_();
                if (!stack.m_204117_(ItemTags.f_13145_) || (effect = SuspiciousEffectHolder.m_257980_((ItemLike)stack.m_41720_())) == null) continue;
                this.consumeFoodItemAndMana(item);
                MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal2;
                cowAccessor.setEffect(effect.m_53521_());
                cowAccessor.setEffectDuration(effect.m_53522_());
                animal2.m_5496_(SoundEvents.f_12072_, 2.0f, 1.0f);
                break;
            }
            if (this.getMana() >= 12) continue;
            break;
        }
    }

    private void consumeFoodItemAndMana(ItemEntity itemEntity) {
        EntityHelper.shrinkItem(itemEntity);
        this.addMana(-12);
    }

    private static boolean isBrownMooshroomWithoutEffect(Animal animal) {
        MushroomCow mushroomCow;
        if (animal instanceof MushroomCow && (mushroomCow = (MushroomCow)animal).m_28554_() == MushroomCow.MushroomType.BROWN) {
            MushroomCowAccessor cowAccessor = (MushroomCowAccessor)animal;
            return cowAccessor.getEffect() == null;
        }
        return false;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 6);
    }

    @Override
    public RadiusDescriptor getSecondaryRadius() {
        return this.m_58899_().equals((Object)this.getEffectivePos()) ? null : RadiusDescriptor.Rectangle.square(this.m_58899_(), 6);
    }

    @Override
    public int getMaxMana() {
        return 120;
    }

    @Override
    public int getColor() {
        return 13584665;
    }

    @NotNull
    public Mode getMode() {
        return this.mode;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack stack, Direction side) {
        if (player == null || player.m_6144_()) {
            this.mode = this.mode.getNextMode();
            this.m_6596_();
            this.sync();
            return true;
        }
        return false;
    }

    @Override
    public void readFromPacketNBT(CompoundTag cmp) {
        super.readFromPacketNBT(cmp);
        this.mode = Mode.forName(cmp.m_128461_(TAG_FEEDING_MODE));
    }

    @Override
    public void writeToPacketNBT(CompoundTag cmp) {
        super.writeToPacketNBT(cmp);
        cmp.m_128359_(TAG_FEEDING_MODE, this.mode.m_7912_());
    }

    public static enum Mode implements StringRepresentable,
    Predicate<Animal>
    {
        FEED_ADULTS("feed_adults", Predicate.not(AgeableMob::m_6162_)),
        FEED_BABIES("feed_babies", AgeableMob::m_6162_),
        FEED_ALL("feed_all", animal -> true);

        private static final StringRepresentable.EnumCodec<Mode> CODEC;
        @NotNull
        private final String name;
        @NotNull
        private final Predicate<Animal> predicate;

        public static Mode forName(String name) {
            return (Mode)CODEC.m_262792_(name, (Enum)FEED_ADULTS);
        }

        private Mode(String name, Predicate<Animal> predicate) {
            this.name = name;
            this.predicate = predicate;
        }

        @Override
        public boolean test(Animal animal) {
            return this.predicate.test(animal);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        @NotNull
        public Mode getNextMode() {
            Mode[] modes = Mode.values();
            int nextMode = this.ordinal() + 1;
            return modes[nextMode % modes.length];
        }

        static {
            CODEC = StringRepresentable.m_216439_(Mode::values);
        }
    }

    public static class WandHud
    extends BindableSpecialFlowerBlockEntity.BindableFlowerWandHud<PollidisiacBlockEntity> {
        public WandHud(PollidisiacBlockEntity flower) {
            super(flower);
        }

        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            String filter = I18n.m_118938_((String)("botaniamisc.pollidisiac." + ((PollidisiacBlockEntity)this.flower).getMode().m_7912_()), (Object[])new Object[0]);
            int filterWidth = mc.f_91062_.m_92895_(filter);
            int filterTextStart = (mc.m_91268_().m_85445_() - filterWidth) / 2;
            int halfMinWidth = (filterWidth + 4) / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            super.renderHUD(gui, mc, halfMinWidth, halfMinWidth, 40);
            gui.m_280488_(mc.f_91062_, filter, filterTextStart, centerY + 30, ((PollidisiacBlockEntity)this.flower).getColor());
        }
    }
}

