/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.state.BotaniaStateProperties;
import vazkii.botania.common.block.BotaniaBlock;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ManaEnchanterBlockEntity;
import vazkii.botania.common.item.WandOfTheForestItem;

public class ManaEnchanterBlock
extends BotaniaBlock
implements EntityBlock {
    public ManaEnchanterBlock(BlockBehaviour.Properties builder) {
        super(builder);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(BotaniaStateProperties.ENCHANTER_DIRECTION, (Comparable)Direction.Axis.X));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BotaniaStateProperties.ENCHANTER_DIRECTION});
    }

    @NotNull
    public BlockEntity m_142194_(@NotNull BlockPos pos, @NotNull BlockState state) {
        return new ManaEnchanterBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return ManaEnchanterBlock.createTickerHelper(type, BotaniaBlockEntities.ENCHANTER, ManaEnchanterBlockEntity::commonTick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        boolean stackEnchantable;
        ManaEnchanterBlockEntity enchanter = (ManaEnchanterBlockEntity)world.m_7702_(pos);
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && stack.m_41720_() instanceof WandOfTheForestItem) {
            return InteractionResult.PASS;
        }
        boolean bl = stackEnchantable = !stack.m_41619_() && !stack.m_150930_(Items.f_42517_) && stack.m_41792_() && stack.m_41613_() == 1;
        if (enchanter.itemToEnchant.m_41619_()) {
            if (!stackEnchantable) return InteractionResult.PASS;
            enchanter.itemToEnchant = stack.m_41777_();
            player.m_21008_(hand, ItemStack.f_41583_);
            enchanter.sync();
            return InteractionResult.m_19078_((boolean)world.m_5776_());
        } else {
            if (enchanter.stage != ManaEnchanterBlockEntity.State.IDLE) return InteractionResult.m_19078_((boolean)world.m_5776_());
            player.m_150109_().m_150079_(enchanter.itemToEnchant.m_41777_());
            enchanter.itemToEnchant = ItemStack.f_41583_;
            enchanter.sync();
        }
        return InteractionResult.m_19078_((boolean)world.m_5776_());
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity tile = world.m_7702_(pos);
            if (tile instanceof ManaEnchanterBlockEntity) {
                ManaEnchanterBlockEntity enchanter = (ManaEnchanterBlockEntity)tile;
                if (!enchanter.itemToEnchant.m_41619_()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)enchanter.itemToEnchant);
                }
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }
}

