/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.MushroomBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.recipe.CustomApothecaryColor;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.item.material.MysticalPetalItem;
import vazkii.botania.xplat.BotaniaConfig;

public class BotaniaMushroomBlock
extends MushroomBlock
implements CustomApothecaryColor {
    private static final VoxelShape SHAPE = BotaniaMushroomBlock.m_49796_((double)4.8, (double)0.0, (double)4.8, (double)12.8, (double)16.0, (double)12.8);
    public final DyeColor color;

    public BotaniaMushroomBlock(DyeColor color, BlockBehaviour.Properties builder) {
        super(builder, TreeFeatures.f_195121_);
        this.color = color;
    }

    public boolean m_221773_(ServerLevel level, BlockPos pos, BlockState state, RandomSource rand) {
        return false;
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext ctx) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState state, LevelReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.m_7495_();
        BlockState blockstate = worldIn.m_8055_(blockpos);
        if (!blockstate.m_204336_(BlockTags.f_13057_)) {
            return this.m_6266_(blockstate, (BlockGetter)worldIn, blockpos);
        }
        return true;
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
        int hex = MysticalPetalItem.getPetalLikeColor(this.color);
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.m_188500_() < BotaniaConfig.client().flowerParticleFrequency() * 0.25) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.m_188501_(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.m_7106_((ParticleOptions)data, (double)pos.m_123341_() + 0.3 + (double)rand.m_188501_() * 0.5, (double)pos.m_123342_() + 0.5 + (double)rand.m_188501_() * 0.5, (double)pos.m_123343_() + 0.3 + (double)rand.m_188501_() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public int getParticleColor(ItemStack stack) {
        return MysticalPetalItem.getPetalLikeColor(this.color);
    }
}

