/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.integration.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.recipe.BotanicalBreweryRecipe;
import vazkii.botania.client.integration.emi.BlendTextureWidget;
import vazkii.botania.client.integration.emi.BotaniaEmiPlugin;
import vazkii.botania.client.integration.emi.BotaniaEmiRecipe;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class BotanicalBreweryEmiRecipe
extends BotaniaEmiRecipe {
    private static final ResourceLocation TEXTURE = ResourceLocationHelper.prefix("textures/gui/nei_brewery.png");
    private final List<EmiIngredient> ingredients;
    private final ResourceLocation id;

    public BotanicalBreweryEmiRecipe(BotanicalBreweryRecipe recipe, ItemStack container) {
        super(BotaniaEmiPlugin.BOTANICAL_BREWERY, recipe);
        this.ingredients = recipe.m_7527_().stream().map(EmiIngredient::of).toList();
        this.input = Stream.concat(Stream.of(EmiStack.of((ItemStack)container)), this.ingredients.stream()).toList();
        this.output = List.of(EmiStack.of((ItemStack)recipe.getOutput(container.m_41777_())));
        ResourceLocation id = recipe.m_6423_();
        ResourceLocation itemId = BuiltInRegistries.f_257033_.m_7981_((Object)container.m_41720_());
        this.id = new ResourceLocation("emi", "botania/botanical_brewery/" + id.m_135827_() + "/" + id.m_135815_() + "/" + itemId.m_135827_() + "/" + itemId.m_135815_());
    }

    @Override
    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public int getDisplayHeight() {
        return 65;
    }

    public int getDisplayWidth() {
        return 120;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.add((Widget)new BlendTextureWidget(TEXTURE, 0, 0, 86, 55, 28, 6));
        widgets.addSlot((EmiIngredient)this.input.get(this.output.size() - 1), 10, 35);
        int sx = 58 - (this.ingredients.size() - 1) * 9;
        for (EmiIngredient stack : this.ingredients) {
            widgets.addSlot(stack, sx, 1).drawBack(false);
            sx += 18;
        }
        widgets.addSlot((EmiIngredient)this.output.get(0), 58, 35).recipeContext((EmiRecipe)this);
    }
}

