/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.functional;

import com.google.common.base.Predicates;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vazkii.botania.api.block_entity.FunctionalFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.mixin.HurtByTargetGoalAccessor;
import vazkii.botania.mixin.MobAccessor;

public class HeiseiDreamBlockEntity
extends FunctionalFlowerBlockEntity {
    private static final int RANGE = 5;
    private static final int COST = 100;

    public HeiseiDreamBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.HEISEI_DREAM, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.m_58904_().f_46443_) {
            return;
        }
        List mobs = this.m_58904_().m_6443_(Mob.class, new AABB(this.getEffectivePos().m_7918_(-5, -5, -5), this.getEffectivePos().m_7918_(6, 6, 6)), (Predicate)Predicates.instanceOf(Enemy.class));
        if (mobs.size() > 1 && this.getMana() >= 100) {
            for (Mob mob : mobs) {
                if (!HeiseiDreamBlockEntity.brainwashEntity(mob, mobs)) continue;
                this.addMana(-100);
                this.sync();
                break;
            }
        }
    }

    public static boolean brainwashEntity(Mob entity, List<Mob> mobs) {
        LivingEntity target = entity.m_5448_();
        boolean did = false;
        if (!(target instanceof Enemy)) {
            Mob newTarget;
            while ((newTarget = mobs.get(entity.m_9236_().f_46441_.m_188503_(mobs.size()))) == entity) {
            }
            entity.m_6710_(null);
            GoalSelector targetSelector = ((MobAccessor)entity).getTargetSelector();
            for (WrappedGoal entry : targetSelector.m_148105_()) {
                Goal goal = entry.m_26015_();
                if (!(goal instanceof HurtByTargetGoal)) continue;
                HurtByTargetGoal goal2 = (HurtByTargetGoal)goal;
                Object[] ignoreClasses = ((HurtByTargetGoalAccessor)goal2).getIgnoreDamageClasses();
                Arrays.fill(ignoreClasses, Void.TYPE);
                targetSelector.m_25363_((Goal)goal2);
                targetSelector.m_25352_(-1, (Goal)goal2);
                break;
            }
            entity.m_6703_((LivingEntity)newTarget);
            did = true;
        }
        return did;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return RadiusDescriptor.Rectangle.square(this.getEffectivePos(), 5);
    }

    @Override
    public int getColor() {
        return 16720285;
    }

    @Override
    public int getMaxMana() {
        return 1000;
    }
}

