/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.bauble;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.client.core.helper.AccessoryRenderHelper;
import vazkii.botania.client.render.AccessoryRenderRegistry;
import vazkii.botania.client.render.AccessoryRenderer;
import vazkii.botania.common.handler.EquipmentHandler;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.BaubleItem;
import vazkii.botania.common.proxy.Proxy;

public class TectonicGirdleItem
extends BaubleItem {
    private static final ResourceLocation texture = new ResourceLocation("botania:textures/model/belt_knockback.png");

    public TectonicGirdleItem(Item.Properties props) {
        super(props);
        Proxy.INSTANCE.runOnClient(() -> () -> AccessoryRenderRegistry.register(this, new Renderer()));
    }

    @Override
    public Multimap<Attribute, AttributeModifier> getEquippedAttributeModifiers(ItemStack stack) {
        HashMultimap attributes = HashMultimap.create();
        attributes.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(TectonicGirdleItem.getBaubleUUID(stack), "Knockback Belt", 1.0, AttributeModifier.Operation.ADDITION));
        return attributes;
    }

    public static boolean negateExplosionKnockback(LivingEntity living) {
        return !EquipmentHandler.findOrEmpty(BotaniaItems.knockbackBelt, living).m_41619_();
    }

    public static class Renderer
    implements AccessoryRenderer {
        private static HumanoidModel<LivingEntity> model = null;

        @Override
        public void doRender(HumanoidModel<?> bipedModel, ItemStack stack, LivingEntity living, PoseStack ms, MultiBufferSource buffers, int light, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            AccessoryRenderHelper.rotateIfSneaking(ms, living);
            float s = 1.15f;
            ms.m_85841_(s, s, s);
            if (model == null) {
                model = new HumanoidModel(Minecraft.m_91087_().m_167973_().m_171103_(ModelLayers.f_171162_));
            }
            VertexConsumer buffer = buffers.m_6299_(model.m_103119_(texture));
            Renderer.model.f_102810_.m_104301_(ms, buffer, light, OverlayTexture.f_118083_);
        }
    }
}

