/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.flower.generating;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Shulker;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import vazkii.botania.api.block_entity.GeneratingFlowerBlockEntity;
import vazkii.botania.api.block_entity.RadiusDescriptor;
import vazkii.botania.common.block.BotaniaFlowerBlocks;
import vazkii.botania.common.handler.BotaniaSounds;

public class ShulkMeNotBlockEntity
extends GeneratingFlowerBlockEntity {
    private static final int RADIUS = 8;
    private static final int MANA_PER_SHULKER = 75000;

    public ShulkMeNotBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaFlowerBlocks.SHULK_ME_NOT, pos, state);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        Level world = this.m_58904_();
        if (world.f_46443_) {
            return;
        }
        int generate = this.getMaxMana();
        if (this.getMaxMana() - this.getMana() < generate) {
            return;
        }
        BlockPos pos = this.getEffectivePos();
        Vec3 posD = new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        List shulkers = world.m_6443_(Shulker.class, new AABB(pos).m_82400_(8.0), EntitySelector.f_20402_);
        for (Shulker shulker : shulkers) {
            LivingEntity target;
            if (this.getMaxMana() - this.getMana() < generate) break;
            if (!shulker.m_6084_() || !(shulker.m_20238_(posD) < 64.0) || !((target = shulker.m_5448_()) instanceof Enemy) || !target.m_6084_() || !(target.m_20238_(posD) < 64.0) || target.m_21124_(MobEffects.f_19620_) == null) continue;
            target.m_146870_();
            shulker.m_146870_();
            world.m_5594_(null, pos, BotaniaSounds.shulkMeNot, SoundSource.BLOCKS, 10.0f, 1.0f);
            world.m_6269_(null, (Entity)target, BotaniaSounds.shulkMeNot, SoundSource.BLOCKS, 10.0f, 1.0f);
            world.m_6269_(null, (Entity)shulker, BotaniaSounds.shulkMeNot, SoundSource.BLOCKS, 10.0f, 1.0f);
            if (world instanceof ServerLevel) {
                ServerLevel ws = (ServerLevel)world;
                ws.m_8767_((ParticleOptions)ParticleTypes.f_123813_, target.m_20185_(), target.m_20186_() + (double)(target.m_20206_() / 2.0f), target.m_20189_(), 100, (double)target.m_20205_(), (double)target.m_20206_(), (double)target.m_20205_(), 0.05);
                ws.m_8767_((ParticleOptions)ParticleTypes.f_123813_, shulker.m_20185_(), shulker.m_20186_() + (double)(shulker.m_20206_() / 2.0f), shulker.m_20189_(), 100, (double)shulker.m_20205_(), (double)shulker.m_20206_(), (double)shulker.m_20205_(), 0.05);
                ws.m_8767_((ParticleOptions)ParticleTypes.f_123760_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, 40, 0.0, 0.0, 0.0, 0.6);
            }
            world.m_142346_(null, GameEvent.f_223702_, pos);
            this.addMana(generate);
            this.sync();
        }
    }

    @Override
    public int getColor() {
        return 8476056;
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Circle(this.getEffectivePos(), 8.0);
    }

    @Override
    public int getMaxMana() {
        return 75000;
    }
}

