/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.brew.BotaniaBrews;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.brew.IncenseStickItem;

public class IncensePlateBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements WorldlyContainer {
    private static final String TAG_TIME_LEFT = "timeLeft";
    private static final String TAG_BURNING = "burning";
    private static final int RANGE = 32;
    private int timeLeft = 0;
    public boolean burning = false;
    public int comparatorOutput = 0;

    public IncensePlateBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.INCENSE_PLATE, pos, state);
    }

    public static void commonTick(Level level, BlockPos worldPosition, BlockState state, IncensePlateBlockEntity self) {
        ItemStack stack = self.getItemHandler().m_8020_(0);
        if (!stack.m_41619_() && self.burning) {
            if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue() && self.timeLeft > 1) {
                self.timeLeft = 1;
                self.spawnSmokeParticles();
            }
            Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
            MobEffectInstance effect = brew.getPotionEffects(stack).get(0);
            if (self.timeLeft > 0) {
                --self.timeLeft;
                if (!level.f_46443_) {
                    List players = level.m_45976_(Player.class, new AABB((double)worldPosition.m_123341_() + 0.5 - 32.0, (double)worldPosition.m_123342_() + 0.5 - 32.0, (double)worldPosition.m_123343_() + 0.5 - 32.0, (double)worldPosition.m_123341_() + 0.5 + 32.0, (double)worldPosition.m_123342_() + 0.5 + 32.0, (double)worldPosition.m_123343_() + 0.5 + 32.0));
                    for (Player player : players) {
                        boolean nightVision;
                        MobEffectInstance currentEffect = player.m_21124_(effect.m_19544_());
                        boolean bl = nightVision = effect.m_19544_() == MobEffects.f_19611_;
                        if (currentEffect != null && currentEffect.m_19557_() >= (nightVision ? 205 : 3)) continue;
                        MobEffectInstance applyEffect = new MobEffectInstance(effect.m_19544_(), nightVision ? 285 : 80, effect.m_19564_(), true, true);
                        player.m_7292_(applyEffect);
                    }
                    if (level.f_46441_.m_188503_(20) == 0) {
                        level.m_5594_(null, worldPosition, SoundEvents.f_11936_, SoundSource.BLOCKS, 0.1f, 1.0f);
                    }
                } else {
                    double x = (double)worldPosition.m_123341_() + 0.5;
                    double y = (double)worldPosition.m_123342_() + 0.5;
                    double z = (double)worldPosition.m_123343_() + 0.5;
                    int color = brew.getColor(stack);
                    float r = (float)(color >> 16 & 0xFF) / 255.0f;
                    float g = (float)(color >> 8 & 0xFF) / 255.0f;
                    float b = (float)(color & 0xFF) / 255.0f;
                    WispParticleData data1 = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, r, g, b);
                    level.m_7106_((ParticleOptions)data1, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.005f), (double)(0.005f - (float)Math.random() * 0.01f));
                    WispParticleData data = WispParticleData.wisp(0.05f + (float)Math.random() * 0.02f, 0.2f, 0.2f, 0.2f);
                    level.m_7106_((ParticleOptions)data, x - (Math.random() - 0.5) * 0.2, y - (Math.random() - 0.5) * 0.2, z - (Math.random() - 0.5) * 0.2, (double)(0.005f - (float)Math.random() * 0.01f), (double)(0.01f + (float)Math.random() * 0.001f), (double)(0.005f - (float)Math.random() * 0.01f));
                }
            } else {
                self.getItemHandler().m_6836_(0, ItemStack.f_41583_);
                self.burning = false;
                level.m_142346_(null, GameEvent.f_223703_, worldPosition);
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(self);
            }
        } else {
            self.timeLeft = 0;
        }
        int newComparator = 0;
        if (!stack.m_41619_()) {
            newComparator = 1;
        }
        if (self.burning) {
            newComparator = 2;
        }
        if (self.comparatorOutput != newComparator) {
            self.comparatorOutput = newComparator;
            level.m_46717_(worldPosition, state.m_60734_());
            self.m_6596_();
        }
    }

    public void spawnSmokeParticles() {
        RandomSource random = this.f_58857_.m_213780_();
        for (int i = 0; i < 4; ++i) {
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, (double)this.f_58858_.m_123341_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5 + random.m_188500_() / 2.0 * (double)(random.m_188499_() ? 1 : -1), 0.0, 0.05, 0.0);
        }
        this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_11914_, SoundSource.BLOCKS, 0.1f, 1.0f);
    }

    public void ignite() {
        ItemStack stack = this.getItemHandler().m_8020_(0);
        if (stack.m_41619_() || this.burning) {
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            this.spawnSmokeParticles();
            return;
        }
        this.burning = true;
        Brew brew = ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack);
        this.timeLeft = brew.getPotionEffects(stack).get(0).m_19557_() * 60;
        this.f_58857_.m_5594_(null, this.m_58899_(), BotaniaSounds.incensePlateIgnite, SoundSource.BLOCKS, 0.5f, 1.75f);
        this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128405_(TAG_TIME_LEFT, this.timeLeft);
        tag.m_128379_(TAG_BURNING, this.burning);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.timeLeft = tag.m_128451_(TAG_TIME_LEFT);
        this.burning = tag.m_128471_(TAG_BURNING);
    }

    public boolean acceptsItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_150930_(BotaniaItems.incenseStick) && ((IncenseStickItem)BotaniaItems.incenseStick).getBrew(stack) != BotaniaBrews.fallbackBrew;
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(1){

            public boolean m_7013_(int index, ItemStack stack) {
                return IncensePlateBlockEntity.this.acceptsItem(stack);
            }
        };
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public boolean m_7157_(int index, @NotNull ItemStack stack, @Nullable Direction direction) {
        return false;
    }
}

