/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.base.Predicates;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.corporea.CorporeaNode;
import vazkii.botania.api.corporea.CorporeaSpark;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.entity.ManaSparkEntity;
import vazkii.botania.common.entity.SparkBaseEntity;
import vazkii.botania.common.helper.ColorHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.impl.corporea.DummyCorporeaNode;
import vazkii.botania.common.integration.corporea.CorporeaNodeDetectors;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.lib.BotaniaTags;

public class CorporeaSparkEntity
extends SparkBaseEntity
implements CorporeaSpark {
    private static final int SCAN_RANGE = 8;
    private static final String TAG_MASTER = "master";
    private static final String TAG_CREATIVE = "creative";
    private static final EntityDataAccessor<Boolean> MASTER = SynchedEntityData.m_135353_(CorporeaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CREATIVE = SynchedEntityData.m_135353_(CorporeaSparkEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private CorporeaSpark master;
    private Set<CorporeaSpark> connections = new LinkedHashSet<CorporeaSpark>();
    private List<CorporeaSpark> relatives = new ArrayList<CorporeaSpark>();
    private boolean firstTick = true;

    public CorporeaSparkEntity(EntityType<CorporeaSparkEntity> type, Level world) {
        super(type, world);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MASTER, (Object)false);
        this.f_19804_.m_135372_(CREATIVE, (Object)false);
    }

    @NotNull
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getSparkItem());
    }

    public void m_8119_() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        CorporeaNode node = this.getSparkNode();
        if (node instanceof DummyCorporeaNode && !this.m_9236_().m_8055_(this.getAttachPos()).m_204336_(BotaniaTags.Blocks.CORPOREA_SPARK_OVERRIDE)) {
            this.dropAndKill();
            return;
        }
        if (this.isMaster()) {
            this.master = this;
        }
        if (this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
            this.firstTick = false;
        }
        if (!(this.master == null || this.master.entity().m_6084_() && this.master.getNetwork() == this.getNetwork())) {
            this.master = null;
        }
    }

    private void dropAndKill() {
        this.m_5552_(new ItemStack((ItemLike)this.getSparkItem()), 0.0f);
        this.m_146870_();
    }

    protected Item getSparkItem() {
        return this.isCreative() ? BotaniaItems.corporeaSparkCreative : (this.isMaster() ? BotaniaItems.corporeaSparkMaster : BotaniaItems.corporeaSpark);
    }

    public void m_142687_(Entity.RemovalReason reason) {
        super.m_142687_(reason);
        this.connections.remove(this);
        this.restartNetwork();
    }

    @Override
    public void introduceNearbyTo(Set<CorporeaSpark> network, CorporeaSpark master) {
        this.relatives.clear();
        for (CorporeaSpark spark : this.getNearbySparks()) {
            if (spark == null || network.contains(spark) || spark.getNetwork() != this.getNetwork() || spark.isMaster() || !spark.entity().m_6084_()) continue;
            network.add(spark);
            this.relatives.add(spark);
            spark.introduceNearbyTo(network, master);
        }
        this.master = master;
        this.connections = network;
    }

    private List<CorporeaSpark> getNearbySparks() {
        return this.m_9236_().m_6443_(Entity.class, new AABB(this.m_20185_() - 8.0, this.m_20186_() - 8.0, this.m_20189_() - 8.0, this.m_20185_() + 8.0, this.m_20186_() + 8.0, this.m_20189_() + 8.0), (Predicate)Predicates.instanceOf(CorporeaSpark.class));
    }

    private void restartNetwork() {
        this.connections = new LinkedHashSet<CorporeaSpark>();
        this.relatives = new ArrayList<CorporeaSpark>();
        if (this.master != null) {
            CorporeaSpark oldMaster = this.master;
            this.master = null;
            oldMaster.introduceNearbyTo(new LinkedHashSet<CorporeaSpark>(), oldMaster);
        }
    }

    private void findNetwork() {
        for (CorporeaSpark spark : this.getNearbySparks()) {
            CorporeaSpark master;
            if (spark.getNetwork() != this.getNetwork() || !spark.entity().m_6084_() || (master = spark.getMaster()) == null) continue;
            this.master = master;
            this.restartNetwork();
            break;
        }
    }

    private static void displayRelatives(Player player, List<CorporeaSpark> checked, CorporeaSpark spark) {
        if (spark == null) {
            return;
        }
        List<CorporeaSpark> sparks = spark.getRelatives();
        if (sparks.isEmpty()) {
            ManaSparkEntity.particleBeam(player, spark.entity(), spark.getMaster().entity());
        } else {
            for (CorporeaSpark endSpark : sparks) {
                if (checked.contains(endSpark)) continue;
                ManaSparkEntity.particleBeam(player, spark.entity(), endSpark.entity());
                checked.add(endSpark);
                CorporeaSparkEntity.displayRelatives(player, checked, endSpark);
            }
        }
    }

    @Override
    public CorporeaNode getSparkNode() {
        return CorporeaNodeDetectors.findNode(this.m_9236_(), this);
    }

    @Override
    public Set<CorporeaSpark> getConnections() {
        return this.connections;
    }

    @Override
    public List<CorporeaSpark> getRelatives() {
        return this.relatives;
    }

    @Override
    public void onItemExtracted(ItemStack stack) {
        ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.125, 0.125, 0.125, 0.05);
    }

    @Override
    public void onItemsRequested(List<ItemStack> stacks) {
        ArrayList<Item> shownItems = new ArrayList<Item>();
        for (ItemStack stack : stacks) {
            if (shownItems.contains(stack.m_41720_())) continue;
            shownItems.add(stack.m_41720_());
            ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, 0.125, 0.125, 0.125, 0.05);
        }
    }

    @Override
    public CorporeaSpark getMaster() {
        return this.master;
    }

    public void setMaster(boolean master) {
        this.f_19804_.m_135381_(MASTER, (Object)master);
    }

    @Override
    public boolean isMaster() {
        return (Boolean)this.f_19804_.m_135370_(MASTER);
    }

    public void setCreative(boolean creative) {
        this.f_19804_.m_135381_(CREATIVE, (Object)creative);
    }

    @Override
    public boolean isCreative() {
        return (Boolean)this.f_19804_.m_135370_(CREATIVE);
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6084_() && !stack.m_41619_()) {
            if (stack.m_41720_() instanceof WandOfTheForestItem) {
                if (!this.m_9236_().f_46443_) {
                    if (player.m_6144_() || !PlayerHelper.isTruePlayer((Entity)player)) {
                        this.dropAndKill();
                        if (this.isMaster()) {
                            this.restartNetwork();
                        }
                    } else {
                        CorporeaSparkEntity.displayRelatives(player, new ArrayList<CorporeaSpark>(), this.master);
                    }
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            Item item = stack.m_41720_();
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                DyeColor color = dye.m_41089_();
                if (color != this.getNetwork()) {
                    if (!this.m_9236_().f_46443_) {
                        this.setNetwork(color);
                        stack.m_41774_(1);
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
            } else if (stack.m_150930_(BotaniaItems.phantomInk)) {
                if (!this.m_9236_().f_46443_) {
                    this.m_6842_(true);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public void setNetwork(DyeColor color) {
        if (color == this.getNetwork()) {
            return;
        }
        super.setNetwork(color);
        if (!this.firstTick) {
            if (this.isMaster()) {
                this.restartNetwork();
            } else {
                this.findNetwork();
            }
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag cmp) {
        super.m_7378_(cmp);
        this.setMaster(cmp.m_128471_(TAG_MASTER));
        this.setCreative(cmp.m_128471_(TAG_CREATIVE));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag cmp) {
        super.m_7380_(cmp);
        cmp.m_128379_(TAG_MASTER, this.isMaster());
        cmp.m_128379_(TAG_CREATIVE, this.isCreative());
    }

    public record WandHud(CorporeaSparkEntity entity) implements WandHUD
    {
        @Override
        public void renderHUD(GuiGraphics gui, Minecraft mc) {
            ItemStack sparkStack = new ItemStack((ItemLike)this.entity.getSparkItem());
            DyeColor networkColor = this.entity.getNetwork();
            MutableComponent networkColorName = Component.m_237115_((String)("color.minecraft." + networkColor.m_41065_())).m_130940_(ChatFormatting.ITALIC);
            int textColor = ColorHelper.getColorLegibleOnGrayBackground(networkColor);
            int width = 4 + Math.max(mc.f_91062_.m_92852_((FormattedText)networkColorName), RenderHelper.itemWithNameWidth(mc, sparkStack));
            int networkColorTextStart = mc.f_91062_.m_92852_((FormattedText)networkColorName) / 2;
            int centerX = mc.m_91268_().m_85445_() / 2;
            int centerY = mc.m_91268_().m_85446_() / 2;
            RenderHelper.renderHUDBox(gui, centerX - width / 2, centerY + 8, centerX + width / 2, centerY + 38);
            RenderHelper.renderItemWithNameCentered(gui, mc, sparkStack, centerY + 10, textColor);
            gui.m_280430_(mc.f_91062_, (Component)networkColorName, centerX - networkColorTextStart, centerY + 28, textColor);
        }
    }
}

