/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.TerraShattererItem;

public class TerraShattererTippingRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<TerraShattererTippingRecipe> SERIALIZER = new NoOpRecipeSerializer<TerraShattererTippingRecipe>(TerraShattererTippingRecipe::new);

    public TerraShattererTippingRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.EQUIPMENT);
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundTerraPick = false;
        boolean foundElementiumPick = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof TerraShattererItem && !TerraShattererItem.isTipped(stack) && !foundTerraPick) {
                foundTerraPick = true;
                continue;
            }
            if (stack.m_150930_(BotaniaItems.elementiumPick) && !foundElementiumPick) {
                foundElementiumPick = true;
                continue;
            }
            return false;
        }
        return foundTerraPick && foundElementiumPick;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        ItemStack terraPick = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof TerraShattererItem)) continue;
            terraPick = stack;
        }
        if (terraPick.m_41619_()) {
            return ItemStack.f_41583_;
        }
        ItemStack terraPickCopy = terraPick.m_41777_();
        TerraShattererItem.setTipped(terraPickCopy);
        return terraPickCopy;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 2;
    }
}

