/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.crafting.recipe;

import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.api.mana.CompositableLensItem;
import vazkii.botania.common.crafting.recipe.NoOpRecipeSerializer;
import vazkii.botania.common.lib.BotaniaTags;

public class CompositeLensRecipe
extends CustomRecipe {
    public static final NoOpRecipeSerializer<CompositeLensRecipe> SERIALIZER = new NoOpRecipeSerializer<CompositeLensRecipe>(CompositeLensRecipe::new);

    public CompositeLensRecipe(ResourceLocation id) {
        super(id, CraftingBookCategory.REDSTONE);
    }

    public boolean matches(@NotNull CraftingContainer inv, @NotNull Level world) {
        boolean foundLens = false;
        boolean foundSecondLens = false;
        boolean foundGlue = false;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_()) continue;
            if (stack.m_41720_() instanceof CompositableLensItem && !foundSecondLens) {
                if (foundLens) {
                    foundSecondLens = true;
                    continue;
                }
                foundLens = true;
                continue;
            }
            if (stack.m_204117_(BotaniaTags.Items.LENS_GLUE) && !foundGlue) {
                foundGlue = true;
                continue;
            }
            return false;
        }
        return foundSecondLens && foundGlue;
    }

    @NotNull
    public ItemStack assemble(@NotNull CraftingContainer inv, @NotNull RegistryAccess registries) {
        Item stack;
        ItemStack lens = ItemStack.f_41583_;
        ItemStack secondLens = ItemStack.f_41583_;
        for (int i = 0; i < inv.m_6643_(); ++i) {
            stack = inv.m_8020_(i);
            if (stack.m_41619_() || !(stack.m_41720_() instanceof CompositableLensItem)) continue;
            if (lens.m_41619_()) {
                lens = stack;
                continue;
            }
            secondLens = stack;
        }
        stack = lens.m_41720_();
        if (stack instanceof CompositableLensItem) {
            CompositableLensItem lensItem = (CompositableLensItem)stack;
            if (secondLens.m_41619_() || !lensItem.canCombineLenses(lens, secondLens) || !lensItem.getCompositeLens(lens).m_41619_() || !lensItem.getCompositeLens(secondLens).m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack lensCopy = lens.m_255036_(1);
            ItemStack secondCopy = secondLens.m_255036_(1);
            lensItem.setCompositeLens(lensCopy, secondCopy);
            return lensCopy;
        }
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return width * height >= 3;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }
}

