/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HornHarvestable;
import vazkii.botania.common.block.flower.functional.BergamuteBlockEntity;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.lib.BotaniaTags;
import vazkii.botania.xplat.XplatAbstractions;

public class HornItem
extends Item {
    public HornItem(Item.Properties props) {
        super(props);
    }

    @NotNull
    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, @NotNull InteractionHand hand) {
        return ItemUtils.m_150959_((Level)world, (Player)player, (InteractionHand)hand);
    }

    public void m_5929_(Level world, @NotNull LivingEntity living, @NotNull ItemStack stack, int time) {
        if (!world.f_46443_) {
            if (time != this.m_8105_(stack) && time % 5 == 0) {
                living.m_146850_(GameEvent.f_223696_);
                HornItem.breakGrass(world, stack, living.m_20183_(), living);
            }
            world.m_6263_(null, living.m_20185_(), living.m_20186_(), living.m_20189_(), BotaniaSounds.hornDoot, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    private static boolean canHarvest(Level level, ItemStack stack, BlockPos pos, @Nullable LivingEntity user, HornHarvestable.EnumHornType type) {
        BlockEntity be;
        BlockState state = level.m_8055_(pos);
        HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(level, pos, state, be = level.m_7702_(pos));
        if (harvestable != null) {
            return harvestable.canHornHarvest(level, pos, stack, type, user);
        }
        return switch (type) {
            default -> {
                if (state.m_60734_() instanceof BushBlock && !state.m_204336_(BotaniaTags.Blocks.SPECIAL_FLOWERS) || state.m_204336_(BotaniaTags.Blocks.HORN_OF_THE_WILD_BREAKABLE)) {
                    yield true;
                }
                yield false;
            }
            case HornHarvestable.EnumHornType.CANOPY -> {
                if (!(!state.m_204336_(BotaniaTags.Blocks.HORN_OF_THE_CANOPY_BREAKABLE) || state.m_60734_() instanceof LeavesBlock && ((Boolean)state.m_61143_((Property)LeavesBlock.f_54419_)).booleanValue())) {
                    yield true;
                }
                yield false;
            }
            case HornHarvestable.EnumHornType.COVERING -> state.m_204336_(BotaniaTags.Blocks.HORN_OF_THE_COVERING_BREAKABLE);
        };
    }

    public static void breakGrass(Level world, ItemStack stack, BlockPos srcPos, @Nullable LivingEntity user) {
        HornHarvestable.EnumHornType type = null;
        if (stack.m_150930_(BotaniaItems.grassHorn)) {
            type = HornHarvestable.EnumHornType.WILD;
        } else if (stack.m_150930_(BotaniaItems.leavesHorn)) {
            type = HornHarvestable.EnumHornType.CANOPY;
        } else if (stack.m_150930_(BotaniaItems.snowHorn)) {
            type = HornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)srcPos.m_7918_(-range, -rangeY, -range), (BlockPos)srcPos.m_7918_(range, rangeY, range))) {
            if (BergamuteBlockEntity.isBergamuteNearby(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) || !HornItem.canHarvest(world, stack, pos, user, type)) continue;
            coords.add(pos.m_7949_());
        }
        Collections.shuffle(coords);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            BlockEntity be;
            BlockState state;
            BlockPos currCoords = (BlockPos)coords.get(i);
            HornHarvestable harvestable = XplatAbstractions.INSTANCE.findHornHarvestable(world, currCoords, state = world.m_8055_(currCoords), be = world.m_7702_(currCoords));
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type, user)) {
                harvestable.harvestByHorn(world, currCoords, stack, type, user);
                continue;
            }
            world.m_46961_(currCoords, true);
        }
    }
}

