/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.util;

import com.google.gson.JsonArray;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.data.util.ModelOverride;

public class OverrideHolder {
    final List<ModelOverride> modelOverrides = new ArrayList<ModelOverride>();

    @SafeVarargs
    public final OverrideHolder add(ResourceLocation model, Pair<ResourceLocation, Double> ... preds) {
        LinkedHashMap<ResourceLocation, Double> predMap = new LinkedHashMap<ResourceLocation, Double>();
        for (Pair<ResourceLocation, Double> pred : preds) {
            predMap.put((ResourceLocation)pred.getFirst(), (Double)pred.getSecond());
        }
        this.modelOverrides.add(new ModelOverride(predMap, model));
        return this;
    }

    @Nullable
    public JsonArray toJson() {
        if (this.modelOverrides.isEmpty()) {
            return null;
        }
        JsonArray ret = new JsonArray();
        this.modelOverrides.stream().map(ModelOverride::toJson).forEach(arg_0 -> ((JsonArray)ret).add(arg_0));
        return ret;
    }
}

