/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.entity.BotaniaEntities;

public class PixieEntity
extends FlyingMob {
    private static final EntityDataAccessor<Integer> PIXIE_TYPE = SynchedEntityData.m_135353_(PixieEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity summoner = null;
    private float damage = 0.0f;
    private MobEffectInstance effect = null;

    public PixieEntity(EntityType<PixieEntity> type, Level world) {
        super(type, world);
    }

    public PixieEntity(Level world) {
        this(BotaniaEntities.PIXIE, world);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(PIXIE_TYPE, (Object)0);
    }

    public void setPixieType(int type) {
        this.f_19804_.m_135381_(PIXIE_TYPE, (Object)type);
    }

    public int getPixieType() {
        return (Integer)this.f_19804_.m_135370_(PIXIE_TYPE);
    }

    public void setProps(LivingEntity target, LivingEntity summoner, int type, float damage) {
        this.m_6710_(target);
        this.summoner = summoner;
        this.damage = damage;
        this.setPixieType(type);
    }

    public void setApplyPotionEffect(MobEffectInstance effect) {
        this.effect = effect;
    }

    protected void m_8024_() {
        LivingEntity target = this.m_5448_();
        if (target != null) {
            double d0 = target.m_20185_() + (double)(target.m_20205_() / 2.0f) - this.m_20185_();
            double d1 = target.m_20186_() + (double)(target.m_20206_() / 2.0f) - this.m_20186_();
            double d2 = target.m_20189_() + (double)(target.m_20205_() / 2.0f) - this.m_20189_();
            double d3 = d0 * d0 + d1 * d1 + d2 * d2;
            float mod = 0.45f;
            if (this.getPixieType() == 1) {
                mod = 0.1f;
            }
            this.m_20334_(d0 / d3 * (double)mod, d1 / d3 * (double)mod, d2 / d3 * (double)mod);
            if (Math.sqrt(d3) < 1.0) {
                if (this.summoner != null) {
                    LivingEntity livingEntity = this.summoner;
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        target.m_6469_(this.m_269291_().m_269075_(player), this.damage);
                    } else {
                        target.m_6469_(this.m_269291_().m_269333_(this.summoner), this.damage);
                    }
                } else {
                    target.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), this.damage);
                }
                if (this.effect != null && !(target instanceof Player)) {
                    target.m_7292_(this.effect);
                }
                this.m_146870_();
            }
        }
        this.f_20883_ = -((float)Math.atan2(this.m_20184_().m_7096_(), this.m_20184_().m_7094_())) * 180.0f / (float)Math.PI;
        this.m_146922_(this.f_20883_);
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        if (this.getPixieType() == 0 && source.m_7639_() == this.summoner) {
            return true;
        }
        if (this.getPixieType() == 1 && !(source.m_7639_() instanceof Player)) {
            return true;
        }
        return super.m_6673_(source);
    }

    public void m_6075_() {
        boolean dark;
        super.m_6075_();
        if (!(this.m_9236_().f_46443_ || this.m_5448_() != null && this.f_19797_ <= 200)) {
            this.m_146870_();
        }
        boolean bl = dark = this.getPixieType() == 1;
        if (this.m_9236_().f_46443_) {
            for (int i = 0; i < 4; ++i) {
                float r = dark ? 0.1f : 1.0f;
                float g = dark ? 0.025f : 0.25f;
                float b = dark ? 0.09f : 0.9f;
                SparkleParticleData data = SparkleParticleData.sparkle(0.1f + (float)Math.random() * 0.25f, r, g, b, 12);
                this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() + (Math.random() - 0.5) * 0.25, this.m_20186_() + 0.5 + (Math.random() - 0.5) * 0.25, this.m_20189_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (this.m_9236_() != null && this.m_9236_().f_46443_ && this.getPixieType() == 0) {
            for (int i = 0; i < 12; ++i) {
                SparkleParticleData data = SparkleParticleData.sparkle(1.0f + (float)Math.random() * 0.25f, 1.0f, 0.25f, 0.9f, 5);
                this.m_9236_().m_7106_((ParticleOptions)data, this.m_20185_() + (Math.random() - 0.5) * 0.25, this.m_20186_() + 0.5 + (Math.random() - 0.5) * 0.25, this.m_20189_() + (Math.random() - 0.5) * 0.25, 0.0, 0.0, 0.0);
            }
        }
        super.m_142687_(reason);
    }

    public boolean m_6087_() {
        return this.m_6084_();
    }

    public boolean m_6573_(Player player) {
        return false;
    }
}

