/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.recipe.RunicAltarRecipe;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.client.gui.HUDHandler;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.SimpleInventoryBlockEntity;
import vazkii.botania.common.crafting.BotaniaRecipeTypes;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.EntityHelper;
import vazkii.botania.common.helper.InventoryHelper;
import vazkii.botania.common.helper.PlayerHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.WandOfTheForestItem;
import vazkii.botania.common.item.material.RuneItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.XplatAbstractions;

public class RunicAltarBlockEntity
extends SimpleInventoryBlockEntity
implements ManaReceiver,
Wandable {
    private static final String TAG_MANA = "mana";
    private static final String TAG_MANA_TO_GET = "manaToGet";
    private static final int SET_KEEP_TICKS_EVENT = 0;
    private static final int SET_COOLDOWN_EVENT = 1;
    private static final int CRAFT_EFFECT_EVENT = 2;
    private RunicAltarRecipe currentRecipe;
    public int manaToGet = 0;
    private int mana = 0;
    private int cooldown = 0;
    public int signal = 0;
    private List<ItemStack> lastRecipe = null;
    private int recipeKeepTicks = 0;

    public RunicAltarBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.RUNE_ALTAR, pos, state);
    }

    public boolean addItem(@Nullable Player player, ItemStack stack, @Nullable InteractionHand hand) {
        if (this.cooldown > 0 || stack.m_41720_() instanceof WandOfTheForestItem || stack.m_150930_((Item)BotaniaItems.lexicon)) {
            return false;
        }
        if (stack.m_150930_(BotaniaBlocks.livingrock.m_5456_())) {
            if (!this.f_58857_.f_46443_) {
                ItemStack toSpawn = player != null && player.m_150110_().f_35937_ ? stack.m_41777_().m_41620_(1) : stack.m_41620_(1);
                ItemEntity item = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)(this.m_58899_().m_123342_() + 1), (double)this.m_58899_().m_123343_() + 0.5, toSpawn);
                item.m_32010_(40);
                item.m_20256_(Vec3.f_82478_);
                this.f_58857_.m_7967_((Entity)item);
            }
            return true;
        }
        if (this.manaToGet != 0) {
            return false;
        }
        boolean did = false;
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (!this.getItemHandler().m_8020_(i).m_41619_()) continue;
            did = true;
            ItemStack stackToAdd = stack.m_255036_(1);
            this.getItemHandler().m_6836_(i, stackToAdd);
            if (player != null && player.m_150110_().f_35937_) break;
            stack.m_41774_(1);
            break;
        }
        if (did) {
            this.f_58857_.m_142346_(null, GameEvent.f_157792_, this.m_58899_());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public boolean m_7531_(int id, int param) {
        switch (id) {
            case 0: {
                this.recipeKeepTicks = param;
                return true;
            }
            case 1: {
                this.cooldown = param;
                return true;
            }
            case 2: {
                if (this.f_58857_.f_46443_) {
                    for (int i = 0; i < 25; ++i) {
                        float red = (float)Math.random();
                        float green = (float)Math.random();
                        float blue = (float)Math.random();
                        SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), red, green, blue, 10);
                        this.f_58857_.m_7106_((ParticleOptions)data, (double)this.f_58858_.m_123341_() + 0.5 + Math.random() * 0.4 - 0.2, (double)(this.f_58858_.m_123342_() + 1), (double)this.f_58858_.m_123343_() + 0.5 + Math.random() * 0.4 - 0.2, 0.0, 0.0, 0.0);
                    }
                    this.f_58857_.m_7785_((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), BotaniaSounds.runeAltarCraft, SoundSource.BLOCKS, 1.0f, 1.0f, false);
                }
                return true;
            }
        }
        return super.m_7531_(id, param);
    }

    private void tickCooldown() {
        if (this.cooldown > 0) {
            --this.cooldown;
        }
        if (this.recipeKeepTicks > 0) {
            --this.recipeKeepTicks;
        } else {
            this.lastRecipe = null;
        }
    }

    public static void serverTick(Level level, BlockPos worldPosition, BlockState state, RunicAltarBlockEntity self) {
        if (self.manaToGet == 0) {
            List items = level.m_45976_(ItemEntity.class, new AABB(worldPosition, worldPosition.m_7918_(1, 1, 1)));
            for (ItemEntity item : items) {
                ItemStack stack;
                if (!item.m_6084_() || item.m_32055_().m_41619_() || item.m_32055_().m_150930_(BotaniaBlocks.livingrock.m_5456_()) || XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)item).runicAltarSpawned || !self.addItem(null, stack = item.m_32055_(), null)) continue;
                EntityHelper.syncItem(item);
            }
        }
        int newSignal = 0;
        if (self.manaToGet > 0) {
            ++newSignal;
            if (self.mana >= self.manaToGet) {
                ++newSignal;
            }
        }
        if (newSignal != self.signal) {
            self.signal = newSignal;
            level.m_46717_(worldPosition, state.m_60734_());
        }
        self.updateRecipe();
        self.tickCooldown();
    }

    public static void clientTick(Level level, BlockPos worldPosition, BlockState state, RunicAltarBlockEntity self) {
        if (self.manaToGet > 0 && self.mana >= self.manaToGet && level.f_46441_.m_188503_(20) == 0) {
            Vec3 vec = Vec3.m_82512_((Vec3i)self.m_58899_());
            Vec3 endVec = vec.m_82520_(0.0, 2.5, 0.0);
            Proxy.INSTANCE.lightningFX(level, vec, endVec, 2.0f, 38027, 58583);
        }
        if (self.cooldown > 0) {
            WispParticleData data = WispParticleData.wisp(0.2f, 0.2f, 0.2f, 0.2f, 1.0f);
            level.m_7106_((ParticleOptions)data, (double)worldPosition.m_123341_() + Math.random(), (double)worldPosition.m_123342_() + 0.8, (double)worldPosition.m_123343_() + Math.random(), 0.0, (double)0.025f, 0.0);
        }
        self.tickCooldown();
    }

    private void updateRecipe() {
        int manaToGet = this.manaToGet;
        this.manaToGet = this.currentRecipe != null ? this.currentRecipe.getManaUsage() : this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.f_58857_).map(RunicAltarRecipe::getManaUsage).orElse(0).intValue();
        if (manaToGet != this.manaToGet) {
            this.f_58857_.m_5594_(null, this.f_58858_, BotaniaSounds.runeAltarStart, SoundSource.BLOCKS, 1.0f, 1.0f);
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    private void saveLastRecipe() {
        ItemStack stack;
        this.lastRecipe = new ArrayList<ItemStack>();
        for (int i = 0; i < this.inventorySize() && !(stack = this.getItemHandler().m_8020_(i)).m_41619_(); ++i) {
            this.lastRecipe.add(stack.m_41777_());
        }
        this.recipeKeepTicks = 400;
        this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 0, 400);
    }

    public InteractionResult trySetLastRecipe(Player player) {
        if (player.m_9236_().m_5776_()) {
            return InteractionResult.m_19078_((boolean)true);
        }
        boolean success = InventoryHelper.tryToSetLastRecipe(player, this.getItemHandler(), this.lastRecipe, null);
        if (success) {
            this.f_58857_.m_142346_(null, GameEvent.f_157792_, this.m_58899_());
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return success ? InteractionResult.m_19078_((boolean)false) : InteractionResult.PASS;
    }

    @Override
    public boolean onUsedByWand(@Nullable Player player, ItemStack wand, Direction side) {
        if (this.f_58857_.f_46443_) {
            return true;
        }
        RunicAltarRecipe recipe = null;
        if (this.currentRecipe != null) {
            recipe = this.currentRecipe;
        } else {
            Optional maybeRecipe = this.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.RUNE_TYPE, this.getItemHandler(), this.f_58857_);
            if (maybeRecipe.isPresent()) {
                recipe = (RunicAltarRecipe)maybeRecipe.get();
            }
        }
        if (recipe != null && this.manaToGet > 0 && this.mana >= this.manaToGet) {
            List items = this.f_58857_.m_45976_(ItemEntity.class, new AABB(this.f_58858_, this.f_58858_.m_7918_(1, 1, 1)));
            ItemEntity livingrock = null;
            for (ItemEntity item : items) {
                if (!item.m_6084_() || item.m_32055_().m_41619_() || !item.m_32055_().m_150930_(BotaniaBlocks.livingrock.m_5456_())) continue;
                livingrock = item;
                break;
            }
            if (livingrock != null) {
                int mana = recipe.getManaUsage();
                this.receiveMana(-mana);
                ItemStack output = recipe.m_5874_(this.getItemHandler(), this.m_58904_().m_9598_());
                ItemEntity outputItem = new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 1.5, (double)this.f_58858_.m_123343_() + 0.5, output);
                XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputItem).runicAltarSpawned = true;
                if (player != null) {
                    player.m_280300_((Recipe)recipe, List.of(output));
                    output.m_41678_(this.f_58857_, player, output.m_41613_());
                }
                this.f_58857_.m_7967_((Entity)outputItem);
                this.currentRecipe = null;
                this.f_58857_.m_142346_(null, GameEvent.f_223702_, this.m_58899_());
                this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 1, 60);
                this.f_58857_.m_7696_(this.m_58899_(), BotaniaBlocks.runeAltar, 2, 0);
                this.saveLastRecipe();
                for (int i = 0; i < this.inventorySize(); ++i) {
                    ItemStack stack = this.getItemHandler().m_8020_(i);
                    if (stack.m_41619_()) continue;
                    if (stack.m_41720_() instanceof RuneItem && (player == null || !player.m_150110_().f_35937_)) {
                        ItemEntity outputRune = new ItemEntity(this.f_58857_, (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 1.5, (double)this.m_58899_().m_123343_() + 0.5, stack.m_41777_());
                        XplatAbstractions.INSTANCE.itemFlagsComponent((ItemEntity)outputRune).runicAltarSpawned = true;
                        this.f_58857_.m_7967_((Entity)outputRune);
                    }
                    this.getItemHandler().m_6836_(i, ItemStack.f_41583_);
                }
                EntityHelper.shrinkItem(livingrock);
            }
        }
        return true;
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.inventorySize(); ++i) {
            if (this.getItemHandler().m_8020_(i).m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void writePacketNBT(CompoundTag tag) {
        super.writePacketNBT(tag);
        tag.m_128405_(TAG_MANA, this.mana);
        tag.m_128405_(TAG_MANA_TO_GET, this.manaToGet);
    }

    @Override
    public void readPacketNBT(CompoundTag tag) {
        super.readPacketNBT(tag);
        this.mana = tag.m_128451_(TAG_MANA);
        this.manaToGet = tag.m_128451_(TAG_MANA_TO_GET);
    }

    @Override
    protected SimpleContainer createItemHandler() {
        return new SimpleContainer(16){

            public int m_6893_() {
                return 1;
            }
        };
    }

    @Override
    public Level getManaReceiverLevel() {
        return this.m_58904_();
    }

    @Override
    public BlockPos getManaReceiverPos() {
        return this.m_58899_();
    }

    @Override
    public int getCurrentMana() {
        return this.mana;
    }

    @Override
    public boolean isFull() {
        return this.mana >= this.manaToGet;
    }

    @Override
    public void receiveMana(int mana) {
        this.mana = Math.min(this.mana + mana, this.manaToGet);
    }

    @Override
    public boolean canReceiveManaFromBursts() {
        return !this.isFull();
    }

    public boolean canAddLastRecipe() {
        return this.isEmpty();
    }

    public int getTargetMana() {
        return this.manaToGet;
    }

    public static class Hud {
        public static void render(RunicAltarBlockEntity altar, GuiGraphics gui, Minecraft mc) {
            PoseStack ms = gui.m_280168_();
            int xc = mc.m_91268_().m_85445_() / 2;
            int yc = mc.m_91268_().m_85446_() / 2;
            float angle = -90.0f;
            int radius = 24;
            int amt = 0;
            for (int i = 0; i < altar.inventorySize() && !altar.getItemHandler().m_8020_(i).m_41619_(); ++i) {
                ++amt;
            }
            if (amt > 0) {
                float anglePer = 360.0f / (float)amt;
                altar.f_58857_.m_7465_().m_44015_(BotaniaRecipeTypes.RUNE_TYPE, altar.getItemHandler(), altar.f_58857_).ifPresent(recipe -> {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    float progress = (float)altar.mana / (float)altar.manaToGet;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderHelper.drawTexturedModalRect(gui, HUDHandler.manaBar, xc + radius + 9, yc - 8, progress == 1.0f ? 0 : 22, 8, 22, 15);
                    if (progress == 1.0f) {
                        gui.m_280203_(new ItemStack((ItemLike)BotaniaBlocks.livingrock), xc + radius + 16, yc + 8);
                        ms.m_85836_();
                        ms.m_252880_(0.0f, 0.0f, 100.0f);
                        ItemStack playerWand = PlayerHelper.getFirstHeldItemClass((LivingEntity)mc.f_91074_, WandOfTheForestItem.class);
                        if (playerWand.m_41619_()) {
                            playerWand = PlayerHelper.getItemClassFromInventory((Player)mc.f_91074_, WandOfTheForestItem.class);
                        }
                        ItemStack wandToRender = playerWand.m_41619_() ? new ItemStack((ItemLike)BotaniaItems.twigWand) : playerWand;
                        gui.m_280203_(wandToRender, xc + radius + 24, yc + 8);
                        ms.m_85849_();
                    }
                    RenderHelper.renderProgressPie(gui, xc + radius + 32, yc - 8, progress, recipe.m_5874_(altar.getItemHandler(), altar.m_58904_().m_9598_()));
                    if (progress == 1.0f) {
                        gui.m_280056_(mc.f_91062_, "+", xc + radius + 14, yc + 12, 0xFFFFFF, false);
                    }
                });
                for (int i = 0; i < amt; ++i) {
                    double xPos = (double)xc + Math.cos((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    double yPos = (double)yc + Math.sin((double)angle * Math.PI / 180.0) * (double)radius - 8.0;
                    ms.m_85836_();
                    ms.m_85837_(xPos, yPos, 0.0);
                    gui.m_280203_(altar.getItemHandler().m_8020_(i), 0, 0);
                    ms.m_85849_();
                    angle += anglePer;
                }
            }
            if (altar.recipeKeepTicks > 0 && altar.canAddLastRecipe()) {
                String s = I18n.m_118938_((String)"botaniamisc.altarRefill0", (Object[])new Object[0]);
                gui.m_280488_(mc.f_91062_, s, xc - mc.f_91062_.m_92895_(s) / 2, yc + 10, 0xFFFFFF);
                s = I18n.m_118938_((String)"botaniamisc.altarRefill1", (Object[])new Object[0]);
                gui.m_280488_(mc.f_91062_, s, xc - mc.f_91062_.m_92895_(s) / 2, yc + 20, 0xFFFFFF);
            }
        }
    }
}

