/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.api.mana;

import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import vazkii.botania.api.mana.ManaItem;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaBarTooltip
implements TooltipComponent {
    private final float percentageFull;
    private final int pickLevel;

    public static ManaBarTooltip fromManaItem(ItemStack stack) {
        ManaItem manaItem = XplatAbstractions.INSTANCE.findManaItem(stack);
        if (manaItem != null) {
            return new ManaBarTooltip(ManaBarTooltip.getFractionForDisplay(manaItem));
        }
        throw new IllegalArgumentException("Item does not have the capability " + ManaItem.class.getName());
    }

    public static float getFractionForDisplay(ManaItem item) {
        return (float)item.getMana() / (float)item.getMaxMana();
    }

    public ManaBarTooltip(float percentageFull) {
        this(percentageFull, -1);
    }

    public ManaBarTooltip(float percentageFull, int pickLevel) {
        this.percentageFull = percentageFull;
        this.pickLevel = pickLevel;
    }

    public float getPercentageFull() {
        return this.percentageFull;
    }

    public int getPickLevel() {
        return this.pickLevel;
    }
}

