/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.block;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SeaPickleBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import vazkii.botania.test.TestingUtil;

public class RannuncarpusTest {
    private static final String TEMPLATE = "botania:block/rannuncarpus";
    private static final String TEMPLATE_CANDLES = "botania:block/rannuncarpus_candles";
    private static final BlockPos FLOWER_POS = new BlockPos(2, 3, 2);
    private static final BlockPos FILTER_POS = FLOWER_POS.m_7495_();
    private static final BlockPos EXPECTED_PLACE_POS = new BlockPos(3, 2, 2);
    private static final BlockPos FILTERED_POS = EXPECTED_PLACE_POS.m_7495_();
    private static final BlockPos MAGENTA_CANDLE_POS = new BlockPos(3, 3, 3);
    private static final BlockPos EXPECTED_PLACE_POS1 = new BlockPos(1, 3, 3);
    private static final BlockPos EXPECTED_PLACE_POS2 = new BlockPos(3, 3, 1);
    private static final BlockPos SEA_PICKLE_POS = new BlockPos(1, 2, 1);
    private static final BlockPos FLOATING_YELLOW_CANDLE_POS = new BlockPos(1, 5, 2);
    private static final int MULTI_PLACEMENT_TIMEOUT_TICKS = 240;

    @GameTest(template="botania:block/rannuncarpus", batch="rannuncarpus1")
    public void testDestinationFilterPositive(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            helper.m_177301_();
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177552_(() -> helper.m_177208_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus", batch="rannuncarpus2")
    public void testDestinationFilterNegative(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            helper.m_177301_();
            helper.m_177245_(FILTERED_POS, Blocks.f_50387_);
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177559_(61, () -> helper.m_177341_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterPositive(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.m_31805_(new ItemStack((ItemLike)Blocks.f_50069_));
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177552_(() -> helper.m_177208_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus")
    public void testPickupFilterNegative(GameTestHelper helper) {
        helper.m_177425_().m_177562_(() -> {
            ItemFrame frame = RannuncarpusTest.getItemFrame(helper);
            frame.m_31805_(new ItemStack((ItemLike)Blocks.f_50652_));
            helper.m_177189_(Blocks.f_50069_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177559_(61, () -> helper.m_177341_(Blocks.f_50069_, EXPECTED_PLACE_POS)).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus_candles", timeoutTicks=240, batch="rannuncarpus3")
    public void testMultiplePlacements(GameTestHelper helper) {
        ItemEntity yellowCandles = helper.m_177189_(Blocks.f_152513_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        helper.m_177425_().m_177562_(() -> {
            ItemStack stack = yellowCandles.m_32055_();
            stack.m_41764_(10);
            yellowCandles.m_32045_(stack);
        }).m_177552_(() -> {
            helper.m_177208_(Blocks.f_152513_, EXPECTED_PLACE_POS1);
            helper.m_177208_(Blocks.f_152513_, EXPECTED_PLACE_POS2);
            helper.m_177255_(EXPECTED_PLACE_POS1, (Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(4));
            helper.m_177255_(EXPECTED_PLACE_POS2, (Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(4));
        }).m_177546_(11, () -> {
            helper.m_177255_(FLOATING_YELLOW_CANDLE_POS, (Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(1));
            if (yellowCandles.m_32055_().m_41613_() < 2) {
                helper.m_177286_("Too few yellow candles left over", (Entity)yellowCandles);
            }
            helper.m_177301_();
        }).m_177562_(() -> {
            helper.m_177189_(Blocks.f_152511_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
            helper.m_177189_(Blocks.f_50567_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        }).m_177552_(() -> {
            helper.m_177255_(MAGENTA_CANDLE_POS, (Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(2));
            helper.m_177255_(SEA_PICKLE_POS, (Property)SeaPickleBlock.f_56074_, (Comparable)Integer.valueOf(2));
        }).m_177562_(() -> {
            helper.m_177255_(MAGENTA_CANDLE_POS, (Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
            helper.m_177255_(SEA_PICKLE_POS, (Property)SeaPickleBlock.f_56075_, (Comparable)Boolean.valueOf(true));
        }).m_177543_();
    }

    @GameTest(template="botania:block/rannuncarpus", timeoutTicks=190)
    public void testMultiplePlacementsPrefersEmptySpots(GameTestHelper helper) {
        helper.m_177245_(FILTER_POS, Blocks.f_50387_);
        helper.m_177245_(FILTERED_POS, Blocks.f_50387_);
        for (BlockPos pos : BlockPos.m_121976_((int)0, (int)2, (int)0, (int)4, (int)2, (int)4)) {
            if ((pos.m_123341_() + pos.m_123343_()) % 2 != 1) continue;
            helper.m_177245_(pos, Blocks.f_50567_);
        }
        ItemEntity seaPickles = helper.m_177189_(Blocks.f_50567_.m_5456_(), (float)FLOWER_POS.m_123341_(), (float)(FLOWER_POS.m_123342_() + 1), (float)FLOWER_POS.m_123343_());
        ItemStack stack = seaPickles.m_32055_();
        stack.m_41764_(12);
        seaPickles.m_32045_(stack);
        helper.m_177425_().m_177546_(181, () -> {
            for (BlockPos pos : BlockPos.m_121976_((int)1, (int)2, (int)1, (int)4, (int)2, (int)4)) {
                if (pos.equals((Object)FILTER_POS)) continue;
                helper.m_177208_(Blocks.f_50567_, pos);
                helper.m_177255_(pos, (Property)SeaPickleBlock.f_56074_, (Comparable)Integer.valueOf(1));
            }
            if (!stack.m_41619_()) {
                helper.m_177286_("Not all items used", (Entity)seaPickles);
            }
        }).m_177543_();
    }

    private static ItemFrame getItemFrame(GameTestHelper helper) {
        AABB bounds = new AABB(helper.m_177449_(FLOWER_POS));
        List list = helper.m_177100_().m_45976_(ItemFrame.class, bounds);
        TestingUtil.assertThat(list.size() == 1, () -> "Number of item frames wasn't 1");
        return (ItemFrame)list.get(0);
    }
}

