/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.mixin;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.Constants;
import tschipp.carryon.client.render.ICarryOnRenderState;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.scripting.CarryOnScript;

@Mixin(value={HumanoidModel.class})
public class HumanoidModelMixin {
    @Shadow
    public ModelPart rightArm;
    @Shadow
    public ModelPart leftArm;

    @Inject(at={@At(value="RETURN")}, method={"setupAnim(Lnet/minecraft/client/renderer/entity/state/HumanoidRenderState;)V"})
    private void onSetupAnimations(HumanoidRenderState state, CallbackInfo ci) {
        if (state instanceof ICarryOnRenderState) {
            CarryOnData carry;
            ICarryOnRenderState carryOnRenderState = (ICarryOnRenderState)state;
            if (Constants.CLIENT_CONFIG.renderArms && (carry = carryOnRenderState.getCarryOnData()).isCarrying() && !state.isVisuallySwimming && !state.isFallFlying) {
                boolean sneaking = state.isCrouching;
                float x = 1.0f + (sneaking ? 0.2f : 0.0f) + (carry.isCarrying(CarryOnData.CarryType.BLOCK) ? 0.0f : 0.3f);
                float z = 0.05f;
                float width = carryOnRenderState.getRenderWidth();
                float offset = Math.min((width - 1.0f) / 1.5f, 0.2f);
                if (carry.getActiveScript().isPresent()) {
                    CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
                    boolean renderLeft = render.renderLeftArm();
                    boolean renderRight = render.renderRightArm();
                    Vec3 rotLeft = render.renderRotationLeftArm().getVec(-x, -offset, z);
                    Vec3 rotRight = render.renderRotationRightArm().getVec(-x, offset, -z);
                    if (renderLeft) {
                        this.changeRotation(this.leftArm, (float)rotLeft.x, (float)rotLeft.y, (float)rotLeft.z);
                    }
                    if (renderRight) {
                        this.changeRotation(this.rightArm, (float)rotRight.x, (float)rotRight.y, (float)rotRight.z);
                    }
                } else {
                    this.changeRotation(this.rightArm, -x, offset, -z);
                    this.changeRotation(this.leftArm, -x, -offset, z);
                }
            }
        }
    }

    @Unique
    private void changeRotation(ModelPart part, float x, float y, float z) {
        part.xRot = x;
        part.yRot = y;
        part.zRot = z;
    }
}

