/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.BlockSnapshot;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.AddServerReloadListenersEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.entity.living.MobSpawnEvent;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PickupHandler;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.scripting.ScriptReloadListener;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.events.EntityPickupEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="carryon")
public class CommonEvents {
    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.isClientSide) {
            return;
        }
        boolean success = false;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickUpBlock((ServerPlayer)player, pos, level, (pState, pPos) -> {
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(level, pPos, pState, player);
                NeoForge.EVENT_BUS.post((Event)breakEvent);
                return !breakEvent.isCanceled();
            })) {
                success = true;
            }
        } else {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                PlacementHandler.tryPlaceBlock((ServerPlayer)player, pos, event.getFace(), (pos2, state) -> {
                    BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos2);
                    BlockEvent.EntityPlaceEvent event1 = new BlockEvent.EntityPlaceEvent(snapshot, level.getBlockState(pos), (Entity)player);
                    NeoForge.EVENT_BUS.post((Event)event1);
                    return !event1.isCanceled();
                });
            } else {
                PlacementHandler.tryPlaceEntity((ServerPlayer)player, pos, event.getFace(), (pPos, toPlace) -> {
                    if (toPlace instanceof Mob) {
                        Mob mob = (Mob)toPlace;
                        mob.setPos(pPos.x, pPos.y, pPos.z);
                        MobSpawnEvent.PositionCheck checkSpawn = new MobSpawnEvent.PositionCheck(mob, (ServerLevelAccessor)level, EntitySpawnReason.EVENT, null);
                        NeoForge.EVENT_BUS.post((Event)checkSpawn);
                        return checkSpawn.getResult() != MobSpawnEvent.PositionCheck.Result.FAIL;
                    }
                    return true;
                });
            }
            success = true;
        }
        if (success) {
            event.setUseBlock(TriState.FALSE);
            event.setUseItem(TriState.FALSE);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getEntity();
        Level level = event.getLevel();
        Entity target = event.getTarget();
        if (level.isClientSide) {
            return;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickupEntity((ServerPlayer)player, target, toPickup -> {
                EntityPickupEvent pickupEvent = new EntityPickupEvent((ServerPlayer)player, (Entity)toPickup);
                NeoForge.EVENT_BUS.post((Event)pickupEvent);
                return !pickupEvent.isCanceled();
            })) {
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                event.setCanceled(true);
                return;
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            PlacementHandler.tryStackEntity((ServerPlayer)player, target);
        }
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CarryOnCommon.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onDatapackRegister(AddServerReloadListenersEvent event) {
        event.addListener(ResourceLocation.fromNamespaceAndPath((String)"carryon", (String)"scripts"), (PreparableReloadListener)new ScriptReloadListener());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            for (ServerPlayer p : event.getPlayerList().getPlayers()) {
                ScriptReloadListener.syncScriptsWithClient(p);
            }
        } else {
            ScriptReloadListener.syncScriptsWithClient(player);
        }
    }

    @SubscribeEvent
    public static void onTagsUpdate(TagsUpdatedEvent event) {
        ConfigLoader.onConfigLoaded(event.getLookupProvider());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        for (ServerPlayer player : event.getServer().getPlayerList().getPlayers()) {
            CarryOnCommon.onCarryTick(player);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.getOriginal().level().isClientSide) {
            PlacementHandler.placeCarriedOnDeath((ServerPlayer)event.getOriginal(), (ServerPlayer)event.getEntity(), event.isWasDeath());
        }
    }

    @SubscribeEvent
    public static void harvestSpeed(PlayerEvent.BreakSpeed event) {
        if (!CarryOnCommon.onTryBreakBlock(event.getEntity())) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public static void attackEntity(AttackEntityEvent event) {
        if (!CarryOnCommon.onAttackedByPlayer(event.getEntity())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBreakBlock(BlockEvent.BreakEvent event) {
        if (!CarryOnCommon.onTryBreakBlock(event.getPlayer())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void playerAttack(AttackEntityEvent event) {
        Player player = event.getEntity();
        if (player instanceof Player) {
            Player player2 = player;
            CarryOnCommon.onPlayerAttacked(player2);
        }
    }
}

