/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.events;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderHandEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import tschipp.carryon.CarryOnCommonClient;
import tschipp.carryon.client.render.CarriedObjectRender;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME, modid="carryon", value={Dist.CLIENT})
public class ClientEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderHand(RenderHandEvent event) {
        float partialTicks;
        int light;
        PoseStack matrix;
        LocalPlayer player = Minecraft.getInstance().player;
        MultiBufferSource buffer = event.getMultiBufferSource();
        if (CarriedObjectRender.drawFirstPerson((Player)player, buffer, matrix = event.getPoseStack(), light = event.getPackedLight(), partialTicks = event.getPartialTick()) && CarryRenderHelper.getPerspective() == 0) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            CarriedObjectRender.drawThirdPerson(event.getPartialTick().getGameTimeDeltaPartialTick(true), event.getPoseStack().last().pose());
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onGuiInit(ScreenEvent.Init.Pre event) {
        if (event.getScreen() != null) {
            CarryOnData carry;
            boolean inventory = event.getScreen() instanceof AbstractContainerScreen;
            Minecraft mc = Minecraft.getInstance();
            LocalPlayer player = mc.player;
            if (player != null && inventory && (carry = CarryOnDataManager.getCarryData((Player)player)).isCarrying()) {
                mc.player.closeContainer();
                mc.screen = null;
                mc.mouseHandler.grabMouse();
                event.setCanceled(true);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        CarryOnCommonClient.checkForKeybinds();
        CarryOnCommonClient.onCarryClientTick();
    }
}

