/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.scripting;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.platform.Services;

public class ScriptReloadListener
extends SimpleJsonResourceReloadListener<CarryOnScript> {
    public ScriptReloadListener() {
        super(CarryOnScript.CODEC, FileToIdConverter.json((String)"carryon/scripts"));
    }

    protected void apply(Map<ResourceLocation, CarryOnScript> scripts, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        ScriptManager.SCRIPTS.clear();
        scripts.forEach((path, script) -> {
            if (script.isValid()) {
                ScriptManager.SCRIPTS.add((CarryOnScript)script);
            }
        });
        ScriptManager.SCRIPTS.sort((s1, s2) -> Long.compare(s2.priority(), s1.priority()));
    }

    public static void syncScriptsWithClient(ServerPlayer player) {
        if (player != null) {
            DataResult result = Codec.list(CarryOnScript.CODEC).encodeStart((DynamicOps)NbtOps.INSTANCE, ScriptManager.SCRIPTS);
            Tag tag = (Tag)result.getOrThrow(s -> {
                throw new RuntimeException("Error while synching Carry On Scripts: " + s);
            });
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_SYNC_SCRIPTS, new ClientboundSyncScriptsPacket(tag), player);
        }
    }
}

