/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.pickupcondition;

import com.mojang.serialization.DataResult;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.Constants;
import tschipp.carryon.common.pickupcondition.PickupCondition;

public class PickupConditionHandler {
    private static final List<PickupCondition> BLOCK_CONDITIONS = new ArrayList<PickupCondition>();
    private static final List<PickupCondition> ENTITY_CONDITIONS = new ArrayList<PickupCondition>();

    public static void initPickupConditions() {
        PickupCondition pickupCondition;
        DataResult<PickupCondition> res;
        BLOCK_CONDITIONS.clear();
        ENTITY_CONDITIONS.clear();
        for (String cond : Constants.COMMON_CONFIG.customPickupConditions.customPickupConditionsBlocks) {
            res = PickupCondition.of(cond);
            if (res.result().isPresent()) {
                pickupCondition = (PickupCondition)res.result().get();
                BLOCK_CONDITIONS.add(pickupCondition);
                continue;
            }
            Constants.LOG.debug("Error while parsing Pickup Conditions: " + ((DataResult.Error)res.error().get()).message());
        }
        for (String cond : Constants.COMMON_CONFIG.customPickupConditions.customPickupConditionsEntities) {
            res = PickupCondition.of(cond);
            if (res.result().isPresent()) {
                pickupCondition = (PickupCondition)res.result().get();
                ENTITY_CONDITIONS.add(pickupCondition);
                continue;
            }
            Constants.LOG.debug("Error while parsing Pickup Conditions: " + ((DataResult.Error)res.error().get()).message());
        }
    }

    public static Optional<PickupCondition> getPickupCondition(BlockState state) {
        for (PickupCondition cond : BLOCK_CONDITIONS) {
            if (!cond.matches(state)) continue;
            return Optional.of(cond);
        }
        return Optional.empty();
    }

    public static Optional<PickupCondition> getPickupCondition(Entity entity) {
        for (PickupCondition cond : ENTITY_CONDITIONS) {
            if (!cond.matches(entity)) continue;
            return Optional.of(cond);
        }
        return Optional.empty();
    }
}

