/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.state.BlockState;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;

public class CommandCarryOn {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"carryon").then(Commands.literal((String)"debug").executes(cmd -> CommandCarryOn.handleDebug((CommandSourceStack)cmd.getSource())))).then(Commands.literal((String)"clear").executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).getPlayerOrException()))))).then(Commands.literal((String)"clear").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).requires(src -> src.hasPermission(2))).executes(cmd -> CommandCarryOn.handleClear((CommandSourceStack)cmd.getSource(), EntityArgument.getPlayers((CommandContext)cmd, (String)"target")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"place").requires(src -> src.hasPermission(2))).executes(cmd -> CommandCarryOn.handlePlace((CommandSourceStack)cmd.getSource(), Collections.singleton(((CommandSourceStack)cmd.getSource()).getPlayerOrException()))))).then(Commands.literal((String)"place").then(((RequiredArgumentBuilder)Commands.argument((String)"target", (ArgumentType)EntityArgument.players()).requires(src -> src.hasPermission(2))).executes(cmd -> CommandCarryOn.handlePlace((CommandSourceStack)cmd.getSource(), EntityArgument.getPlayers((CommandContext)cmd, (String)"target")))));
        dispatcher.register(builder);
    }

    private static int handleDebug(CommandSourceStack source) {
        try {
            if (source.getEntityOrException() != null) {
                ServerPlayer player = source.getPlayerOrException();
                CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    Optional<PickupCondition> cond;
                    BlockState block = carry.getBlock();
                    CommandCarryOn.log(source, "Block: " + String.valueOf(block.getBlock()));
                    CommandCarryOn.log(source, "BlockState: " + String.valueOf(block));
                    CommandCarryOn.log(source, "NBT: " + String.valueOf(carry.getNbt()));
                    Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(block, carry.getContentNbt());
                    if (ov.isPresent()) {
                        CommandCarryOn.log(source, "Override Model: " + String.valueOf(ov.get().getRenderObject()));
                    }
                    if ((cond = PickupConditionHandler.getPickupCondition(block)).isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                    Entity entity = carry.getEntity(player.level());
                    CommandCarryOn.log(source, "Entity: " + String.valueOf(entity));
                    CommandCarryOn.log(source, "Entity Name: " + String.valueOf(entity.getType()));
                    CommandCarryOn.log(source, "NBT: " + String.valueOf(carry.getNbt()));
                    Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(entity);
                    if (cond.isPresent()) {
                        CommandCarryOn.log(source, "Custom Pickup Condition: " + cond.get().getCondition());
                    }
                    return 1;
                }
                if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
                    CommandCarryOn.log(source, "Carrying Player.");
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return 0;
    }

    private static int handleClear(CommandSourceStack source, Collection<ServerPlayer> players) {
        int cleared = 0;
        for (ServerPlayer player : players) {
            CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, carry);
            ++cleared;
        }
        int finalCleared = cleared;
        if (cleared != 1) {
            source.sendSuccess(() -> Component.literal((String)("Cleared " + finalCleared + " Items!")), true);
        } else {
            source.sendSuccess(() -> Component.literal((String)("Cleared " + finalCleared + " Item!")), true);
        }
        return 1;
    }

    private static int handlePlace(CommandSourceStack source, Collection<ServerPlayer> players) {
        int cleared = 0;
        for (ServerPlayer player : players) {
            PlacementHandler.placeCarried(player);
            ++cleared;
        }
        int finalCleared = cleared;
        if (cleared != 1) {
            source.sendSuccess(() -> Component.literal((String)("Placed " + finalCleared + " Items!")), true);
        } else {
            source.sendSuccess(() -> Component.literal((String)("Placed " + finalCleared + " Item!")), true);
        }
        return 1;
    }

    private static void log(CommandSourceStack source, String toLog) {
        source.sendSuccess(() -> Component.literal((String)toLog), true);
        Constants.LOG.info(toLog);
    }
}

