/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

public class PickupHandler {
    public static boolean canCarryGeneral(ServerPlayer player, Vec3 pos) {
        if (!player.getMainHandItem().isEmpty() || !player.getOffhandItem().isEmpty()) {
            return false;
        }
        if (player.position().distanceTo(pos) > Constants.COMMON_CONFIG.settings.maxDistance) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying()) {
            return false;
        }
        if (!carry.isKeyPressed()) {
            return false;
        }
        if (player.tickCount == carry.getTick()) {
            return false;
        }
        return player.gameMode.getGameModeForPlayer() != GameType.SPECTATOR && player.gameMode.getGameModeForPlayer() != GameType.ADVENTURE;
    }

    public static boolean tryPickUpBlock(ServerPlayer player, BlockPos pos, Level level, @Nullable BiFunction<BlockState, BlockPos, Boolean> pickupCallback) {
        boolean doPickup;
        if (!PickupHandler.canCarryGeneral(player, Vec3.atCenterOf((Vec3i)pos))) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        BlockState state = level.getBlockState(pos);
        CompoundTag nbt = null;
        if (blockEntity != null) {
            nbt = blockEntity.saveWithId((HolderLookup.Provider)level.registryAccess());
        }
        if (!ListHandler.isPermitted(state.getBlock())) {
            return false;
        }
        if (state.getDestroySpeed((BlockGetter)level, pos) == -1.0f && !player.isCreative() && !Constants.COMMON_CONFIG.settings.pickupUnbreakableBlocks) {
            return false;
        }
        if (blockEntity == null && !Constants.COMMON_CONFIG.settings.pickupAllBlocks) {
            return false;
        }
        if (blockEntity != null && nbt.contains("Lock") && !nbt.getString("Lock").equals("")) {
            return false;
        }
        Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(state);
        if (cond.isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(state, pos);
        if (!doPickup) {
            return false;
        }
        Optional<CarryOnScript> result = ScriptManager.inspectBlock(state, level, pos, nbt);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
            String cmd = script.scriptEffects().commandInit();
            if (!cmd.isEmpty()) {
                player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd);
            }
        }
        carry.setBlock(state, blockEntity, player, pos);
        level.removeBlockEntity(pos);
        level.removeBlock(pos, false);
        CarryOnDataManager.setCarryData((Player)player, carry);
        level.playSound(null, pos, state.getSoundType().getHitSound(), SoundSource.BLOCKS, 1.0f, 0.5f);
        player.swing(InteractionHand.MAIN_HAND, true);
        return true;
    }

    public static boolean tryPickupEntity(ServerPlayer player, Entity entity, @Nullable Function<Entity, Boolean> pickupCallback) {
        String cmd;
        boolean doPickup;
        Optional<PickupCondition> cond;
        block21: {
            block22: {
                if (!PickupHandler.canCarryGeneral(player, entity.position())) {
                    return false;
                }
                if (entity.invulnerableTime != 0) {
                    return false;
                }
                if (entity.isRemoved()) {
                    return false;
                }
                if (entity instanceof TamableAnimal) {
                    TamableAnimal tame = (TamableAnimal)entity;
                    UUID owner = tame.getOwnerUUID();
                    UUID playerID = player.getGameProfile().getId();
                    if (owner != null && !owner.equals(playerID)) {
                        return false;
                    }
                }
                if (ListHandler.isPermitted(entity)) break block21;
                if (!(entity instanceof AgeableMob)) break block22;
                AgeableMob ageableMob = (AgeableMob)entity;
                if (Constants.COMMON_CONFIG.settings.allowBabies && (ageableMob.getAge() < 0 || ageableMob.isBaby())) break block21;
            }
            return false;
        }
        if (!player.isCreative()) {
            if (!Constants.COMMON_CONFIG.settings.pickupHostileMobs && entity.getType().getCategory() == MobCategory.MONSTER) {
                return false;
            }
            if (Constants.COMMON_CONFIG.settings.maxEntityHeight < (double)entity.getBbHeight() || Constants.COMMON_CONFIG.settings.maxEntityWidth < (double)entity.getBbWidth()) {
                return false;
            }
        }
        if ((cond = PickupConditionHandler.getPickupCondition(entity)).isPresent() && !cond.get().isFulfilled(player)) {
            return false;
        }
        boolean bl = doPickup = pickupCallback == null ? true : pickupCallback.apply(entity);
        if (!doPickup) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        Optional<CarryOnScript> result = ScriptManager.inspectEntity(entity);
        if (result.isPresent()) {
            CarryOnScript script = result.get();
            if (!script.fulfillsConditions(player)) {
                return false;
            }
            carry.setActiveScript(script);
        }
        if (entity instanceof Player) {
            String cmd2;
            Player otherPlayer = (Player)entity;
            if (!Constants.COMMON_CONFIG.settings.pickupPlayers) {
                return false;
            }
            if (!player.isCreative() && otherPlayer.isCreative()) {
                return false;
            }
            otherPlayer.ejectPassengers();
            otherPlayer.stopRiding();
            if (result.isPresent() && !(cmd2 = result.get().scriptEffects().commandInit()).isEmpty()) {
                player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd2);
            }
            otherPlayer.startRiding((Entity)player);
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.getId(), true), player);
            carry.setCarryingPlayer();
            player.swing(InteractionHand.MAIN_HAND, true);
            player.level().playSound(null, player.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.AMBIENT, 1.0f, 0.5f);
            CarryOnDataManager.setCarryData((Player)player, carry);
            return true;
        }
        entity.ejectPassengers();
        entity.stopRiding();
        if (entity instanceof Animal) {
            Animal animal = (Animal)entity;
            animal.dropLeash();
        }
        if (result.isPresent() && !(cmd = result.get().scriptEffects().commandInit()).isEmpty()) {
            player.getServer().getCommands().performPrefixedCommand(player.getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().getName() + " run " + cmd);
        }
        carry.setEntity(entity);
        entity.remove(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        player.level().playSound(null, player.getOnPos(), (SoundEvent)SoundEvents.ARMOR_EQUIP_GENERIC.value(), SoundSource.AMBIENT, 1.0f, 0.5f);
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.swing(InteractionHand.MAIN_HAND, true);
        return true;
    }
}

