/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryOnData {
    private CarryType type;
    private CompoundTag nbt;
    private boolean keyPressed = false;
    private CarryOnScript activeScript;
    private int selectedSlot = 0;

    public CarryOnData(CompoundTag data) {
        this.type = data.contains("type") ? CarryType.valueOf(data.getString("type")) : CarryType.INVALID;
        this.nbt = data;
        if (data.contains("keyPressed")) {
            this.keyPressed = data.getBoolean("keyPressed");
        }
        if (data.contains("activeScript")) {
            DataResult res = CarryOnScript.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data.get("activeScript"));
            this.activeScript = (CarryOnScript)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to decode activeScript during CarryOnData serialization: " + s);
            });
        }
        if (data.contains("selected")) {
            this.selectedSlot = data.getInt("selected");
        }
    }

    public CompoundTag getNbt() {
        this.nbt.putString("type", this.type.toString());
        this.nbt.putBoolean("keyPressed", this.keyPressed);
        if (this.activeScript != null) {
            DataResult res = CarryOnScript.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.activeScript);
            Tag tag = (Tag)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to encode activeScript during CarryOnData serialization: " + s);
            });
            this.nbt.put("activeScript", tag);
        }
        this.nbt.putInt("selected", this.selectedSlot);
        return this.nbt;
    }

    public CompoundTag getContentNbt() {
        if (this.type == CarryType.BLOCK && this.nbt.contains("block")) {
            return this.nbt.getCompound("block");
        }
        if (this.type == CarryType.ENTITY && this.nbt.contains("entity")) {
            return this.nbt.getCompound("entity");
        }
        return null;
    }

    public void setBlock(BlockState state, @Nullable BlockEntity tile, ServerPlayer player, BlockPos pos) {
        this.type = CarryType.BLOCK;
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        CompoundTag stateData = NbtUtils.writeBlockState((BlockState)state);
        this.nbt.put("block", (Tag)stateData);
        if (tile != null) {
            CompoundTag tileData = tile.saveWithId((HolderLookup.Provider)tile.getLevel().registryAccess());
            this.nbt.put("tile", (Tag)tileData);
        }
    }

    public BlockState getBlock() {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlock on data that contained " + String.valueOf((Object)this.type));
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK, (CompoundTag)this.nbt.getCompound("block"));
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, HolderLookup.Provider lookup) {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlockEntity on data that contained " + String.valueOf((Object)this.type));
        }
        if (!this.nbt.contains("tile")) {
            return null;
        }
        return BlockEntity.loadStatic((BlockPos)pos, (BlockState)this.getBlock(), (CompoundTag)this.nbt.getCompound("tile"), (HolderLookup.Provider)lookup);
    }

    public void setEntity(Entity entity) {
        this.type = CarryType.ENTITY;
        CompoundTag entityData = new CompoundTag();
        entity.save(entityData);
        this.nbt.put("entity", (Tag)entityData);
    }

    public Entity getEntity(Level level) {
        if (this.type != CarryType.ENTITY) {
            throw new IllegalStateException("Called getEntity on data that contained " + String.valueOf((Object)this.type));
        }
        Optional optionalEntity = EntityType.create((CompoundTag)this.nbt.getCompound("entity"), (Level)level, (EntitySpawnReason)EntitySpawnReason.BUCKET);
        if (optionalEntity.isPresent()) {
            return (Entity)optionalEntity.get();
        }
        Constants.LOG.error("Called EntityType#create even though no entity data was present. Data: " + this.nbt.toString());
        this.clear();
        return new AreaEffectCloud(level, 0.0, 0.0, 0.0);
    }

    public Optional<CarryOnScript> getActiveScript() {
        if (this.activeScript == null) {
            return Optional.empty();
        }
        return Optional.of(this.activeScript);
    }

    public void setActiveScript(CarryOnScript script) {
        this.activeScript = script;
    }

    public void setCarryingPlayer() {
        this.type = CarryType.PLAYER;
    }

    public boolean isCarrying() {
        return this.type != CarryType.INVALID;
    }

    public boolean isCarrying(CarryType type) {
        return this.type == type;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public void setKeyPressed(boolean val) {
        this.keyPressed = val;
        this.nbt.putBoolean("keyPressed", val);
    }

    public void setSelected(int selectedSlot) {
        this.selectedSlot = selectedSlot;
    }

    public int getSelected() {
        return this.selectedSlot;
    }

    public void clear() {
        this.type = CarryType.INVALID;
        this.nbt = new CompoundTag();
        this.activeScript = null;
    }

    public CarryOnData clone() {
        return new CarryOnData(this.nbt.copy());
    }

    public int getTick() {
        if (!this.nbt.contains("tick")) {
            return -1;
        }
        return this.nbt.getInt("tick");
    }

    public static enum CarryType {
        BLOCK,
        ENTITY,
        PLAYER,
        INVALID;

    }
}

