/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryRenderHelper {
    public static Vec3 getExactPos(Entity entity, float partialticks) {
        return new Vec3(entity.xOld + (entity.getX() - entity.xOld) * (double)partialticks, entity.yOld + (entity.getY() - entity.yOld) * (double)partialticks, entity.zOld + (entity.getZ() - entity.zOld) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(LivingEntity entity, float partialticks) {
        Entity entity2;
        if (entity.getVehicle() != null && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (vehicle instanceof Player) {
                Player player = (Player)vehicle;
                return -(player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialticks);
            }
            return -(entity.yHeadRotO + (entity.yHeadRot - entity.yHeadRotO) * partialticks);
        }
        return -(entity.yBodyRotO + (entity.yBodyRot - entity.yBodyRotO) * partialticks);
    }

    public static Quaternionf getExactBodyRotation(LivingEntity entity, float partialticks) {
        return Axis.YP.rotationDegrees(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void applyGeneralTransformations(Player player, float partialticks, PoseStack matrix) {
        int perspective = CarryRenderHelper.getPerspective();
        Quaternionf playerrot = CarryRenderHelper.getExactBodyRotation((LivingEntity)player, partialticks);
        Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
        Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
        Vec3 offset = playerpos.subtract(cameraPos);
        Pose pose = player.getPose();
        matrix.pushPose();
        matrix.translate(offset.x, offset.y, offset.z);
        if (perspective == 2) {
            playerrot.mul((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }
        matrix.mulPose(playerrot);
        matrix.pushPose();
        matrix.scale(0.6f, 0.6f, 0.6f);
        if (perspective == 2) {
            matrix.translate(0.0, 0.0, -1.35);
        }
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.translate(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING) {
            float f = player.getSwimAmount(partialticks);
            float f3 = player.isInWater() ? -90.0f - player.xRotO : -90.0f;
            float f4 = Mth.lerp((float)f, (float)0.0f, (float)f3);
            if (perspective == 2) {
                matrix.translate(0.0, 0.0, 1.35);
                matrix.mulPose(Axis.XP.rotationDegrees(f4));
            } else {
                matrix.mulPose(Axis.XN.rotationDegrees(f4));
            }
            matrix.translate(0.0, -1.5, -1.848);
            if (perspective == 2) {
                matrix.translate(0.0, 0.0, 2.38);
            }
        }
        if (pose == Pose.FALL_FLYING) {
            float f1 = (float)player.getFallFlyingTicks() + partialticks;
            float f2 = Mth.clamp((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.isAutoSpinAttack()) {
                if (perspective == 2) {
                    matrix.translate(0.0, 0.0, 1.35);
                }
                if (perspective == 2) {
                    matrix.mulPose(Axis.XP.rotationDegrees(f2 * (-90.0f - player.xRotO)));
                } else {
                    matrix.mulPose(Axis.XN.rotationDegrees(f2 * (-90.0f - player.xRotO)));
                }
            }
            Vec3 viewVector = player.getViewVector(partialticks);
            Vec3 deltaMovement = player.getDeltaMovement();
            double d0 = deltaMovement.horizontalDistanceSqr();
            double d1 = deltaMovement.horizontalDistanceSqr();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (deltaMovement.x * viewVector.x + deltaMovement.z * viewVector.z) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = deltaMovement.x * viewVector.z - deltaMovement.z * viewVector.x;
                matrix.mulPose(Axis.YP.rotation((float)(Math.signum(d3) * Math.acos(d2))));
            }
            if (perspective != 2) {
                matrix.translate(0.0, 0.0, -1.35);
            }
            matrix.translate(0.0, -0.2, 0.0);
        }
        matrix.translate(0.0, 1.6, 0.65);
    }

    public static void applyBlockTransformations(Player player, float partialticks, PoseStack matrix, Block block) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block)) {
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        float height = CarryRenderHelper.getRenderHeight(player);
        float offset = (height - 1.0f) / 1.2f;
        matrix.translate(0.0f, -offset, 0.0f);
    }

    public static void applyEntityTransformations(Player player, float partialticks, PoseStack matrix, Entity entity) {
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.getPose();
        CarryRenderHelper.applyGeneralTransformations(player, partialticks, matrix);
        if (perspective == 2) {
            matrix.translate(0.0, -1.6, 0.65);
        } else {
            matrix.translate(0.0, -1.6, -0.65);
        }
        matrix.scale(1.666f, 1.666f, 1.666f);
        float height = entity.getBbHeight();
        float width = entity.getBbWidth();
        float multiplier = height * width;
        entity.yo = 0.0;
        entity.yRotO = 0.0f;
        entity.setYHeadRot(0.0f);
        entity.xo = 0.0;
        entity.xRotO = 0.0f;
        if (perspective == 2) {
            matrix.mulPose(Axis.YP.rotationDegrees(180.0f));
        }
        matrix.scale((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.translate(0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.mulPose(Axis.XN.rotationDegrees(90.0f));
            matrix.translate(0.0, -0.2 * (double)height, 0.0);
            if (pose == Pose.FALL_FLYING) {
                matrix.translate(0.0, 0.0, 0.2);
            }
        }
    }

    public static void performScriptTransformation(PoseStack matrix, CarryOnScript script) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryOnScript.ScriptRender render = script.scriptRender();
        Vec3 translation = render.renderTranslation().getVec();
        Vec3 rotation = render.renderRotation().getVec();
        Vec3 scale = render.renderscale().getVec(1.0, 1.0, 1.0);
        Quaternionf rot = Axis.XP.rotationDegrees((float)rotation.x);
        rot.mul((Quaternionfc)Axis.YP.rotationDegrees((float)rotation.y));
        rot.mul((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation.z));
        matrix.mulPose(rot);
        matrix.translate(translation.x, translation.y, perspective == 1 && script.isBlock() ? -translation.z : translation.z);
        matrix.scale((float)scale.x, (float)scale.y, (float)scale.z);
    }

    public static ItemStack getRenderItemStack(Player player) {
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        BlockState state = carry.getBlock().getBlock().defaultBlockState();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(render.renderNameBlock().get()).get()).value()).defaultBlockState();
        }
        ItemStack renderStack = ItemStack.EMPTY;
        Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
        if (ov.isPresent()) {
            Either<ItemStack, BlockState> renderObj = ov.get().getRenderObject();
            if (renderObj.right().isPresent()) {
                state = (BlockState)renderObj.right().get();
            } else if (renderObj.left().isPresent()) {
                renderStack = (ItemStack)renderObj.left().get();
            }
        }
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((ItemLike)state.getBlock());
        }
        return renderStack;
    }

    public static BlockState getRenderState(Player player) {
        Either<ItemStack, BlockState> renderObj;
        Optional<ModelOverride> ov;
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        BlockState state = carry.getBlock().getBlock().defaultBlockState();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(render.renderNameBlock().get()).get()).value()).defaultBlockState();
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).right().isPresent()) {
            state = (BlockState)renderObj.right().get();
        }
        return state;
    }

    public static Entity getRenderEntity(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        Entity entity = carry.getEntity(player.level());
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript script = carry.getActiveScript().get();
            CarryOnScript.ScriptRender render = script.scriptRender();
            if (render.renderNameEntity().isPresent()) {
                entity = ((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(render.renderNameEntity().get()).get()).value()).create(player.level(), EntitySpawnReason.EVENT);
            }
            if (render.renderNBT().isPresent()) {
                entity.load(render.renderNBT().get());
            }
        }
        return entity;
    }

    public static float getRenderWidth(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.getShape((BlockGetter)player.level(), player.blockPosition());
            if (shape == null || shape.isEmpty()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.8f;
            }
            float width = (float)Math.abs(shape.bounds().maxX - shape.bounds().minX);
            return width;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            return entity.getBbWidth();
        }
        return 1.0f;
    }

    public static float getRenderHeight(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.getShape((BlockGetter)player.level(), player.blockPosition());
            if (shape == null || shape.isEmpty()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.5f;
            }
            float height = (float)Math.abs(shape.bounds().maxY - shape.bounds().minY);
            return height;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            return entity.getBbHeight();
        }
        return 1.0f;
    }

    public static int getPerspective() {
        boolean isThirdPerson = !Minecraft.getInstance().options.getCameraType().isFirstPerson();
        boolean isThirdPersonReverse = Minecraft.getInstance().options.getCameraType().isMirrored();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }

    public static boolean doSneakCheck(Player player) {
        if (player.getAbilities().flying) {
            return false;
        }
        return player.isShiftKeyDown() || player.isCrouching();
    }

    public static boolean isChest(Block block) {
        return block == Blocks.CHEST || block == Blocks.ENDER_CHEST || block == Blocks.TRAPPED_CHEST;
    }
}

