/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Axis;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import tschipp.carryon.Constants;
import tschipp.carryon.client.modeloverride.ModelOverride;
import tschipp.carryon.client.modeloverride.ModelOverrideHandler;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryRenderHelper {
    public static Vec3 getExactPos(Entity entity, float partialticks) {
        return new Vec3(entity.xOld + (entity.getX() - entity.xOld) * (double)partialticks, entity.yOld + (entity.getY() - entity.yOld) * (double)partialticks, entity.zOld + (entity.getZ() - entity.zOld) * (double)partialticks);
    }

    public static float getExactBodyRotationDegrees(LivingEntity entity, float partialticks) {
        Entity entity2;
        if (entity.getVehicle() != null && (entity2 = entity.getVehicle()) instanceof LivingEntity) {
            LivingEntity vehicle = (LivingEntity)entity2;
            if (vehicle instanceof Player) {
                Player player = (Player)vehicle;
                return -(player.yBodyRotO + (player.yBodyRot - player.yBodyRotO) * partialticks);
            }
            return -(entity.yHeadRotO + (entity.yHeadRot - entity.yHeadRotO) * partialticks);
        }
        return -(entity.yBodyRotO + (entity.yBodyRot - entity.yBodyRotO) * partialticks);
    }

    public static Quaternionf getExactBodyRotation(LivingEntity entity, float partialticks) {
        return Axis.YP.rotationDegrees(CarryRenderHelper.getExactBodyRotationDegrees(entity, partialticks));
    }

    public static void applyGeneralTransformations(Player player, PoseStack matrix) {
        Pose pose = player.getPose();
        matrix.pushPose();
        matrix.scale(0.6f, 0.6f, 0.6f);
        matrix.translate(0.0, 0.0, -1.35);
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.translate(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.translate(0.0, 0.0, 2.5);
            matrix.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
        }
        matrix.translate(0.0, -0.5, 0.65);
    }

    public static PoseStack setupBlockTransformations(Player player, PoseStack matrix, CarryOnData carry, boolean firstPerson) {
        if (firstPerson) {
            matrix.scale(2.5f, 2.5f, 2.5f);
            matrix.translate(0.0, -0.5, -1.0);
            if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(carry.getBlock().getBlock())) {
                matrix.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                matrix.mulPose((Quaternionfc)Axis.XN.rotationDegrees(8.0f));
            } else {
                matrix.mulPose((Quaternionfc)Axis.XP.rotationDegrees(8.0f));
            }
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
            return matrix;
        }
        CarryRenderHelper.applyBlockTransformations(player, matrix, carry.getBlock().getBlock());
        carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
        PoseStack.Pose p = matrix.last();
        PoseStack copy = new PoseStack();
        copy.mulPose((Matrix4fc)p.pose());
        matrix.popPose();
        return copy;
    }

    public static void applyBlockTransformations(Player player, PoseStack matrix, Block block) {
        matrix.mulPose((Quaternionfc)Axis.ZN.rotationDegrees(180.0f));
        CarryRenderHelper.applyGeneralTransformations(player, matrix);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(block)) {
            matrix.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
        }
        float height = CarryRenderHelper.getRenderHeight(player);
        float offset = (height - 1.0f) / 1.2f;
        matrix.translate(0.0f, -offset, 0.0f);
    }

    public static void setupEntityTransformations(Player player, PoseStack matrix, CarryOnData carry, boolean firstPerson) {
        Entity entity = carry.getEntity(player.level());
        float height = entity.getBbHeight();
        float width = entity.getBbWidth();
        if (firstPerson) {
            matrix.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
            matrix.scale(0.8f, 0.8f, 0.8f);
            matrix.translate(0.0, (double)(-height) - 0.2, (double)width * 1.3 + 0.1);
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
            if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
                matrix.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
            }
        } else {
            CarryRenderHelper.applyEntityTransformations(player, matrix, entity);
            carry.getActiveScript().ifPresent(script -> CarryRenderHelper.performScriptTransformation(matrix, script));
        }
    }

    public static void applyEntityTransformations(Player player, PoseStack matrix, Entity entity) {
        Pose pose = player.getPose();
        CarryRenderHelper.applyGeneralTransformations(player, matrix);
        matrix.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
        matrix.translate(0.0, -3.1, -0.65);
        matrix.scale(1.666f, 1.666f, 1.666f);
        float height = entity.getBbHeight();
        float width = entity.getBbWidth();
        float multiplier = Math.min(9.9f, height * width);
        entity.yo = 0.0;
        entity.yRotO = 0.0f;
        entity.setYHeadRot(0.0f);
        entity.xo = 0.0;
        entity.xRotO = 0.0f;
        matrix.scale((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.translate(0.0, (double)(height / 2.0f + -(height / 4.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (CarryRenderHelper.doSneakCheck(player)) {
            matrix.translate(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.mulPose((Quaternionfc)Axis.XN.rotationDegrees(180.0f));
            matrix.translate(0.0, 0.2 * (double)height - 2.0, -0.5);
        }
        if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
            matrix.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        }
    }

    public static void performScriptTransformation(PoseStack matrix, CarryOnScript script) {
        int perspective = CarryRenderHelper.getPerspective();
        CarryOnScript.ScriptRender render = script.scriptRender();
        Vec3 translation = render.renderTranslation().getVec();
        Vec3 rotation = render.renderRotation().getVec();
        Vec3 scale = render.renderscale().getVec(1.0, 1.0, 1.0);
        Quaternionf rot = Axis.XP.rotationDegrees((float)rotation.x);
        rot.mul((Quaternionfc)Axis.YP.rotationDegrees((float)rotation.y));
        rot.mul((Quaternionfc)Axis.ZP.rotationDegrees((float)rotation.z));
        matrix.mulPose((Quaternionfc)rot);
        matrix.translate(translation.x, translation.y, perspective == 1 && script.isBlock() ? -translation.z : translation.z);
        matrix.scale((float)scale.x, (float)scale.y, (float)scale.z);
    }

    public static ItemStack getRenderItemStack(Player player) {
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        BlockState state = carry.getBlock().getBlock().defaultBlockState();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(render.renderNameBlock().get()).get()).value()).defaultBlockState();
        }
        ItemStack renderStack = ItemStack.EMPTY;
        Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
        if (ov.isPresent()) {
            Either<ItemStack, BlockState> renderObj = ov.get().getRenderObject();
            if (renderObj.right().isPresent()) {
                state = (BlockState)renderObj.right().get();
            } else if (renderObj.left().isPresent()) {
                renderStack = (ItemStack)renderObj.left().get();
            }
        }
        if (renderStack.isEmpty()) {
            renderStack = new ItemStack((ItemLike)state.getBlock());
        }
        return renderStack;
    }

    public static BlockState getRenderState(Player player) {
        Either<ItemStack, BlockState> renderObj;
        Optional<ModelOverride> ov;
        CarryOnScript.ScriptRender render;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        BlockState state = carry.getBlock().getBlock().defaultBlockState();
        if (carry.getActiveScript().isPresent() && (render = carry.getActiveScript().get().scriptRender()).renderNameBlock().isPresent()) {
            state = ((Block)((Holder.Reference)BuiltInRegistries.BLOCK.get(render.renderNameBlock().get()).get()).value()).defaultBlockState();
        }
        if ((ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt())).isPresent() && (renderObj = ov.get().getRenderObject()).right().isPresent()) {
            state = (BlockState)renderObj.right().get();
        }
        return state;
    }

    public static Entity getRenderEntity(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        Entity entity = carry.getEntity(player.level());
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript script = carry.getActiveScript().get();
            CarryOnScript.ScriptRender render = script.scriptRender();
            if (render.renderNameEntity().isPresent()) {
                entity = ((EntityType)((Holder.Reference)BuiltInRegistries.ENTITY_TYPE.get(render.renderNameEntity().get()).get()).value()).create(player.level(), EntitySpawnReason.EVENT);
            }
            if (render.renderNBT().isPresent()) {
                ValueInput input = TagValueInput.create((ProblemReporter)new ProblemReporter.ScopedCollector(Constants.LOG), (HolderLookup.Provider)player.registryAccess(), (CompoundTag)render.renderNBT().get());
                entity.load(input);
            }
        }
        return entity;
    }

    public static float getRenderWidth(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.getShape((BlockGetter)player.level(), player.blockPosition());
            if (shape == null || shape.isEmpty()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.8f;
            }
            float width = (float)Math.abs(shape.bounds().maxX - shape.bounds().minX);
            return width;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            float w = entity.getBbWidth();
            if (Constants.CLIENT_CONFIG.rotateEntitiesSideways) {
                return w - w * w * 0.35f;
            }
            return w * 0.9f;
        }
        return 1.0f;
    }

    public static float getRenderHeight(Player player) {
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            Either<ItemStack, BlockState> renderObj;
            BlockState state = CarryRenderHelper.getRenderState(player);
            VoxelShape shape = state.getShape((BlockGetter)player.level(), player.blockPosition());
            if (shape == null || shape.isEmpty()) {
                return 1.0f;
            }
            Optional<ModelOverride> ov = ModelOverrideHandler.getModelOverride(state, carry.getContentNbt());
            if (ov.isPresent() && (renderObj = ov.get().getRenderObject()).left().isPresent()) {
                return 0.5f;
            }
            float height = (float)Math.abs(shape.bounds().maxY - shape.bounds().minY);
            return height;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = CarryRenderHelper.getRenderEntity(player);
            return entity.getBbHeight();
        }
        return 1.0f;
    }

    public static int getPerspective() {
        boolean isThirdPerson = !Minecraft.getInstance().options.getCameraType().isFirstPerson();
        boolean isThirdPersonReverse = Minecraft.getInstance().options.getCameraType().isMirrored();
        if (!isThirdPerson && !isThirdPersonReverse) {
            return 0;
        }
        if (isThirdPerson && !isThirdPersonReverse) {
            return 1;
        }
        return 2;
    }

    public static boolean doSneakCheck(Player player) {
        if (player.getAbilities().flying) {
            return false;
        }
        return player.isShiftKeyDown() || player.isCrouching();
    }

    public static boolean isChest(Block block) {
        return block == Blocks.CHEST || block == Blocks.ENDER_CHEST || block == Blocks.TRAPPED_CHEST || block instanceof ChestBlock;
    }
}

