/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import tschipp.carryon.Constants;
import tschipp.carryon.common.scripting.CarryOnScript;

public class CarryOnData {
    private CarryType type;
    private CompoundTag nbt;
    private boolean keyPressed = false;
    private CarryOnScript activeScript;
    private int selectedSlot = 0;
    private static final ProblemReporter problemReporter = new ProblemReporter.ScopedCollector(Constants.LOG);
    public static final Codec<CarryOnData> CODEC = CompoundTag.CODEC.flatXmap(tag -> {
        try {
            return DataResult.success((Object)new CarryOnData((CompoundTag)tag));
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    }, carry -> {
        try {
            return DataResult.success((Object)carry.getNbt());
        }
        catch (Exception e) {
            return DataResult.error(e::getMessage);
        }
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, CarryOnData> STREAM_CODEC = ByteBufCodecs.fromCodecWithRegistries(CODEC);
    public static final String SERIALIZATION_KEY = "CarryOnData";

    public CarryOnData(CompoundTag data) {
        this.type = data.contains("type") ? CarryType.valueOf(data.getStringOr("type", "INVALID")) : CarryType.INVALID;
        this.nbt = data;
        this.keyPressed = data.getBooleanOr("keyPressed", false);
        if (data.contains("activeScript")) {
            DataResult res = CarryOnScript.CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)data.get("activeScript"));
            this.activeScript = (CarryOnScript)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to decode activeScript during CarryOnData serialization: " + s);
            });
        }
        this.selectedSlot = data.getIntOr("selected", 0);
    }

    public CarryType getType() {
        return this.type;
    }

    public CompoundTag getNbt() {
        this.nbt.putString("type", this.type.toString());
        this.nbt.putBoolean("keyPressed", this.keyPressed);
        if (this.activeScript != null) {
            DataResult res = CarryOnScript.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.activeScript);
            Tag tag = (Tag)res.getOrThrow(s -> {
                throw new RuntimeException("Failed to encode activeScript during CarryOnData serialization: " + s);
            });
            this.nbt.put("activeScript", tag);
        }
        this.nbt.putInt("selected", this.selectedSlot);
        return this.nbt;
    }

    public CompoundTag getContentNbt() {
        if (this.type == CarryType.BLOCK && this.nbt.contains("block")) {
            return this.nbt.getCompoundOrEmpty("block");
        }
        if (this.type == CarryType.ENTITY && this.nbt.contains("entity")) {
            return this.nbt.getCompoundOrEmpty("entity");
        }
        return null;
    }

    public void setBlock(BlockState state, @Nullable BlockEntity tile, ServerPlayer player, BlockPos pos) {
        this.type = CarryType.BLOCK;
        if (state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        CompoundTag stateData = NbtUtils.writeBlockState((BlockState)state);
        this.nbt.put("block", (Tag)stateData);
        if (tile != null) {
            TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)problemReporter, (HolderLookup.Provider)player.registryAccess());
            tile.saveWithId((ValueOutput)output);
            CompoundTag tileData = output.buildResult();
            this.nbt.put("tile", (Tag)tileData);
        }
    }

    public BlockState getBlock() {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlock on data that contained " + String.valueOf((Object)this.type));
        }
        return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK, (CompoundTag)this.nbt.getCompoundOrEmpty("block"));
    }

    @Nullable
    public BlockEntity getBlockEntity(BlockPos pos, HolderLookup.Provider lookup) {
        if (this.type != CarryType.BLOCK) {
            throw new IllegalStateException("Called getBlockEntity on data that contained " + String.valueOf((Object)this.type));
        }
        if (!this.nbt.contains("tile")) {
            return null;
        }
        return BlockEntity.loadStatic((BlockPos)pos, (BlockState)this.getBlock(), (CompoundTag)this.nbt.getCompoundOrEmpty("tile"), (HolderLookup.Provider)lookup);
    }

    public void setEntity(Entity entity) {
        this.type = CarryType.ENTITY;
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)new ProblemReporter.ScopedCollector(Constants.LOG), (HolderLookup.Provider)entity.registryAccess());
        entity.save((ValueOutput)output);
        CompoundTag entityData = output.buildResult();
        this.nbt.put("entity", (Tag)entityData);
    }

    public Entity getEntity(Level level) {
        if (this.type != CarryType.ENTITY) {
            throw new IllegalStateException("Called getEntity on data that contained " + String.valueOf((Object)this.type));
        }
        ValueInput in = TagValueInput.create((ProblemReporter)problemReporter, (HolderLookup.Provider)level.registryAccess(), (CompoundTag)this.nbt.getCompoundOrEmpty("entity"));
        Optional optionalEntity = EntityType.create((ValueInput)in, (Level)level, (EntitySpawnReason)EntitySpawnReason.BUCKET);
        if (optionalEntity.isPresent()) {
            return (Entity)optionalEntity.get();
        }
        Constants.LOG.error("Called EntityType#create even though no entity data was present. Data: " + this.nbt.toString());
        this.clear();
        return new AreaEffectCloud(level, 0.0, 0.0, 0.0);
    }

    public Optional<CarryOnScript> getActiveScript() {
        if (this.activeScript == null) {
            return Optional.empty();
        }
        return Optional.of(this.activeScript);
    }

    public void setActiveScript(CarryOnScript script) {
        this.activeScript = script;
    }

    public void setCarryingPlayer(Player player) {
        this.type = CarryType.PLAYER;
        this.nbt.putString("player", player.getStringUUID().toString());
    }

    public Player getCarryingPlayer(Level level) {
        if (this.type != CarryType.PLAYER) {
            throw new IllegalStateException("Called getCarryingPlayer on data that contained " + String.valueOf((Object)this.type));
        }
        if (!this.nbt.contains("player")) {
            return null;
        }
        UUID uuid = UUID.fromString((String)this.nbt.getString("player").get());
        return level.getServer().getPlayerList().getPlayer(uuid);
    }

    public boolean isCarrying() {
        return this.type != CarryType.INVALID;
    }

    public boolean isCarrying(CarryType type) {
        return this.type == type;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public void setKeyPressed(boolean val) {
        this.keyPressed = val;
        this.nbt.putBoolean("keyPressed", val);
    }

    public void setSelected(int selectedSlot) {
        this.selectedSlot = selectedSlot;
    }

    public int getSelected() {
        return this.selectedSlot;
    }

    public void clear() {
        this.type = CarryType.INVALID;
        this.nbt = new CompoundTag();
        this.activeScript = null;
    }

    public CarryOnData clone() {
        return new CarryOnData(this.nbt.copy());
    }

    public int getTick() {
        return this.nbt.getIntOr("tick", -1);
    }

    public void setTick(int tick) {
        this.nbt.putInt("tick", tick);
    }

    public static enum CarryType {
        BLOCK,
        ENTITY,
        PLAYER,
        INVALID;

    }
}

