/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.events;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.common.util.Result;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.eventbus.internal.Event;
import net.minecraftforge.fml.common.Mod;
import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.Constants;
import tschipp.carryon.carry.CarryOnDataCapabilityProvider;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PickupHandler;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.scripting.ScriptReloadListener;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.events.EntityPickupEvent;
import tschipp.carryon.networking.ClientboundSyncCarryDataPacket;
import tschipp.carryon.platform.Services;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="carryon")
public class CommonEvents {
    @SubscribeEvent(priority=64)
    public static boolean onBlockClick(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        if (level.isClientSide()) {
            return false;
        }
        boolean success = false;
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickUpBlock((ServerPlayer)player, pos, level, (pState, pPos) -> {
                BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent(level, pPos, pState, player, Result.DEFAULT);
                return !BlockEvent.BreakEvent.BUS.post((Event)breakEvent);
            })) {
                success = true;
            }
        } else {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                PlacementHandler.tryPlaceBlock((ServerPlayer)player, pos, event.getFace(), (pos2, state) -> {
                    BlockSnapshot snapshot = BlockSnapshot.create((ResourceKey)level.dimension(), (LevelAccessor)level, (BlockPos)pos2);
                    BlockEvent.EntityPlaceEvent event1 = new BlockEvent.EntityPlaceEvent(snapshot, level.getBlockState(pos), (Entity)player);
                    return !BlockEvent.EntityPlaceEvent.BUS.post((Event)event1);
                });
            } else {
                PlacementHandler.tryPlaceEntity((ServerPlayer)player, pos, event.getFace(), (pPos, toPlace) -> {
                    if (toPlace instanceof Mob) {
                        Mob mob = (Mob)toPlace;
                        MobSpawnEvent.FinalizeSpawn checkSpawn = new MobSpawnEvent.FinalizeSpawn(mob, (ServerLevelAccessor)level, pPos.x, pPos.y, pPos.z, ((ServerLevelAccessor)level).getCurrentDifficultyAt(new BlockPos((int)pPos.x, (int)pPos.y, (int)pPos.z)), EntitySpawnReason.EVENT, null, null, null);
                        return !MobSpawnEvent.FinalizeSpawn.BUS.post((Event)checkSpawn);
                    }
                    return true;
                });
            }
            success = true;
        }
        if (success) {
            event.setUseBlock(Result.DENY);
            event.setUseItem(Result.DENY);
            event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
            return true;
        }
        return false;
    }

    @SubscribeEvent(priority=64)
    public static boolean onEntityRightClick(PlayerInteractEvent.EntityInteract event) {
        Player player = event.getEntity();
        Level level = event.getLevel();
        Entity target = event.getTarget();
        if (level.isClientSide()) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (!carry.isCarrying()) {
            if (PickupHandler.tryPickupEntity((ServerPlayer)player, target, toPickup -> {
                EntityPickupEvent pickupEvent = new EntityPickupEvent((ServerPlayer)player, (Entity)toPickup);
                return !EntityPickupEvent.BUS.post((Event)pickupEvent);
            })) {
                event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS);
                return true;
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY) || carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            PlacementHandler.tryStackEntity((ServerPlayer)player, target);
        }
        return false;
    }

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        CarryOnCommon.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void onDatapackRegister(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new ScriptReloadListener());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        ServerPlayer player = event.getPlayer();
        if (player == null) {
            for (ServerPlayer p : event.getPlayerList().getPlayers()) {
                ScriptReloadListener.syncScriptsWithClient(p);
            }
        } else {
            ScriptReloadListener.syncScriptsWithClient(player);
        }
    }

    @SubscribeEvent
    public static void onTagsUpdate(TagsUpdatedEvent event) {
        ConfigLoader.onConfigLoaded((HolderLookup.Provider)event.getRegistryAccess());
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent.Post event) {
        for (ServerPlayer player : event.server().getPlayerList().getPlayers()) {
            CarryOnCommon.onCarryTick(player);
        }
    }

    @SubscribeEvent
    public static void onClone(PlayerEvent.Clone event) {
        if (!event.getOriginal().level().isClientSide()) {
            Player newPlayer = event.getEntity();
            Player oldPlayer = event.getOriginal();
            oldPlayer.reviveCaps();
            PlacementHandler.placeCarriedOnDeath((ServerPlayer)oldPlayer, (ServerPlayer)newPlayer, event.isWasDeath());
            oldPlayer.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void harvestSpeed(PlayerEvent.BreakSpeed event) {
        if (!CarryOnCommon.onTryBreakBlock(event.getEntity())) {
            event.setNewSpeed(0.0f);
        }
    }

    @SubscribeEvent
    public static boolean attackEntity(AttackEntityEvent event) {
        return !CarryOnCommon.onAttackedByPlayer(event.getEntity());
    }

    @SubscribeEvent
    public static boolean onBreakBlock(BlockEvent.BreakEvent event) {
        return !CarryOnCommon.onTryBreakBlock(event.getPlayer());
    }

    @SubscribeEvent
    public static void playerAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            CarryOnCommon.onPlayerAttacked(player);
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOut(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer player2 = (ServerPlayer)player;
            CarryOnCommon.onRiderDisconnected((Player)player2);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent.Entities event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(Identifier.fromNamespaceAndPath((String)"carryon", (String)"carry_on_data"), (ICapabilityProvider)new CarryOnDataCapabilityProvider());
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player = event.getTarget();
            if (player instanceof ServerPlayer) {
                ServerPlayer target = (ServerPlayer)player;
                Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_SYNC_CARRY_ON_DATA, new ClientboundSyncCarryDataPacket(sp.getId(), CarryOnDataManager.getCarryData((Player)sp)), target);
            }
        }
    }

    @SubscribeEvent
    public static void onJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_SYNC_CARRY_ON_DATA, new ClientboundSyncCarryDataPacket(sp.getId(), CarryOnDataManager.getCarryData((Player)sp)), sp);
        }
    }

    @SubscribeEvent
    public static void onPlayerDie(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)livingEntity;
            CarryOnCommon.onRiderDisconnected((Player)sp);
        }
    }
}

