/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.config.forge;

import com.electronwill.nightconfig.core.AbstractConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tschipp.carryon.config.AnnotationData;
import tschipp.carryon.config.BuiltCategory;
import tschipp.carryon.config.BuiltConfig;
import tschipp.carryon.config.PropertyData;
import tschipp.carryon.config.PropertyType;

@Mod.EventBusSubscriber(modid="carryon")
public class ConfigLoaderImpl {
    public static final Map<ForgeConfigSpec, BuiltConfig> CONFIGS = new HashMap<ForgeConfigSpec, BuiltConfig>();

    public static void initialize(FMLJavaModLoadingContext context) {
        CONFIGS.forEach((spec, config) -> {
            if (config.fileName.contains("client")) {
                context.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)spec, config.fileName + ".toml");
            } else {
                context.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)spec, config.fileName + ".toml");
            }
        });
    }

    @SubscribeEvent
    public static void onConfigLoad(ModConfigEvent.Loading loading) {
        ConfigLoaderImpl.loadConfig((IConfigSpec<ForgeConfigSpec>)loading.getConfig().getSpec());
    }

    @SubscribeEvent
    public static void onConfigReload(ModConfigEvent.Reloading loading) {
        ConfigLoaderImpl.loadConfig((IConfigSpec<ForgeConfigSpec>)loading.getConfig().getSpec());
    }

    private static void loadConfig(IConfigSpec<ForgeConfigSpec> spec) {
        BuiltConfig builtConfig = CONFIGS.get(spec.self());
        if (builtConfig == null) {
            return;
        }
        ConfigLoaderImpl.loadConfig(builtConfig, ((ForgeConfigSpec)spec.self()).getValues());
    }

    private static void loadConfig(BuiltCategory category, UnmodifiableConfig config) {
        config.valueMap().forEach((id, value) -> {
            if (value instanceof ForgeConfigSpec.ConfigValue) {
                ForgeConfigSpec.ConfigValue configValue = (ForgeConfigSpec.ConfigValue)value;
                category.getProperty((String)id).ifPresent(data -> {
                    Object patt0$temp;
                    if (configValue instanceof ForgeConfigSpec.BooleanValue) {
                        ForgeConfigSpec.BooleanValue booleanValue = (ForgeConfigSpec.BooleanValue)configValue;
                        data.setBoolean((Boolean)booleanValue.get());
                    }
                    if (configValue instanceof ForgeConfigSpec.IntValue) {
                        ForgeConfigSpec.IntValue intValue = (ForgeConfigSpec.IntValue)configValue;
                        data.setInt((Integer)intValue.get());
                    }
                    if (configValue instanceof ForgeConfigSpec.DoubleValue) {
                        ForgeConfigSpec.DoubleValue doubleValue = (ForgeConfigSpec.DoubleValue)configValue;
                        data.setDouble((Double)doubleValue.get());
                    }
                    if ((patt0$temp = configValue.get()) instanceof List) {
                        List listVal = (List)patt0$temp;
                        data.setStringArray(listVal.toArray(new String[listVal.size()]));
                    }
                });
            } else if (value instanceof AbstractConfig) {
                AbstractConfig subConfig = (AbstractConfig)value;
                category.getCategory((String)id).ifPresent(cat -> ConfigLoaderImpl.loadConfig(cat, (UnmodifiableConfig)subConfig));
            }
        });
    }

    public static void saveConfig(BuiltConfig cfg) {
        for (Map.Entry<ForgeConfigSpec, BuiltConfig> entry : CONFIGS.entrySet()) {
            if (entry.getValue() != cfg) continue;
            ForgeConfigSpec spec = entry.getKey();
            spec.save();
        }
    }

    public static void registerConfig(BuiltConfig config) {
        try {
            ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
            for (PropertyData property : config.properties) {
                ConfigLoaderImpl.buildProperty(builder, property);
            }
            for (BuiltCategory category : config.categories) {
                ConfigLoaderImpl.buildCategory(builder, category);
            }
            CONFIGS.put(builder.build(), config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void buildCategory(ForgeConfigSpec.Builder builder, BuiltCategory category) throws IllegalAccessException {
        builder.push(category.category);
        if (category.categoryDesc != null) {
            builder.comment(category.categoryDesc);
        }
        for (PropertyData property : category.properties) {
            ConfigLoaderImpl.buildProperty(builder, property);
        }
        for (BuiltCategory builtCategory : category.categories) {
            ConfigLoaderImpl.buildCategory(builder, builtCategory);
        }
        builder.pop();
    }

    private static void buildProperty(ForgeConfigSpec.Builder builder, PropertyData data) throws IllegalAccessException {
        AnnotationData annotationData = data.getData();
        builder.comment(annotationData.description());
        ForgeConfigSpec.BooleanValue val = switch (annotationData.type()) {
            case PropertyType.BOOLEAN -> builder.define(data.getId(), data.getBoolean());
            case PropertyType.INT -> builder.defineInRange(data.getId(), data.getInt(), annotationData.min(), annotationData.max());
            case PropertyType.DOUBLE -> builder.defineInRange(data.getId(), data.getDouble(), annotationData.minD(), annotationData.maxD());
            case PropertyType.STRING_ARRAY -> builder.defineListAllowEmpty(List.of(data.getId()), () -> {
                try {
                    return Arrays.asList(data.getStringArray());
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                    return new ArrayList();
                }
            }, obj -> obj instanceof String);
            default -> throw new IllegalAccessException("Unknown property type.");
        };
        data.setSetter(arg_0 -> ((ForgeConfigSpec.ConfigValue)val).set(arg_0));
    }
}

