/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.common.carry;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.equine.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gamerules.GameRules;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingOtherPlayerPacket;
import tschipp.carryon.platform.Services;

public class PlacementHandler {
    public static boolean tryPlaceBlock(ServerPlayer player, BlockPos pos, Direction facing, @Nullable BiFunction<BlockPos, BlockState, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        boolean canPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            return false;
        }
        if (player.tickCount == carry.getTick()) {
            return false;
        }
        ServerLevel level = player.level();
        BlockState state = carry.getBlock();
        BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)player.position(), (Direction)facing, (BlockPos)pos));
        if (!level.getBlockState(pos).canBeReplaced(context)) {
            pos = pos.relative(facing);
        }
        context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)player.position(), (Direction)facing, (BlockPos)pos));
        BlockEntity blockEntity = carry.getBlockEntity(pos, (HolderLookup.Provider)level.registryAccess());
        boolean bl = canPlace = (state = PlacementHandler.getPlacementState(state, player, context, pos)).canSurvive((LevelReader)level, pos) && level.mayInteract((Entity)player, pos) && level.getBlockState(pos).canBeReplaced(context) && level.isUnobstructed(state, pos, CollisionContext.of((Entity)player));
        if (!canPlace) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LAVA_POP, SoundSource.PLAYERS, 0.5f, 0.5f);
            return false;
        }
        boolean bl2 = doPlace = placementCallback == null || placementCallback.apply(pos, state) != false;
        if (!doPlace) {
            return false;
        }
        if (level.isOutsideBuildHeight(pos)) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.level().getServer().getCommands().performPrefixedCommand(player.level().getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().name() + " run " + cmd);
        }
        level.setBlockAndUpdate(pos, state);
        if (blockEntity != null) {
            blockEntity.setBlockState(state);
            level.setBlockEntity(blockEntity);
        }
        level.updateNeighborsAt(pos.relative(Direction.DOWN), level.getBlockState(pos.relative(Direction.DOWN)).getBlock());
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.playSound(state.getSoundType().getPlaceSound(), 1.0f, 0.5f);
        level.playSound(null, pos, state.getSoundType().getPlaceSound(), SoundSource.BLOCKS, 1.0f, 0.5f);
        player.swing(InteractionHand.MAIN_HAND, true);
        player.removeEffect(MobEffects.SLOWNESS);
        return true;
    }

    private static BlockState getPlacementState(BlockState state, ServerPlayer player, BlockPlaceContext context, BlockPos pos) {
        BlockState placementState = state.getBlock().getStateForPlacement(context);
        if (placementState == null || placementState.getBlock() != state.getBlock()) {
            placementState = state;
        }
        for (Property prop : placementState.getProperties()) {
            if (prop.getValueClass() == Direction.class) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (prop.getValueClass() == Direction.Axis.class) {
                state = PlacementHandler.updateProperty(state, placementState, prop);
            }
            if (!ListHandler.isPropertyException(prop)) continue;
            state = PlacementHandler.updateProperty(state, placementState, prop);
        }
        BlockState updatedState = Block.updateFromNeighbourShapes((BlockState)state, (LevelAccessor)player.level(), (BlockPos)pos);
        if (updatedState.getBlock() == state.getBlock()) {
            state = updatedState;
        }
        if (placementState.hasProperty((Property)BlockStateProperties.WATERLOGGED) && state.hasProperty((Property)BlockStateProperties.WATERLOGGED)) {
            state = (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)((Boolean)placementState.getValue((Property)BlockStateProperties.WATERLOGGED)));
        }
        return state;
    }

    private static <T extends Comparable<T>> BlockState updateProperty(BlockState state, BlockState otherState, Property<T> prop) {
        Comparable val = otherState.getValue(prop);
        return (BlockState)state.setValue(prop, val);
    }

    public static boolean tryPlaceEntity(ServerPlayer player, BlockPos pos, Direction facing, @Nullable BiFunction<Vec3, Entity, Boolean> placementCallback) {
        CarryOnScript.ScriptEffects effects;
        String cmd;
        boolean doPlace;
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return false;
        }
        if (player.tickCount == carry.getTick()) {
            return false;
        }
        ServerLevel level = player.level();
        BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)player.position(), (Direction)facing, (BlockPos)pos));
        if (!level.getBlockState(pos).canBeReplaced(context)) {
            pos = pos.relative(facing);
            context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)player.position(), (Direction)facing, (BlockPos)pos));
        }
        if (!level.getBlockState(pos).canBeReplaced(context)) {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LAVA_POP, SoundSource.PLAYERS, 0.5f, 0.5f);
            return false;
        }
        Vec3 placementPos = Vec3.atBottomCenterOf((Vec3i)pos);
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            Player otherPlayer = carry.getCarryingPlayer((Level)level);
            player.ejectPassengers();
            Services.PLATFORM.sendPacketToAllPlayers(Constants.PACKET_ID_START_RIDING_OTHER, new ClientboundStartRidingOtherPlayerPacket(player.getId(), otherPlayer.getId(), false), player.level());
            carry.clear();
            CarryOnDataManager.setCarryData((Player)player, carry);
            otherPlayer.teleportTo(placementPos.x, placementPos.y, placementPos.z);
            player.swing(InteractionHand.MAIN_HAND, true);
            player.removeEffect(MobEffects.SLOWNESS);
            return true;
        }
        Entity entity = carry.getEntity((Level)level);
        entity.setPos(placementPos);
        boolean bl = doPlace = placementCallback == null || placementCallback.apply(placementPos, entity) != false;
        if (!doPlace) {
            return false;
        }
        if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
            player.level().getServer().getCommands().performPrefixedCommand(player.level().getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().name() + " run " + cmd);
        }
        level.addFreshEntity(entity);
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            mob.playAmbientSound();
        }
        player.swing(InteractionHand.MAIN_HAND, true);
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.removeEffect(MobEffects.SLOWNESS);
        return true;
    }

    public static void tryStackEntity(ServerPlayer player, Entity entityClicked) {
        if (!Constants.COMMON_CONFIG.settings.stackableEntities) {
            return;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) && !carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return;
        }
        ServerLevel level = player.level();
        Entity entityHeld = carry.isCarrying(CarryOnData.CarryType.ENTITY) ? carry.getEntity((Level)level) : player.getFirstPassenger();
        if (entityHeld == null) {
            return;
        }
        double sizeHeldEntity = entityHeld.getBbHeight() * entityHeld.getBbWidth();
        double distance = entityClicked.blockPosition().distSqr((Vec3i)player.blockPosition());
        Entity lowestEntity = entityClicked.getRootVehicle();
        int numPassengers = PlacementHandler.getPassengerCount(lowestEntity);
        if (numPassengers < Constants.COMMON_CONFIG.settings.maxEntityStackLimit - 1) {
            Entity topEntity = PlacementHandler.getTopPassenger(lowestEntity);
            if (topEntity == entityHeld) {
                return;
            }
            if (ListHandler.isStackingPermitted(topEntity)) {
                double sizeEntity = topEntity.getBbHeight() * topEntity.getBbWidth();
                if (!Constants.COMMON_CONFIG.settings.entitySizeMattersStacking || sizeHeldEntity <= sizeEntity) {
                    CarryOnScript.ScriptEffects effects;
                    String cmd;
                    if (topEntity instanceof Horse) {
                        Horse horse = (Horse)topEntity;
                        horse.setTamed(true);
                    }
                    if (distance < 6.0) {
                        double tempX = entityClicked.getX();
                        double tempY = entityClicked.getY();
                        double tempZ = entityClicked.getZ();
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.setPos(tempX, tempY + 2.6, tempZ);
                            level.addFreshEntity(entityHeld);
                            entityHeld.teleportTo(tempX, tempY, tempZ);
                        }
                        entityHeld.startRiding(topEntity, false, false);
                    } else {
                        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                            entityHeld.setPos(entityClicked.getX(), entityClicked.getY(), entityClicked.getZ());
                            level.addFreshEntity(entityHeld);
                        }
                        entityHeld.startRiding(topEntity, false, false);
                    }
                    if (carry.getActiveScript().isPresent() && !(cmd = (effects = carry.getActiveScript().get().scriptEffects()).commandPlace()).isEmpty()) {
                        player.level().getServer().getCommands().performPrefixedCommand(player.level().getServer().createCommandSourceStack(), "/execute as " + player.getGameProfile().name() + " run " + cmd);
                    }
                    player.swing(InteractionHand.MAIN_HAND, true);
                    carry.clear();
                    CarryOnDataManager.setCarryData((Player)player, carry);
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), (Holder)SoundEvents.HORSE_SADDLE, SoundSource.PLAYERS, 0.5f, 1.5f);
                    player.removeEffect(MobEffects.SLOWNESS);
                } else {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LAVA_POP, SoundSource.PLAYERS, 0.5f, 0.5f);
                }
            }
        } else {
            level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.LAVA_POP, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
    }

    public static void placeCarriedOnDeath(ServerPlayer oldPlayer, ServerPlayer newPlayer, boolean died) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)oldPlayer);
        if (!(!((Boolean)oldPlayer.level().getGameRules().get(GameRules.KEEP_INVENTORY)).booleanValue() && died || carry.isCarrying(CarryOnData.CarryType.PLAYER))) {
            CarryOnDataManager.setCarryData((Player)newPlayer, carry);
            newPlayer.getInventory().setSelectedSlot(oldPlayer.getInventory().getSelectedSlot());
            return;
        }
        PlacementHandler.placeCarried(oldPlayer);
    }

    public static void placeCarried(ServerPlayer player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((Player)player);
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            Entity entity = carry.getEntity((Level)player.level());
            entity.setPos(player.position());
            player.level().addFreshEntity(entity);
        } else if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)Vec3.atCenterOf((Vec3i)player.blockPosition()), (Direction)Direction.DOWN, (BlockPos)player.blockPosition()));
            BlockState state = PlacementHandler.getPlacementState(carry.getBlock(), player, context, player.blockPosition());
            BlockPos pos = PlacementHandler.getDeathPlacementPos(state, player);
            BlockEntity blockEntity = carry.getBlockEntity(pos, (HolderLookup.Provider)player.level().registryAccess());
            player.level().setBlock(pos, state, 3);
            if (blockEntity != null) {
                player.level().setBlockEntity(blockEntity);
            }
        } else if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            player.ejectPassengers();
        }
        carry.clear();
        CarryOnDataManager.setCarryData((Player)player, carry);
        player.removeEffect(MobEffects.SLOWNESS);
    }

    private static BlockPos getDeathPlacementPos(BlockState state, ServerPlayer player) {
        BlockPos p = player.blockPosition();
        int DISTANCE = 15;
        ArrayList<BlockPos> potentialPositions = new ArrayList<BlockPos>();
        for (int j = 0; j < DISTANCE * 2; ++j) {
            for (int i = 0; i < DISTANCE * 2; ++i) {
                for (int k = 0; k < DISTANCE * 2; ++k) {
                    int x = i % 2 == 0 ? i / 2 : -(i / 2);
                    int y = j % 2 == 0 ? j / 2 : -(j / 2);
                    int z = k % 2 == 0 ? k / 2 : -(k / 2);
                    potentialPositions.add(new BlockPos(p.getX() + x, p.getY() + y, p.getZ() + z));
                }
            }
        }
        potentialPositions.sort(Comparator.comparingDouble(posA -> player.distanceToSqr(posA.getCenter())));
        for (BlockPos potential : potentialPositions) {
            BlockPlaceContext context = new BlockPlaceContext((Player)player, InteractionHand.MAIN_HAND, ItemStack.EMPTY, BlockHitResult.miss((Vec3)Vec3.atCenterOf((Vec3i)potential), (Direction)Direction.DOWN, (BlockPos)potential));
            boolean canPlace = state.canSurvive((LevelReader)player.level(), potential) && player.level().getBlockState(potential).canBeReplaced(context) && player.level().isUnobstructed(state, potential, CollisionContext.of((Entity)player));
            if (!canPlace) continue;
            return potential;
        }
        return p;
    }

    private static int getPassengerCount(Entity entity) {
        int passengers = 0;
        while (entity.isVehicle()) {
            List pass = entity.getPassengers();
            if (pass.isEmpty()) continue;
            entity = (Entity)pass.get(0);
            ++passengers;
        }
        return passengers;
    }

    private static Entity getTopPassenger(Entity entity) {
        Entity top = entity;
        while (entity.isVehicle()) {
            List pass = entity.getPassengers();
            if (pass.isEmpty()) continue;
            top = entity = (Entity)pass.get(0);
        }
        return top;
    }
}

