/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.math.Axis;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import tschipp.carryon.Constants;
import tschipp.carryon.client.render.CarryRenderHelper;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.platform.Services;

public class CarriedObjectRender {
    public static boolean drawFirstPerson(Player player, MultiBufferSource buffer, PoseStack matrix, int light, float partialTicks) {
        if (Services.PLATFORM.isModLoaded("firstperson") || Services.PLATFORM.isModLoaded("firstpersonmod")) {
            return false;
        }
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        try {
            if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                CarriedObjectRender.drawFirstPersonBlock(player, buffer, matrix, light, CarryRenderHelper.getRenderState(player));
            } else if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
                CarriedObjectRender.drawFirstPersonEntity(player, buffer, matrix, light, partialTicks);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (carry.getActiveScript().isPresent()) {
            CarryOnScript.ScriptRender render = carry.getActiveScript().get().scriptRender();
            if (!render.renderLeftArm() && player.m_5737_() == HumanoidArm.LEFT) {
                return false;
            }
            if (!render.renderRightArm() && player.m_5737_() == HumanoidArm.RIGHT) {
                return false;
            }
        }
        return carry.isCarrying();
    }

    private static void drawFirstPersonBlock(Player player, MultiBufferSource buffer, PoseStack matrix, int light, BlockState state) {
        matrix.m_85836_();
        matrix.m_85841_(2.5f, 2.5f, 2.5f);
        matrix.m_85837_(0.0, -0.5, -1.0);
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (Constants.CLIENT_CONFIG.facePlayer != CarryRenderHelper.isChest(state.m_60734_())) {
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_252781_(Axis.f_252495_.m_252977_(8.0f));
        } else {
            matrix.m_252781_(Axis.f_252529_.m_252977_(8.0f));
        }
        if (carry.getActiveScript().isPresent()) {
            CarryRenderHelper.performScriptTransformation(matrix, carry.getActiveScript().get());
        }
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        ItemStack stack = new ItemStack((ItemLike)state.m_60734_().m_5456_());
        BakedModel model = CarryRenderHelper.getRenderBlock(player);
        CarryRenderHelper.renderBakedModel(stack, matrix, buffer, light, model);
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        matrix.m_85849_();
    }

    private static void drawFirstPersonEntity(Player player, MultiBufferSource buffer, PoseStack matrix, int light, float partialTicks) {
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        Entity entity = CarryRenderHelper.getRenderEntity(player);
        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if (entity != null) {
            Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialTicks);
            entity.m_6034_(playerpos.f_82479_, playerpos.f_82480_, playerpos.f_82481_);
            entity.f_19860_ = 0.0f;
            entity.f_19859_ = 0.0f;
            entity.m_5616_(0.0f);
            float height = entity.m_20206_();
            float width = entity.m_20205_();
            matrix.m_85836_();
            matrix.m_85841_(0.8f, 0.8f, 0.8f);
            matrix.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            matrix.m_85837_(0.0, (double)(-height) - 0.1, (double)width + 0.1);
            manager.m_114468_(false);
            Optional<CarryOnScript> res = carry.getActiveScript();
            if (res.isPresent()) {
                CarryOnScript script = res.get();
                CarryRenderHelper.performScriptTransformation(matrix, script);
            }
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).f_20916_ = 0;
            }
            try {
                manager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, buffer, light);
            }
            catch (Exception exception) {
                // empty catch block
            }
            manager.m_114468_(true);
            matrix.m_85849_();
        }
    }

    public static void drawThirdPerson(float partialticks, PoseStack matrix) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        int light = 0;
        int perspective = CarryRenderHelper.getPerspective();
        EntityRenderDispatcher manager = mc.m_91290_();
        RenderSystem.enableBlend();
        RenderSystem.disableCull();
        RenderSystem.disableDepthTest();
        Map<RenderType, BufferBuilder> builders = Map.of(RenderType.m_110490_(), new BufferBuilder(RenderType.m_110490_().m_110507_()), RenderType.m_110493_(), new BufferBuilder(RenderType.m_110493_().m_110507_()), RenderType.m_110487_(), new BufferBuilder(RenderType.m_110487_().m_110507_()), RenderType.m_110496_(), new BufferBuilder(RenderType.m_110496_().m_110507_()), RenderType.m_110499_(), new BufferBuilder(RenderType.m_110499_().m_110507_()));
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109900_(builders, (BufferBuilder)Tesselator.m_85913_().m_85915_());
        for (Player player : level.m_6907_()) {
            try {
                Entity entity;
                CarryOnData carry = CarryOnDataManager.getCarryData(player);
                if (perspective == 0 && player == mc.f_91074_ && !Services.PLATFORM.isModLoaded("firstperson") && !Services.PLATFORM.isModLoaded("firstpersonmod")) continue;
                light = manager.m_114394_((Entity)player, partialticks);
                if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
                    BlockState state = CarryRenderHelper.getRenderState(player);
                    CarryRenderHelper.applyBlockTransformations(player, partialticks, matrix, state.m_60734_());
                    ItemStack tileItem = new ItemStack((ItemLike)state.m_60734_().m_5456_());
                    BakedModel model = CarryRenderHelper.getRenderBlock(player);
                    Optional<CarryOnScript> res = carry.getActiveScript();
                    if (res.isPresent()) {
                        CarryOnScript script = res.get();
                        CarryRenderHelper.performScriptTransformation(matrix, script);
                    }
                    RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
                    RenderSystem.enableCull();
                    PoseStack.Pose p = matrix.m_85850_();
                    PoseStack copy = new PoseStack();
                    copy.m_252931_(p.m_252922_());
                    matrix.m_85849_();
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    CarryRenderHelper.renderBakedModel(tileItem, copy, (MultiBufferSource)buffer, light, model);
                    matrix.m_85849_();
                    continue;
                }
                if (!carry.isCarrying(CarryOnData.CarryType.ENTITY) || (entity = CarryRenderHelper.getRenderEntity(player)) == null) continue;
                CarryRenderHelper.applyEntityTransformations(player, partialticks, matrix, entity);
                manager.m_114468_(false);
                Optional<CarryOnScript> res = carry.getActiveScript();
                if (res.isPresent()) {
                    CarryOnScript script = res.get();
                    CarryRenderHelper.performScriptTransformation(matrix, script);
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)entity;
                    le.f_20916_ = 0;
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                manager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, (MultiBufferSource)buffer, light);
                matrix.m_85849_();
                manager.m_114468_(true);
                matrix.m_85849_();
            }
            catch (Exception exception) {}
        }
        buffer.m_173043_();
        buffer.m_109912_(RenderType.m_110446_((ResourceLocation)TextureAtlas.f_118259_));
        buffer.m_109912_(RenderType.m_110452_((ResourceLocation)TextureAtlas.f_118259_));
        buffer.m_109912_(RenderType.m_110458_((ResourceLocation)TextureAtlas.f_118259_));
        buffer.m_109912_(RenderType.m_110476_((ResourceLocation)TextureAtlas.f_118259_));
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
    }
}

