/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon;

import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7877;
import net.minecraft.class_7923;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.PlacementHandler;
import tschipp.carryon.common.command.CommandCarryOn;
import tschipp.carryon.config.ConfigLoader;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingOtherPlayerPacket;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.networking.clientbound.ClientboundSyncScriptsPacket;
import tschipp.carryon.networking.serverbound.ServerboundCarryKeyPressedPacket;
import tschipp.carryon.platform.Services;

public class CarryOnCommon {
    public static final class_7877 BUILDER = new class_7877();

    public static class_7225.class_7874 createLookup() {
        class_5455.class_6890 registryaccess$frozen = class_5455.method_40302((class_2378)class_7923.field_41167);
        class_7225.class_7874 holderlookup$provider = BUILDER.method_46780((class_5455)registryaccess$frozen);
        return holderlookup$provider;
    }

    public static void registerServerPackets(Object ... args) {
        Services.PLATFORM.registerServerboundPacket(ServerboundCarryKeyPressedPacket.TYPE, ServerboundCarryKeyPressedPacket.class, ServerboundCarryKeyPressedPacket.CODEC, ServerboundCarryKeyPressedPacket::handle, args);
    }

    public static void registerClientPackets(Object ... args) {
        Services.PLATFORM.registerClientboundPacket(ClientboundStartRidingPacket.TYPE, ClientboundStartRidingPacket.class, ClientboundStartRidingPacket.CODEC, ClientboundStartRidingPacket::handle, args);
        Services.PLATFORM.registerClientboundPacket(ClientboundSyncScriptsPacket.TYPE, ClientboundSyncScriptsPacket.class, ClientboundSyncScriptsPacket.CODEC, ClientboundSyncScriptsPacket::handle, args);
        Services.PLATFORM.registerClientboundPacket(ClientboundStartRidingOtherPlayerPacket.TYPE, ClientboundStartRidingOtherPlayerPacket.class, ClientboundStartRidingOtherPlayerPacket.CODEC, ClientboundStartRidingOtherPlayerPacket::handle, args);
    }

    public static void registerConfig() {
        ConfigLoader.registerConfig(Constants.COMMON_CONFIG);
        ConfigLoader.registerConfig(Constants.CLIENT_CONFIG);
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        CommandCarryOn.register(dispatcher);
    }

    public static void onCarryTick(class_3222 player) {
        CarryOnData carry = CarryOnDataManager.getCarryData((class_1657)player);
        if (carry.isCarrying()) {
            String cmd;
            if (player.field_6012 == 1) {
                CarryOnDataManager.setCarryData((class_1657)player, carry);
            }
            if (carry.getActiveScript().isPresent() && !(cmd = carry.getActiveScript().get().scriptEffects().commandLoop()).isEmpty()) {
                player.method_51469().method_8503().method_3734().method_44252(player.method_51469().method_8503().method_3739(), "/execute as " + player.method_7334().name() + " run " + cmd);
            }
            class_1661 inv = player.method_31548();
            inv.method_61496(carry.getSelected());
        }
    }

    public static boolean onTryBreakBlock(class_1657 player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static boolean onAttackedByPlayer(class_1657 player) {
        CarryOnData carry;
        return player == null || Constants.COMMON_CONFIG.settings.hitWhileCarrying || !(carry = CarryOnDataManager.getCarryData(player)).isCarrying();
    }

    public static void onPlayerAttacked(class_1657 player) {
        CarryOnData carry;
        if (Constants.COMMON_CONFIG.settings.dropCarriedWhenHit && !player.method_73183().method_8608() && (carry = CarryOnDataManager.getCarryData(player)).isCarrying()) {
            PlacementHandler.placeCarried((class_3222)player);
        }
    }

    public static void onRiderDisconnected(class_1657 rider) {
        class_3222 vehicle;
        CarryOnData data;
        class_1297 class_12972 = rider.method_5854();
        if (class_12972 instanceof class_3222 && (data = CarryOnDataManager.getCarryData((class_1657)(vehicle = (class_3222)class_12972))).isCarrying(CarryOnData.CarryType.PLAYER)) {
            PlacementHandler.placeCarried(vehicle);
        }
    }

    public static int potionLevel(CarryOnData carry, class_1937 level) {
        if (carry.isCarrying(CarryOnData.CarryType.PLAYER)) {
            return 1;
        }
        if (carry.isCarrying(CarryOnData.CarryType.ENTITY)) {
            class_1297 entity = carry.getEntity(level);
            int i = (int)(entity.method_17682() * entity.method_17681());
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyEntities) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.entitySlownessMultiplier);
        }
        if (carry.isCarrying(CarryOnData.CarryType.BLOCK)) {
            String nbt = carry.getNbt().toString();
            int i = nbt.length() / 500;
            if (i > 4) {
                i = 4;
            }
            if (!Constants.COMMON_CONFIG.settings.heavyTiles) {
                i = 1;
            }
            return (int)((double)i * Constants.COMMON_CONFIG.settings.blockSlownessMultiplier);
        }
        return 0;
    }
}

