/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.common.carry.CarryOnData.CarryType;

import java.util.Optional;
import net.minecraft.class_11368;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;

@Mixin(class_1657.class)
public abstract class PlayerMixin extends class_1309  {

    private PlayerMixin(class_1299<? extends class_1309> type, class_1937 level) {
        super(type, level);
    }

    //We leave this in here to ensure cross-compatibility if world are upgraded from <1.21.8. Should be removed in the future.
    @Inject(method = "readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V", at = @At("RETURN"))
    private void onReadAdditionalSaveData(class_11368 input, CallbackInfo ci)
    {
        Optional<CarryOnData> res = input.method_71426("CarryOnData", CarryOnData.CODEC);
        res.ifPresent(data -> CarryOnDataManager.setCarryData((class_1657)((Object)this), data));
    }


    @Override
    public void method_5848() {
        class_1297 entity = this.method_5854();
        if (entity instanceof class_1657 && entity.method_5685().size() < 2){
            CarryOnData carry = CarryOnDataManager.getCarryData((class_1657) entity);
            if (carry.getType() == CarryType.PLAYER){
                carry.clear();
                ((class_1657) entity).method_6016(class_1294.field_5909);
            }
        }
        super.method_5848();
    }
}
