/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.class_1297;
import net.minecraft.class_1297.class_4738;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import tschipp.carryon.Constants;
import tschipp.carryon.common.carry.CarryOnData;
import tschipp.carryon.common.carry.CarryOnData.CarryType;
import tschipp.carryon.common.carry.CarryOnDataManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingPacket;
import tschipp.carryon.platform.Services;

@Mixin(class_1297.class)
public abstract class EntityMixin
{
	@Shadow
	public boolean hasPassenger(class_1297 pEntity) {throw new IllegalStateException("EntityMixin application failed");}


	@ModifyExpressionValue(method = "startRiding(Lnet/minecraft/world/entity/Entity;ZZ)Z", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/EntityType;canSerialize()Z"))
	private boolean onStartRidingCheck(boolean original, class_1297 entity, boolean force) {
		if (force && entity instanceof class_1657) return true;
		return original;
	}

	@Shadow public abstract void onPassengerTurned(class_1297 $$0);

	@Inject(method = "positionRider(Lnet/minecraft/world/entity/Entity;Lnet/minecraft/world/entity/Entity$MoveFunction;)V", at = @At("HEAD"), cancellable = true)
	private void onPositionPassenger(class_1297 entity, class_4738 move, CallbackInfo ci)
	{
		if((Object)this instanceof class_1657 thisPlayer && entity instanceof class_1657 otherPlayer)
		{
			if(hasPassenger(otherPlayer) && CarryOnDataManager.getCarryData(thisPlayer).isCarrying(CarryType.PLAYER))
			{
				class_243 forward = new class_243(0, 0, 0.6);
				class_243 otherPos = thisPlayer.method_73189().method_1019(forward.method_1024((float) Math.toRadians(-thisPlayer.field_6283)));
				otherPos = otherPos.method_1031(0, 0.4,0);
				move.accept(otherPlayer, otherPos.field_1352, otherPos.field_1351, otherPos.field_1350);
				((class_1297)((Object)this)).method_5644(otherPlayer);
				ci.cancel();
			}
		}

	}

	@Inject(method = "getDismountLocationForPassenger(Lnet/minecraft/world/entity/LivingEntity;)Lnet/minecraft/world/phys/Vec3;", at = @At("HEAD"))
	private void onDismountPassenger(class_1309 living, CallbackInfoReturnable<class_243> cir)
	{
		if((Object)this instanceof class_1657 thisPlayer && living instanceof class_1657 otherPlayer)
		{
			CarryOnData carry = CarryOnDataManager.getCarryData(thisPlayer);
			if(carry.isCarrying(CarryType.PLAYER))
			{
				carry.clear();
				CarryOnDataManager.setCarryData(thisPlayer, carry);
				Services.PLATFORM.sendPacketToPlayer(Constants.PACKET_ID_START_RIDING, new ClientboundStartRidingPacket(otherPlayer.method_5628(), false), (class_3222) thisPlayer);
			}
		}
	}

	@Inject(method = "onPassengerTurned(Lnet/minecraft/world/entity/Entity;)V", at = @At("HEAD"))
	private void onPassengerTurned(class_1297 toUpdate, CallbackInfo ci)
	{
		if((Object)this instanceof class_1657 thisPlayer && toUpdate instanceof class_1657)
		{
			CarryOnData carry = CarryOnDataManager.getCarryData(thisPlayer);
			if(carry.isCarrying(CarryType.PLAYER)) {
				this.clampRotation(toUpdate);
			}
		}
	}

	@Unique
	private void clampRotation(class_1297 pEntityToUpdate) {
		class_1297 thisEntity = (class_1297)((Object)this);
		pEntityToUpdate.method_5636(thisEntity.method_36454());
		float f = class_3532.method_15393(pEntityToUpdate.method_36454() - thisEntity.method_36454());
		float f1 = class_3532.method_15363(f, -30.0F, 30.0F);
		pEntityToUpdate.field_5982 += f1 - f;
		pEntityToUpdate.method_36456(pEntityToUpdate.method_36454() + f1 - f);
		pEntityToUpdate.method_5847(pEntityToUpdate.method_36454());
	}
}
