/*
 * GNU Lesser General Public License v3
 * Copyright (C) 2024 Tschipp
 * mrtschipp@gmail.com
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

package tschipp.carryon.common.carry;

import tschipp.carryon.CarryOnCommon;
import tschipp.carryon.Constants;
import tschipp.carryon.common.config.ListHandler;
import tschipp.carryon.common.pickupcondition.PickupCondition;
import tschipp.carryon.common.pickupcondition.PickupConditionHandler;
import tschipp.carryon.common.scripting.CarryOnScript;
import tschipp.carryon.common.scripting.ScriptManager;
import tschipp.carryon.networking.clientbound.ClientboundStartRidingOtherPlayerPacket;
import tschipp.carryon.platform.Services;

import javax.annotation.Nullable;
import net.minecraft.class_10583;
import net.minecraft.class_11362;
import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1297.class_5529;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1321;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_8942;
import java.util.Optional;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;

public class PickupHandler {

    public static boolean canCarryGeneral(class_3222 player, class_243 pos)
    {
        if(!player.method_6047().method_7960() || !player.method_6079().method_7960())
            return false;

        if(player.method_73189().method_1022(pos) > Constants.COMMON_CONFIG.settings.maxDistance)
            return false;

        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        if(carry.isCarrying())
            return false;

        if(!carry.isKeyPressed())
            return false;

        //Needed so that we don't pick up and place in the same tick
        if(player.field_6012 == carry.getTick())
            return false;

        if (player.field_13974.method_14257() == class_1934.field_9219 || player.field_13974.method_14257() == class_1934.field_9216)
            return false;



        return true;
    }


    public static boolean tryPickUpBlock(class_3222 player, class_2338 pos, class_1937 level, @Nullable BiFunction<class_2680, class_2338, Boolean> pickupCallback)
    {
        if(!canCarryGeneral(player, class_243.method_24953(pos)))
            return false;

        CarryOnData carry = CarryOnDataManager.getCarryData(player);
        class_2586 blockEntity = level.method_8321(pos);
        class_2680 state = level.method_8320(pos);
        class_2487 nbt = null;
        if(blockEntity != null) {
            class_11362 output = class_11362.method_71459(new class_8942.class_11340(Constants.LOG), level.method_30349());
            blockEntity.method_38243(output);
            nbt = output.method_71475();
        }

        if(!ListHandler.isPermitted(state.method_26204()))
            return false;

        // Reject pickup of Double blocks, if they use the vanilla property
        if(hasPropertyType(state, class_2323.field_10946))
            return false;

        if(state.method_26214(level, pos) == -1 && !player.method_68878() && !Constants.COMMON_CONFIG.settings.pickupUnbreakableBlocks)
            return false;

        if(blockEntity == null && !Constants.COMMON_CONFIG.settings.pickupAllBlocks)
            return false;

        //Check if TE is locked
        if(blockEntity != null)
        {
            if(nbt.method_10545("Lock") && !nbt.method_10558("Lock").equals(""))
                return false;
        }

        Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(state);
        if(cond.isPresent())
        {
            if(!cond.get().isFulfilled(player))
                return false;
        }

        boolean doPickup = pickupCallback == null ? true : pickupCallback.apply(state, pos);
        if(!doPickup)
            return false;

        Optional<CarryOnScript> result =  ScriptManager.inspectBlock(state, level, pos, nbt);
        if(result.isPresent())
        {
            CarryOnScript script = result.get();
            if(!script.fulfillsConditions(player))
                return false;

            carry.setActiveScript(script);

            String cmd = script.scriptEffects().commandInit();
            if(!cmd.isEmpty())
                player.method_51469().method_8503().method_3734().method_44252(player.method_51469().method_8503().method_3739(), "/execute as " + player.method_7334().name() + " run " + cmd);
        }

        carry.setBlock(state, blockEntity, player, pos);

        level.method_8544(pos);
        level.method_8650(pos, false);

        CarryOnDataManager.setCarryData(player, carry);
        level.method_8396(null, pos, state.method_26231().method_10596(), class_3419.field_15245, 1.0f, 0.5f);
        player.method_23667(class_1268.field_5808, true);
        if (!player.method_68878() || Constants.COMMON_CONFIG.settings.slownessInCreative)
            player.method_6092(new class_1293(class_1294.field_5909, 100000000, CarryOnCommon.potionLevel(carry, player.method_51469()), false, false));
        return true;
    }



    public static boolean tryPickupEntity(class_3222 player, class_1297 entity, @Nullable Function<class_1297, Boolean> pickupCallback)
    {
        if(!canCarryGeneral(player, entity.method_73189()))
            return false;

        if (entity.field_6008 != 0)
            return false;

        if(entity.method_31481())
            return false;

        if (entity instanceof class_1321 tame)
        {
            class_10583<class_1309> ref  = tame.method_66287();
            if (ref != null) {
                UUID owner = ref.method_66263();
                UUID playerID = player.method_7334().id();
                if (!owner.equals(playerID))
                    return false;
            }
        }

        if(!ListHandler.isPermitted(entity))
        {
            //We can pick up baby animals even if the grown up animal is blacklisted.
            if(!(entity instanceof class_1296 ageableMob && Constants.COMMON_CONFIG.settings.allowBabies && (ageableMob.method_5618() < 0 || ageableMob.method_6109())))
                return false;
        }

        //Non-Creative only guards
        if(!player.method_68878())
        {
            if(!Constants.COMMON_CONFIG.settings.pickupHostileMobs && entity.method_5864().method_5891() == class_1311.field_6302)
                return false;

            if(Constants.COMMON_CONFIG.settings.maxEntityHeight < entity.method_17682() || Constants.COMMON_CONFIG.settings.maxEntityWidth < entity.method_17681())
                return false;
        }

        Optional<PickupCondition> cond = PickupConditionHandler.getPickupCondition(entity);
        if(cond.isPresent())
        {
            if(!cond.get().isFulfilled(player))
                return false;
        }

        boolean doPickup = pickupCallback == null || pickupCallback.apply(entity);
        if(!doPickup)
            return false;

        CarryOnData carry = CarryOnDataManager.getCarryData(player);

        Optional<CarryOnScript> result =  ScriptManager.inspectEntity(entity);
        if(result.isPresent())
        {
            CarryOnScript script = result.get();
            if(!script.fulfillsConditions(player))
                return false;

            carry.setActiveScript(script);
        }

        if (entity instanceof class_1657 otherPlayer) {
            if (!Constants.COMMON_CONFIG.settings.pickupPlayers)
                return false;

            if (!player.method_68878() && otherPlayer.method_68878())
                return false;

            otherPlayer.method_5772();
            otherPlayer.method_5848();

            if (result.isPresent()) {
                String cmd = result.get().scriptEffects().commandInit();
                if (!cmd.isEmpty())
                    player.method_51469().method_8503().method_3734().method_44252(player.method_51469().method_8503().method_3739(), "/execute as " + player.method_7334().name() + " run " + cmd);
            }

            otherPlayer.method_5873(player, true, false);
            Services.PLATFORM.sendPacketToAllPlayers(Constants.PACKET_ID_START_RIDING_OTHER, new ClientboundStartRidingOtherPlayerPacket(player.method_5628(), otherPlayer.method_5628(), true), player.method_51469());
            carry.setCarryingPlayer(otherPlayer);
            player.method_23667(class_1268.field_5808, true);
            player.method_51469().method_8396(null, player.method_23312(), class_3417.field_14883.comp_349(), class_3419.field_15256, 1.0f, 0.5f);
            CarryOnDataManager.setCarryData(player, carry);
            if (!player.method_68878() || Constants.COMMON_CONFIG.settings.slownessInCreative)
                player.method_6092(new class_1293(class_1294.field_5909, 100000000, CarryOnCommon.potionLevel(carry, player.method_51469()), false, false));
            return true;

        }

        entity.method_5772();
        entity.method_5848();
        if (entity instanceof class_1429 animal) {
            animal.method_5932();
        }

        if(result.isPresent())
        {
            String cmd = result.get().scriptEffects().commandInit();
            if(!cmd.isEmpty())
                player.method_51469().method_8503().method_3734().method_44252(player.method_51469().method_8503().method_3739(), "/execute as " + player.method_7334().name() + " run " + cmd);
        }

        carry.setEntity(entity);
        entity.method_5650(class_5529.field_27001);

        player.method_51469().method_8396(null, player.method_23312(), class_3417.field_14883.comp_349(), class_3419.field_15256, 1.0f, 0.5f);
        CarryOnDataManager.setCarryData(player, carry);
        player.method_23667(class_1268.field_5808, true);
        if (!player.method_68878() || Constants.COMMON_CONFIG.settings.slownessInCreative)
            player.method_6092(new class_1293(class_1294.field_5909, 100000000, CarryOnCommon.potionLevel(carry, player.method_51469()), false, false));
        return true;
    }

    private static <T extends Comparable<T>> boolean hasPropertyType(class_2680 state, class_2769<T> prop) {
        for (var p : state.method_28501()) {
            if(p.method_11902().equals(prop.method_11902()))
                return true;
        }
        return false;
    }

}
