/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.compat;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import tschipp.carryon.config.AnnotationData;
import tschipp.carryon.config.BuiltCategory;
import tschipp.carryon.config.BuiltConfig;

public record ClothConfigCompat(BuiltConfig client, BuiltConfig common, Runnable onSave) {
    public static class_437 getConfigScreen(BuiltConfig client, BuiltConfig common, class_437 parentScreen, Runnable onSave) {
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parentScreen).setTitle((class_2561)class_2561.method_43471((String)"key.carry.category"));
        ClothConfigCompat.buildConfigType(client, builder, "Client Config");
        ClothConfigCompat.buildConfigType(common, builder, "Common Config");
        builder.setSavingRunnable(onSave);
        return builder.build();
    }

    private static void buildConfigType(BuiltConfig cfg, ConfigBuilder builder, String name) {
        ConfigCategory configCategory = builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)name));
        ClothConfigCompat.buildProperties(cfg, configCategory, builder, null);
    }

    private static void buildCategory(BuiltCategory category, ConfigCategory categoryBuilder, ConfigBuilder builder) {
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        SubCategoryBuilder subBuilder = entryBuilder.startSubCategory((class_2561)class_2561.method_43471((String)category.translation));
        ClothConfigCompat.buildProperties(category, categoryBuilder, builder, subBuilder);
    }

    private static void buildProperties(BuiltCategory category, ConfigCategory categoryBuilder, ConfigBuilder builder, @Nullable SubCategoryBuilder subBuilder) {
        category.categories.forEach(cat -> ClothConfigCompat.buildCategory(cat, categoryBuilder, builder));
        ConfigEntryBuilder entryBuilder = builder.entryBuilder();
        category.properties.forEach(propertyData -> {
            try {
                BooleanListEntry entry;
                AnnotationData data = propertyData.getData();
                switch (data.type()) {
                    case BOOLEAN: {
                        BooleanListEntry booleanListEntry = entryBuilder.startBooleanToggle((class_2561)class_2561.method_43470((String)propertyData.getField().getName()), propertyData.getBoolean()).setTooltip(new class_2561[]{class_2561.method_43470((String)data.description())}).setDefaultValue(propertyData.getDefaultBoolean()).setSaveConsumer(propertyData.getSetter()).build();
                        break;
                    }
                    case INT: {
                        BooleanListEntry booleanListEntry = entryBuilder.startIntField((class_2561)class_2561.method_43470((String)propertyData.getField().getName()), propertyData.getInt()).setTooltip(new class_2561[]{class_2561.method_43470((String)data.description())}).setDefaultValue(propertyData.getDefaultInt()).setMin(data.min()).setMax(data.max()).setSaveConsumer(propertyData.getSetter()).build();
                        break;
                    }
                    case DOUBLE: {
                        BooleanListEntry booleanListEntry = entryBuilder.startDoubleField((class_2561)class_2561.method_43470((String)propertyData.getField().getName()), propertyData.getDouble()).setTooltip(new class_2561[]{class_2561.method_43470((String)data.description())}).setDefaultValue(propertyData.getDefaultDouble()).setMin(data.minD()).setMax(data.maxD()).setSaveConsumer(propertyData.getSetter()).build();
                        break;
                    }
                    case STRING_ARRAY: {
                        BooleanListEntry booleanListEntry = entryBuilder.startStrList((class_2561)class_2561.method_43470((String)propertyData.getField().getName()), List.of(propertyData.getStringArray())).setTooltip(new class_2561[]{class_2561.method_43470((String)data.description())}).setInsertInFront(true).setDefaultValue(List.of(propertyData.getDefaultStringArray())).setCellErrorSupplier(str -> str.matches(data.validationRegex()) ? Optional.empty() : Optional.of(class_2561.method_43470((String)"Invalid Format"))).setSaveConsumer(propertyData.getSetter()).build();
                        break;
                    }
                    default: {
                        BooleanListEntry booleanListEntry = entry = null;
                    }
                }
                if (subBuilder == null) {
                    categoryBuilder.addEntry(entry);
                } else {
                    subBuilder.add(entry);
                }
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });
        if (subBuilder != null) {
            categoryBuilder.addEntry((AbstractConfigListEntry)subBuilder.build());
        }
    }
}

